/*
 * Decompiled with CFR 0.152.
 */
package de.upb.ois.nt2.client;

import de.upb.ois.nt2.data.ConfigurationData;
import de.upb.ois.nt2.remote.NotesDelegate;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ConfigureClient
extends JFrame {
    private ConfigurationData data = new ConfigurationData();
    private JLabel smtpLabel;
    private JButton getConfigButton;
    private JTextField smtpField;
    private JTextField passField;
    private JButton setConfigButton;
    private JCheckBox debugBox;
    private JLabel serverLabel;
    private JPanel configPane;
    private JPanel servicePane;
    private JLabel userLabel;
    private JTextField serverField;
    private JTextField userField;
    private JLabel debugLable;
    private JLabel passLabel;

    public ConfigureClient() {
        this.initComponents();
    }

    private void initComponents() {
        this.servicePane = new JPanel();
        this.serverLabel = new JLabel();
        this.serverField = new JTextField();
        this.getConfigButton = new JButton();
        this.configPane = new JPanel();
        this.smtpLabel = new JLabel();
        this.smtpField = new JTextField();
        this.userLabel = new JLabel();
        this.userField = new JTextField();
        this.passLabel = new JLabel();
        this.passField = new JTextField();
        this.debugLable = new JLabel();
        this.debugBox = new JCheckBox();
        this.setConfigButton = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setTitle("Notes RMI Service Configuration Client");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConfigureClient.this.exitForm(evt);
            }
        });
        this.servicePane.setLayout(new GridBagLayout());
        this.servicePane.setBorder(new CompoundBorder(new TitledBorder("Service Data"), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.serverLabel.setText("Servername (or IP):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.weightx = 1.0;
        this.servicePane.add((Component)this.serverLabel, gridBagConstraints);
        this.serverField.setColumns(20);
        this.serverField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                ConfigureClient.this.serverFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.weightx = 1.0;
        this.servicePane.add((Component)this.serverField, gridBagConstraints);
        this.getConfigButton.setMnemonic('G');
        this.getConfigButton.setText("Get Configuration");
        this.getConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureClient.this.getConfigButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.servicePane.add((Component)this.getConfigButton, gridBagConstraints);
        this.getContentPane().add(this.servicePane);
        this.configPane.setLayout(new GridBagLayout());
        this.configPane.setBorder(new CompoundBorder(new TitledBorder("Configuration Data"), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.smtpLabel.setText("SMTP Server (or IP):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        this.configPane.add((Component)this.smtpLabel, gridBagConstraints);
        this.smtpField.setColumns(20);
        this.smtpField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        this.configPane.add((Component)this.smtpField, gridBagConstraints);
        this.userLabel.setText("Mail User:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.configPane.add((Component)this.userLabel, gridBagConstraints);
        this.userField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.configPane.add((Component)this.userField, gridBagConstraints);
        this.passLabel.setText("Password:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.configPane.add((Component)this.passLabel, gridBagConstraints);
        this.passField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.configPane.add((Component)this.passField, gridBagConstraints);
        this.debugLable.setText("Debug Mode:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.configPane.add((Component)this.debugLable, gridBagConstraints);
        this.debugBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.configPane.add((Component)this.debugBox, gridBagConstraints);
        this.setConfigButton.setMnemonic('S');
        this.setConfigButton.setText("Set Configuration");
        this.setConfigButton.setEnabled(false);
        this.setConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureClient.this.setConfigButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.configPane.add((Component)this.setConfigButton, gridBagConstraints);
        this.getContentPane().add(this.configPane);
        this.pack();
    }

    private void serverFieldKeyTyped(KeyEvent evt) {
        this.data = new ConfigurationData();
        this.smtpField.setEditable(false);
        this.userField.setEditable(false);
        this.passField.setEditable(false);
        this.debugBox.setEnabled(false);
        this.setConfigButton.setEnabled(false);
        this.getConfigButton.setEnabled(true);
        this.updateConfigVisuals();
    }

    private void setConfigButtonActionPerformed(ActionEvent evt) {
        this.data.setDebug(this.debugBox.isSelected());
        this.data.setMailPassword(this.passField.getText());
        this.data.setMailServer(this.smtpField.getText());
        this.data.setMailUser(this.userField.getText());
        try {
            NotesDelegate remote = (NotesDelegate)Naming.lookup("//" + this.serverField.getText() + "/NotesDelegate");
            remote.setConfiguration(this.data);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e, "Exception has occured", 0);
        }
    }

    private void getConfigButtonActionPerformed(ActionEvent evt) {
        try {
            NotesDelegate remote = (NotesDelegate)Naming.lookup("//" + this.serverField.getText() + "/NotesDelegate");
            this.data = remote.getConfiguration();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e, "Exception has occured", 0);
            return;
        }
        this.updateConfigVisuals();
        this.getConfigButton.setEnabled(false);
        this.setConfigButton.setEnabled(true);
        this.debugBox.setEnabled(true);
        this.passField.setEditable(true);
        this.userField.setEditable(true);
        this.smtpField.setEditable(true);
    }

    private void updateConfigVisuals() {
        this.debugBox.setSelected(this.data.isDebug());
        this.passField.setText(this.data.getMailPassword());
        this.userField.setText(this.data.getMailUser());
        this.smtpField.setText(this.data.getMailServer());
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        new ConfigureClient().show();
    }
}

