/*
 * Decompiled with CFR 0.152.
 */
package de.upb.ois.nt2.prototyp;

import de.upb.ois.nt2.data.Appointment;
import de.upb.ois.nt2.data.CalendarEntry;
import de.upb.ois.nt2.data.Person;
import de.upb.ois.nt2.prototyp.PrototypData;
import de.upb.ois.nt2.prototyp.PrototypErrorDialog;
import de.upb.ois.nt2.remote.NotesDelegate;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

public class Prototyp
extends Frame {
    private static final int SETTINGS = 0;
    private static final int CALENDARS = 1;
    private static final int GCDISPLAY = 2;
    private static final int ENTRYDETAILS = 3;
    private Button button1;
    private TextField fileField;
    private TextArea textArea1;
    private TextField nameField;
    private Button next;
    private Label calHeader;
    private TextField passField;
    private Panel buttons;
    private Choice ownerChoice;
    private Label serverLabel;
    private ScrollPane entriesDisplay;
    private Label nameLabel;
    private Button previous;
    private Panel innerButtons;
    private Panel cals;
    private Panel realEntries;
    private Panel settings;
    private TextField serverField;
    private Label settingsHeader;
    private Label fileLabel;
    private Label header;
    private Panel realSettings;
    private Choice calChoice;
    private Panel realCals;
    private TextField rmiField;
    private Panel entries;
    private Label ownerLabel;
    private Label passLabel;
    private Panel cards;
    private Label entriesHeader;
    private Label rmiLabel;
    private Label calLabel;
    private CardLayout cardSwitcher;
    private int mode = 0;
    private PrototypData data = null;
    private NotesDelegate remote = null;
    private boolean adjusting = false;
    private Label startingDateLabel;
    private TextField startingDateField;
    private Panel groupcalendardisplay;
    private Panel allschedulesDisplay;
    private Label groupcalendardisplayHeader;
    private Date displayedStartingDate = new Date();
    private Date startingDate = new Date();
    private DateAndTimeDisplay datd = new DateAndTimeDisplay();
    private PersonsScheduleDisplay psd = new PersonsScheduleDisplay();
    private PersonsScheduleDisplay psd1 = new PersonsScheduleDisplay();
    private PersonsScheduleDisplay psd2 = new PersonsScheduleDisplay();
    private PersonsScheduleDisplay psd3 = new PersonsScheduleDisplay();
    private PersonsScheduleDisplay psd4 = new PersonsScheduleDisplay();
    private Appointment currentAppointment = null;
    private Panel entrydetails;
    private TextField tSubject;
    private TextField tStarttime;
    private TextField tEndtime;
    private TextField tParticipants;
    private Scrollbar startingDateSelector;
    private TextField locationField;
    private Label locationLabel;
    private TextField descriptionField;
    private Label descriptionLabel;

    public Prototyp() {
        this.initComponents();
        this.cardSwitcher = (CardLayout)this.cards.getLayout();
        this.data = new PrototypData();
        this.next.addActionListener(new SettingsEvaluator());
        this.next.addActionListener(new CalendarNameEvaluator());
        this.next.addActionListener(new CalendarEntryAdder());
        this.ownerChoice.addItemListener(new EntryUpdater());
        this.psd.addMouseListener(new EntrySelector());
        this.psd1.addMouseListener(new EntrySelector());
        this.psd2.addMouseListener(new EntrySelector());
        this.psd3.addMouseListener(new EntrySelector());
        Prototyp.center(this);
        Date tempdate = this.newDate(2003, 5, 10, 8, 0);
        System.out.println(tempdate);
        this.data.setStartingDate(tempdate);
        this.data.setDisplayStartingDate((Date)tempdate.clone());
        this.setTitle("Client GroupCalendar");
        ((Component)this).setBackground(SystemColor.window);
        this.cards.setBackground(SystemColor.window);
        this.settings.setBackground(SystemColor.window);
        this.cals.setBackground(SystemColor.window);
        this.entries.setBackground(SystemColor.window);
        this.updateGUI();
        this.repaint();
    }

    static void center(Window f) {
        f.pack();
        Dimension size = f.getSize();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)f).setLocation((sSize.width - size.width) / 2, (sSize.height - size.height) / 2);
    }

    protected void initComponents() {
        this.cards = new Panel();
        this.settings = new Panel();
        this.settingsHeader = new Label();
        this.realSettings = new Panel();
        this.rmiLabel = new Label();
        this.rmiField = new TextField();
        this.nameLabel = new Label();
        this.nameField = new TextField();
        this.passLabel = new Label();
        this.passField = new TextField();
        this.fileLabel = new Label();
        this.fileField = new TextField();
        this.serverLabel = new Label();
        this.serverField = new TextField();
        this.cals = new Panel();
        this.calHeader = new Label();
        this.realCals = new Panel();
        this.calLabel = new Label();
        this.calChoice = new Choice();
        this.entries = new Panel();
        this.entriesHeader = new Label();
        this.realEntries = new Panel();
        this.ownerLabel = new Label();
        this.ownerChoice = new Choice();
        this.entriesDisplay = new ScrollPane();
        this.textArea1 = new TextArea();
        this.header = new Label();
        this.buttons = new Panel();
        this.innerButtons = new Panel();
        this.previous = new Button();
        this.next = new Button();
        this.button1 = new Button();
        this.startingDateLabel = new Label();
        this.startingDateField = new TextField();
        this.groupcalendardisplay = new Panel();
        this.allschedulesDisplay = new Panel();
        this.groupcalendardisplayHeader = new Label();
        this.datd = new DateAndTimeDisplay();
        this.psd = new PersonsScheduleDisplay();
        this.psd1 = new PersonsScheduleDisplay();
        this.psd2 = new PersonsScheduleDisplay();
        this.psd3 = new PersonsScheduleDisplay();
        this.psd4 = new PersonsScheduleDisplay();
        this.entrydetails = new Panel();
        this.locationField = new TextField();
        this.locationLabel = new Label();
        this.descriptionField = new TextField();
        this.descriptionLabel = new Label();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Prototyp.this.exitForm(evt);
            }
        });
        this.cards.setLayout(new CardLayout());
        this.settings.setLayout(new BorderLayout(10, 10));
        this.settingsHeader.setAlignment(1);
        this.settingsHeader.setFont(new Font("Dialog", 1, 12));
        this.settingsHeader.setText("Settings");
        this.settings.add((Component)this.settingsHeader, "North");
        this.realSettings.setLayout(new GridBagLayout());
        this.rmiLabel.setText("RMI Server:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.realSettings.add((Component)this.rmiLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.realSettings.add((Component)this.rmiField, gridBagConstraints);
        this.nameLabel.setText("User name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.realSettings.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.realSettings.add((Component)this.nameField, gridBagConstraints);
        this.passLabel.setText("Password:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.realSettings.add((Component)this.passLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.realSettings.add((Component)this.passField, gridBagConstraints);
        this.fileLabel.setText("Mail file:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.realSettings.add((Component)this.fileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.realSettings.add((Component)this.fileField, gridBagConstraints);
        this.serverLabel.setText("Mail server:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.realSettings.add((Component)this.serverLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.realSettings.add((Component)this.serverField, gridBagConstraints);
        this.startingDateLabel.setText("Starting Date:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.realSettings.add((Component)this.startingDateLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.realSettings.add((Component)this.startingDateField, gridBagConstraints);
        this.settings.add((Component)this.realSettings, "Center");
        this.cards.add((Component)this.settings, "card2");
        this.cals.setLayout(new BorderLayout());
        this.calHeader.setAlignment(1);
        this.calHeader.setFont(new Font("Dialog", 1, 12));
        this.calHeader.setText("Group Calendars");
        this.cals.add((Component)this.calHeader, "North");
        this.realCals.setLayout(new GridBagLayout());
        this.calLabel.setText("Available Calendars:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.realCals.add((Component)this.calLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.realCals.add((Component)this.calChoice, gridBagConstraints);
        this.cals.add((Component)this.realCals, "Center");
        this.cards.add((Component)this.cals, "card3");
        this.entries.setLayout(new BorderLayout());
        this.entriesHeader.setAlignment(1);
        this.entriesHeader.setFont(new Font("Dialog", 1, 12));
        this.entriesHeader.setText("Calendar Entries");
        this.entries.add((Component)this.entriesHeader, "North");
        this.realEntries.setLayout(new GridBagLayout());
        this.ownerLabel.setText("Show Entries For:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.realEntries.add((Component)this.ownerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.realEntries.add((Component)this.ownerChoice, gridBagConstraints);
        this.textArea1.setEditable(false);
        this.entriesDisplay.add(this.textArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        this.realEntries.add((Component)this.entriesDisplay, gridBagConstraints);
        this.entries.add((Component)this.realEntries, "Center");
        this.groupcalendardisplay.setLayout(new BorderLayout());
        this.groupcalendardisplayHeader.setAlignment(1);
        this.groupcalendardisplayHeader.setFont(new Font("Dialog", 1, 12));
        this.groupcalendardisplayHeader.setText("Group Calendar Display");
        this.groupcalendardisplay.add((Component)this.groupcalendardisplayHeader, "North");
        this.allschedulesDisplay.setLayout(new BorderLayout());
        Panel zeilenanzeige = new Panel();
        zeilenanzeige.setLayout(new GridLayout(6, 1));
        zeilenanzeige.add(this.datd);
        zeilenanzeige.add(this.psd);
        zeilenanzeige.add(this.psd1);
        zeilenanzeige.add(this.psd2);
        zeilenanzeige.add(this.psd3);
        zeilenanzeige.add(this.psd4);
        this.allschedulesDisplay.add((Component)zeilenanzeige, "Center");
        this.startingDateSelector = new Scrollbar(0, 0, 1, 0, 13);
        this.startingDateSelector.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                Prototyp.this.startingDateSelectorAdjustmentValueChanged(e.getValue());
                System.out.println("addAdjustmentListener  value: " + e.getValue());
            }
        });
        this.allschedulesDisplay.add((Component)this.startingDateSelector, "South");
        this.groupcalendardisplay.add((Component)this.allschedulesDisplay, "Center");
        this.cards.add((Component)this.groupcalendardisplay, "card5");
        Panel calendarentrydetail = new Panel();
        Label calendarentrydetailHeader = new Label();
        calendarentrydetail.setLayout(new BorderLayout());
        calendarentrydetailHeader.setAlignment(1);
        calendarentrydetailHeader.setFont(new Font("Dialog", 1, 12));
        calendarentrydetailHeader.setText("Entry Details");
        calendarentrydetail.add((Component)calendarentrydetailHeader, "North");
        Label lSubject = new Label("Subject:");
        Label lStarttime = new Label("Starttime:");
        Label lEndtime = new Label("Endtime:");
        Label lParticipants = new Label("Owner:");
        this.tSubject = new TextField();
        this.tStarttime = new TextField();
        this.tEndtime = new TextField();
        this.tParticipants = new TextField();
        this.entrydetails.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.entrydetails.add((Component)lSubject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.entrydetails.add((Component)this.tSubject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.entrydetails.add((Component)lStarttime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.entrydetails.add((Component)this.tStarttime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.entrydetails.add((Component)lEndtime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.entrydetails.add((Component)this.tEndtime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.entrydetails.add((Component)lParticipants, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.entrydetails.add((Component)this.tParticipants, gridBagConstraints);
        this.locationLabel.setText("Location:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.entrydetails.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.entrydetails.add((Component)this.locationField, gridBagConstraints);
        this.descriptionLabel.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.entrydetails.add((Component)this.descriptionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.entrydetails.add((Component)this.descriptionField, gridBagConstraints);
        calendarentrydetail.add((Component)this.entrydetails, "Center");
        this.cards.add((Component)calendarentrydetail, "card6");
        this.add((Component)this.cards, "Center");
        this.header.setAlignment(1);
        this.header.setFont(new Font("SansSerif", 1, 16));
        this.header.setName("header");
        this.header.setText("RMI-GroupCalendar Prototype");
        this.add((Component)this.header, "North");
        this.innerButtons.setLayout(new GridLayout(1, 3));
        this.previous.setEnabled(false);
        this.previous.setLabel("<<  Back");
        this.previous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Prototyp.this.previousActionPerformed(evt);
            }
        });
        this.innerButtons.add(this.previous);
        this.next.setLabel("Next >>");
        this.innerButtons.add(this.next);
        this.button1.setLabel("Exit");
        this.button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Prototyp.this.button1ActionPerformed(evt);
            }
        });
        this.innerButtons.add(this.button1);
        this.buttons.add(this.innerButtons);
        this.add((Component)this.buttons, "South");
        this.pack();
    }

    private void button1ActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void previousActionPerformed(ActionEvent evt) {
        this.cardSwitcher.previous(this.cards);
        this.next.setEnabled(this.mode != 3);
        this.previous.setEnabled(!this.settings.isShowing());
        --this.mode;
        this.updateGUI();
    }

    private void startingDateSelectorAdjustmentValueChanged(int adjustNumber) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.data.getStartingDate());
        cal.add(5, adjustNumber);
        this.data.setDisplayStartingDate(cal.getTime());
        System.out.println("--------------------");
        System.out.println("startingDate.getDate()  value: " + this.startingDate.getDate());
        System.out.println("displayedStartingDate.toString()  value: " + this.displayedStartingDate.toString());
        System.out.println("displayedStartingDate.getDate()  value: " + this.displayedStartingDate.getDate());
        System.out.println("adjustNumber  value: " + adjustNumber);
        System.out.println("--------------------");
        try {
            if (this.startingDateSelector.getValue() >= this.startingDateSelector.getMaximum() - 1) {
                this.startingDateSelector.setMaximum(this.startingDateSelector.getMaximum() + 7);
            }
            if (this.startingDateSelector.getValue() <= this.startingDateSelector.getMinimum() & this.startingDateSelector.getMaximum() >= 14) {
                this.startingDateSelector.setMaximum(13);
            }
            this.startingDateSelector.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateGUI();
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private void setNotesDelegate(NotesDelegate delegate) {
        this.remote = delegate;
    }

    protected void updateGUI() {
        System.out.println("updateGUI");
        this.fileField.setText(this.data.getMailFile());
        this.nameField.setText(this.data.getName());
        this.passField.setText(this.data.getPassword());
        this.serverField.setText(this.data.getMailServer());
        System.out.println("data.getStartingDate()" + this.data.getStartingDate());
        this.startingDateField.setText("" + this.data.getStartingDate());
        this.startingDateField.setEditable(false);
        int index = this.calChoice.getSelectedIndex();
        this.calChoice.removeAll();
        String[] names = this.data.getCalendarNames();
        int i = 0;
        while (i < names.length) {
            this.calChoice.add(names[i]);
            ++i;
        }
        if (index >= 0 && index < this.calChoice.getItemCount()) {
            this.calChoice.select(index);
        }
        index = this.ownerChoice.getSelectedIndex();
        this.ownerChoice.removeAll();
        Iterator iterator = this.data.getCalendar().getPersons().iterator();
        while (iterator.hasNext()) {
            this.ownerChoice.add(((Person)iterator.next()).getName());
        }
        if (index >= 0 && index < this.ownerChoice.getItemCount()) {
            this.ownerChoice.select(index);
        }
        this.next.setLabel("Next >>");
        this.datd.setStartingDate(this.data.getDisplayStartingDate());
        iterator = this.data.getCalendar().getPersons().iterator();
        if (iterator.hasNext()) {
            this.psd.init((Person)iterator.next());
            this.psd.setStartingDate(this.data.getDisplayStartingDate());
            System.out.println("psd.getMember().getName" + this.psd.getMember().getName());
        }
        if (iterator.hasNext()) {
            this.psd1.init((Person)iterator.next());
            this.psd1.setStartingDate(this.data.getDisplayStartingDate());
            System.out.println("psd1.getMember().getName())" + this.psd1.getMember().getName());
        }
        if (iterator.hasNext()) {
            this.psd2.init((Person)iterator.next());
            this.psd2.setStartingDate(this.data.getDisplayStartingDate());
        }
        if (iterator.hasNext()) {
            this.psd3.init((Person)iterator.next());
            this.psd3.setStartingDate(this.data.getDisplayStartingDate());
        }
        if (iterator.hasNext()) {
            this.psd4.init((Person)iterator.next());
            this.psd4.setStartingDate(this.data.getDisplayStartingDate());
        }
        this.psd.repaint();
        this.psd1.repaint();
        this.psd2.repaint();
        this.psd3.repaint();
        this.psd4.repaint();
        try {
            this.tSubject.setEditable(false);
            this.tStarttime.setEditable(false);
            this.tEndtime.setEditable(false);
            this.tParticipants.setEditable(false);
            this.locationField.setEditable(false);
            this.descriptionField.setEditable(false);
            this.tSubject.setText(this.currentAppointment.getSubject());
            this.tStarttime.setText("" + this.currentAppointment.getStartDate());
            this.tEndtime.setText("" + this.currentAppointment.getEndDate());
            this.tParticipants.setText(this.currentAppointment.getOwner().getName());
            this.locationField.setText(this.currentAppointment.getLocation());
            this.descriptionField.setText(this.currentAppointment.getDescription());
            this.currentAppointment.getOwner();
            this.currentAppointment.getStartHours();
            this.currentAppointment.getEndMinutes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Frame getConvenienceReference() {
        return this;
    }

    public static void main(String[] args) throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        Prototyp tc = new Prototyp();
        tc.show();
    }

    private Date newDate(int year, int month, int day, int hours, int mins) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        c.set(11, hours);
        c.set(12, mins);
        c.set(13, 0);
        return c.getTime();
    }

    private class EntrySelector
    implements MouseListener {
        EntrySelector() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getSource() instanceof PersonsScheduleDisplay) {
                PersonsScheduleDisplay nowPSD = (PersonsScheduleDisplay)e.getSource();
                System.out.println(" PersonsScheduleDisplay for:" + nowPSD.getMember().getName());
                if (Prototyp.this.mode != 2) {
                    System.out.println("mode" + Prototyp.this.mode);
                    return;
                }
                Date zeit = nowPSD.getClickzeit(e.getX());
                System.out.println("Ermittelte Zeit:" + zeit);
                try {
                    System.out.println("Ready to show Entry Details for " + nowPSD.getMember().getName());
                    Date dateForAppointment = zeit;
                    Person personWhoOwnsTheAppointment = nowPSD.getMember();
                    Iterator iter = Prototyp.this.data.getCalendar().getCalendarEntries(personWhoOwnsTheAppointment, zeit);
                    if (iter.hasNext()) {
                        Prototyp.this.currentAppointment = (Appointment)iter.next();
                        if (Prototyp.this.currentAppointment != null) {
                            System.out.println("Appointment found");
                            System.out.println("getSubject" + Prototyp.this.currentAppointment.getSubject());
                            System.out.println("getLocation" + Prototyp.this.currentAppointment.getLocation());
                            System.out.println("getDescription" + Prototyp.this.currentAppointment.getDescription());
                            System.out.println("getStartDate" + Prototyp.this.currentAppointment.getStartDate());
                            System.out.println("getEndDate" + Prototyp.this.currentAppointment.getEndDate());
                            Prototyp.this.cardSwitcher.next(Prototyp.this.cards);
                            Prototyp.this.previous.setEnabled(true);
                            Prototyp.this.next.setEnabled(false);
                            Prototyp.this.mode = 3;
                            Prototyp.this.updateGUI();
                        }
                    } else {
                        System.out.println("create and display new Appointment ");
                        Appointment currentAppointment1 = new Appointment();
                        currentAppointment1.setOwner(personWhoOwnsTheAppointment);
                        currentAppointment1.setStartDate(zeit);
                        Date endDateForAppointment = (Date)dateForAppointment.clone();
                        endDateForAppointment.setHours(dateForAppointment.getHours() + 1);
                        currentAppointment1.setEndDate(endDateForAppointment);
                        currentAppointment1.setSubject("(Enter new subject)");
                        System.out.println(currentAppointment1.getSubject());
                        System.out.println(currentAppointment1.getStartHours());
                        System.out.println(currentAppointment1.getOwner().getName());
                        Prototyp.this.currentAppointment = currentAppointment1;
                        Prototyp.this.cardSwitcher.next(Prototyp.this.cards);
                        Prototyp.this.previous.setEnabled(true);
                        Prototyp.this.next.setEnabled(true);
                        Prototyp.this.mode = 3;
                        Prototyp.this.updateGUI();
                        Prototyp.this.next.setLabel("Save");
                        Prototyp.this.next.repaint();
                        Prototyp.this.tSubject.setEditable(true);
                        Prototyp.this.tSubject.repaint();
                        Prototyp.this.locationField.setEditable(true);
                        Prototyp.this.descriptionField.setEditable(true);
                        Prototyp.this.locationField.repaint();
                        Prototyp.this.descriptionField.repaint();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Prototyp.this.previous.setEnabled(true);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }
    }

    private class SettingsEvaluator
    implements ActionListener {
        SettingsEvaluator() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Prototyp.this.mode != 0 || !Prototyp.this.settings.isShowing()) {
                return;
            }
            try {
                Prototyp.this.remote = (NotesDelegate)Naming.lookup("//" + Prototyp.this.rmiField.getText() + "/NotesDelegate");
            }
            catch (Exception e) {
                e.printStackTrace();
                new PrototypErrorDialog(Prototyp.this.getConvenienceReference(), e).show();
                return;
            }
            Prototyp.this.data.setName(Prototyp.this.nameField.getText());
            Prototyp.this.data.setPassword(Prototyp.this.passField.getText());
            Prototyp.this.data.setMailFile(Prototyp.this.fileField.getText());
            Prototyp.this.data.setMailServer(Prototyp.this.serverField.getText());
            try {
                Prototyp.this.data.setCalendarNames(Prototyp.this.remote.getCalendarNames(Prototyp.this.data.getPerson()));
            }
            catch (Exception e) {
                new PrototypErrorDialog(Prototyp.this.getConvenienceReference(), e).show();
                e.printStackTrace(System.err);
            }
            Prototyp.this.previous.setEnabled(true);
            Prototyp.this.next.setEnabled(!Prototyp.this.entries.isShowing());
            Prototyp.this.mode = 1;
            Prototyp.this.updateGUI();
            Prototyp.this.cardSwitcher.next(Prototyp.this.cards);
            Prototyp.this.adjusting = true;
        }
    }

    private class CalendarEntryAdder
    implements ActionListener {
        CalendarEntryAdder() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Prototyp.this.mode != 3) {
                return;
            }
            Person pAppointmentOwner = Prototyp.this.currentAppointment.getOwner();
            try {
                Prototyp.this.currentAppointment.setSubject(Prototyp.this.tSubject.getText());
                Prototyp.this.data.getCalendar().addCalendarEntry(Prototyp.this.currentAppointment, pAppointmentOwner);
            }
            catch (Exception NoSuchPerson) {
                System.out.println("cannot create an Entry for an not existing Person");
                return;
            }
            Prototyp.this.cardSwitcher.previous(Prototyp.this.cards);
            Prototyp.this.next.setEnabled(false);
            Prototyp.this.previous.setEnabled(!Prototyp.this.settings.isShowing());
            Prototyp prototyp = Prototyp.this;
            prototyp.mode = prototyp.mode - 1;
            Prototyp.this.updateGUI();
        }
    }

    private class CalendarNameEvaluator
    implements ActionListener {
        CalendarNameEvaluator() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Prototyp.this.mode != 1 || !Prototyp.this.cals.isShowing()) {
                return;
            }
            if (Prototyp.this.adjusting) {
                Prototyp.this.adjusting = false;
                return;
            }
            String selected = Prototyp.this.calChoice.getSelectedItem();
            de.upb.ois.nt2.data.Calendar c = new de.upb.ois.nt2.data.Calendar();
            try {
                c.merge(Prototyp.this.remote.getCalendar(selected, Prototyp.this.data.getPerson()));
                Prototyp.this.data.setCalendar(c);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            Prototyp.this.cardSwitcher.next(Prototyp.this.cards);
            Prototyp.this.previous.setEnabled(true);
            Prototyp.this.next.setEnabled(false);
            Prototyp.this.mode = 2;
            Prototyp.this.updateGUI();
        }
    }

    private class EntryUpdater
    implements ItemListener {
        EntryUpdater() {
        }

        public void itemStateChanged(ItemEvent e) {
            Prototyp.this.textArea1.setText("");
            String selection = Prototyp.this.ownerChoice.getSelectedItem();
            if (selection == null || selection.equals("")) {
                return;
            }
            de.upb.ois.nt2.data.Calendar c = Prototyp.this.data.getCalendar();
            Person match = null;
            Iterator persons = c.getPersons().iterator();
            while (persons.hasNext() && match == null) {
                match = (Person)persons.next();
                if (match.getName().equals(selection)) continue;
                match = null;
            }
            if (match == null) {
                return;
            }
            Iterator iterator = c.getAllCalendarEntries(match);
            CalendarEntry entry = null;
            StringBuffer buffer = new StringBuffer();
            while (iterator.hasNext()) {
                entry = (CalendarEntry)iterator.next();
                buffer.append("\nEntry:\n");
                buffer.append("\tSubject: ");
                buffer.append(entry.getSubject());
                buffer.append("\n\tStart time: ");
                buffer.append(entry.getStartDate());
            }
            Prototyp.this.textArea1.setText(buffer.toString());
        }
    }

    private class DateAndTimeDisplay
    extends Canvas {
        private int hoeheZeile = 18;
        private int breiteZeilenkopf = 50;
        private int breiteZeiteinheit = 15;
        private int startingtime = 8;
        private int duration = 10;
        boolean init = false;
        private Date startingDate = new Date();
        private Graphics2D context;
        private Composite old;

        public Dimension getPreferredSize() {
            return new Dimension(this.breiteZeilenkopf + this.breiteZeiteinheit * this.duration, 2 * this.hoeheZeile);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.breiteZeilenkopf + this.breiteZeiteinheit * this.duration, 2 * this.hoeheZeile);
        }

        public void paint(Graphics g) {
            int x = this.breiteZeilenkopf;
            boolean y = false;
            int w = this.breiteZeiteinheit;
            int h = this.hoeheZeile;
            Color darkred = new Color(127, 0, 0);
            g.setColor(darkred);
            g.drawString(this.getZeilenkopfName(), 2, h);
            int i = 0;
            while (i < this.duration) {
                int anzeigezeit = this.startingtime + i;
                g.drawString("" + anzeigezeit, this.breiteZeilenkopf + i * this.breiteZeiteinheit, h * 2);
                ++i;
            }
        }

        private String getZeilenkopfName() {
            return "" + this.startingDate.toString();
        }

        private void switchTransparencyTo(boolean shouldBeTransparent, Graphics g) {
            if (shouldBeTransparent) {
                this.context = (Graphics2D)g;
                this.old = this.context.getComposite();
                AlphaComposite c = AlphaComposite.getInstance(3, 0.5f);
                this.context.setComposite(c);
            } else {
                this.context.setComposite(this.old);
                g.drawRect(0, 0, this.getSize().width, this.getSize().height);
            }
        }

        public Date getClickzeit(int xpos) {
            int breite = this.breiteZeiteinheit;
            int clickedTime = (xpos - this.breiteZeilenkopf) / breite - 1;
            if (clickedTime < 0) {
                clickedTime = 0;
            }
            if (clickedTime >= this.duration) {
                clickedTime = this.duration - 1;
            }
            Date ermittelteZeit = (Date)this.startingDate.clone();
            ermittelteZeit.setMinutes(0);
            ermittelteZeit.setSeconds(5);
            ermittelteZeit.setHours(this.startingtime + clickedTime);
            System.out.println("getSize().width" + this.getSize().width);
            System.out.println("headerBreite " + this.breiteZeilenkopf);
            System.out.println("zeitdauer.getHours()" + this.duration);
            System.out.println("breite " + breite);
            System.out.println("xpos" + xpos);
            System.out.println("clickedTime " + clickedTime);
            System.out.println("zeitab" + this.startingDate);
            System.out.println("ermittelteZeit.getHours()" + ermittelteZeit.getHours());
            return ermittelteZeit;
        }

        public Date getStartingDate() {
            return this.startingDate;
        }

        public void setStartingDate(Date date) {
            this.startingDate = date;
            this.repaint();
        }
    }

    public class PersonsScheduleDisplay
    extends Canvas {
        private int hoeheZeile = 18;
        private int breiteZeilenkopf = 50;
        private int breiteZeiteinheit = 15;
        private int startingtime = 8;
        private int duration = 10;
        boolean init = false;
        private Person member;
        private Date startingDate = new Date();
        private List listAlleTermine;
        private Graphics2D context;
        private Composite old;

        public void paint(Graphics g) {
            int x = this.breiteZeilenkopf;
            int y = 0;
            int w = this.breiteZeiteinheit;
            int h = this.hoeheZeile;
            Color darkred = new Color(127, 0, 0);
            g.setColor(darkred);
            int i = 0;
            while (i < this.duration) {
                g.drawRect(x + i * w, y, w, h);
                ++i;
            }
            if (this.init) {
                g.drawString(this.getZeilenkopfName(), 0, h);
                this.switchTransparencyTo(true, g);
                Iterator alleTermine = this.getScheduledTimes();
                while (alleTermine.hasNext()) {
                    Appointment naechsterTermin = (Appointment)alleTermine.next();
                    int terminstart = naechsterTermin.getStartHours();
                    int terminend = naechsterTermin.getEndHours();
                    int zeitstrahlstart = this.startingtime;
                    int xmin = naechsterTermin.getStartMinutes();
                    float xfeinkorrektur = xmin * this.breiteZeiteinheit / 60;
                    x = this.breiteZeilenkopf + (terminstart - zeitstrahlstart) * this.breiteZeiteinheit + (int)xfeinkorrektur;
                    int wmin = naechsterTermin.getEndMinutes();
                    float wfeinkorrektur = wmin * this.breiteZeiteinheit / 60;
                    w = this.breiteZeilenkopf + (terminend - zeitstrahlstart) * this.breiteZeiteinheit + (int)wfeinkorrektur;
                    if (x < this.breiteZeilenkopf) {
                        x = this.breiteZeilenkopf;
                    }
                    if (x < this.breiteZeilenkopf) {
                        x = this.breiteZeilenkopf;
                    }
                    if (x > this.breiteZeilenkopf + this.breiteZeiteinheit * this.duration) {
                        x = this.breiteZeilenkopf + this.breiteZeiteinheit * this.duration;
                    }
                    if (w > this.breiteZeilenkopf + this.breiteZeiteinheit * this.duration) {
                        w = this.breiteZeilenkopf + this.breiteZeiteinheit * this.duration;
                    }
                    g.fillRect(x, y, w - x, h);
                }
                this.switchTransparencyTo(false, g);
            } else {
                g.drawString("nicht initialisiert", 0, h);
            }
        }

        private void switchTransparencyTo(boolean shouldBeTransparent, Graphics g) {
            if (shouldBeTransparent) {
                this.context = (Graphics2D)g;
                this.old = this.context.getComposite();
                AlphaComposite c = AlphaComposite.getInstance(3, 0.5f);
                this.context.setComposite(c);
            } else {
                this.context.setComposite(this.old);
            }
        }

        private Iterator getScheduledTimes() {
            return this.listAlleTermine.iterator();
        }

        private void refreshScheduledTimes() {
            GregorianCalendar cal = new GregorianCalendar();
            Date endingDate = (Date)this.startingDate.clone();
            cal.setTime(endingDate);
            cal.add(10, this.duration);
            endingDate = cal.getTime();
            this.listAlleTermine = Prototyp.this.data.getAppointmentList(this.member, this.startingDate, endingDate);
            System.out.println("received Appointments:" + this.listAlleTermine.size());
        }

        private Date newDate(int year, int month, int day, int hours, int mins) {
            Calendar c = Calendar.getInstance();
            c.set(1, year);
            c.set(2, month - 1);
            c.set(5, day);
            c.set(11, hours);
            c.set(12, mins);
            return c.getTime();
        }

        public void init(Person pPersoneDerZeile) {
            this.member = pPersoneDerZeile;
            System.out.println("PersonsScheduleDisplay initalisiert mit " + this.startingDate);
            this.refreshScheduledTimes();
            this.init = true;
        }

        private String getZeilenkopfName() {
            return this.member.getName();
        }

        public Date getClickzeit(int xpos) {
            int breite = this.breiteZeiteinheit;
            int clickedTime = (xpos - this.breiteZeilenkopf) / breite;
            int min = (xpos - this.breiteZeilenkopf) % breite;
            min = min * 60 / breite;
            if (clickedTime < 0) {
                clickedTime = 0;
            }
            if (clickedTime >= this.duration) {
                clickedTime = this.duration - 1;
            }
            Date ermittelteZeit = (Date)this.startingDate.clone();
            ermittelteZeit.setMinutes(min);
            ermittelteZeit.setSeconds(0);
            ermittelteZeit.setHours(this.startingtime + clickedTime);
            System.out.println("ermittelteZeit (lokal)" + ermittelteZeit.toLocaleString());
            return ermittelteZeit;
        }

        public Date getStartingDate() {
            return this.startingDate;
        }

        public void setStartingDate(Date date) {
            this.startingDate = date;
            this.refreshScheduledTimes();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.breiteZeilenkopf + this.breiteZeiteinheit * this.duration, this.hoeheZeile + 2);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.breiteZeilenkopf + this.breiteZeiteinheit * this.duration, this.hoeheZeile - 2);
        }

        public Person getMember() {
            return this.member;
        }

        public void setMember(Person person) {
            this.member = person;
        }
    }
}

