/*
 * Decompiled with CFR 0.152.
 */
package de.upb.ois.nt2.prototyp;

import de.upb.ois.nt2.data.Appointment;
import de.upb.ois.nt2.data.Calendar;
import de.upb.ois.nt2.data.NotesID;
import de.upb.ois.nt2.data.Person;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

class PrototypData {
    private Calendar cal = new Calendar();
    private Person person = new Person();
    private String[] calNames = new String[0];
    private String selected = "";
    private Date startingDate = null;
    private Date displayStartingDate = null;

    PrototypData() {
        this.person.setId(new NotesID());
        this.startingDate = new Date();
        this.displayStartingDate = new Date();
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setName(String name) {
        this.person.setName(name);
        this.person.getId().setUserName(name);
    }

    public String getName() {
        return this.person.getName();
    }

    public void setMailFile(String mailFile) {
        this.person.getId().setMailFile(mailFile);
    }

    public String getMailFile() {
        return this.person.getId().getMailFile();
    }

    public void setMailServer(String server) {
        this.person.getId().setServer(server);
    }

    public String getMailServer() {
        return this.person.getId().getServer();
    }

    public void setPassword(String password) {
        this.person.getId().setPassword(password);
    }

    public String getPassword() {
        return this.person.getId().getPassword();
    }

    public void setCalendar(Calendar calendar) {
        this.cal = calendar;
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public void setCalendarNames(String[] names) {
        this.calNames = names;
    }

    public String[] getCalendarNames() {
        return this.calNames;
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(Date date) {
        this.startingDate = date;
    }

    public Date getDisplayStartingDate() {
        return this.displayStartingDate;
    }

    public void setDisplayStartingDate(Date date) {
        this.displayStartingDate = date;
    }

    public LinkedList getAppointmentList(Person terminOwner, Date von, Date bis) {
        LinkedList<Appointment> appointmentListe = new LinkedList<Appointment>();
        if (terminOwner != null) {
            Iterator iterator = this.cal.getAllCalendarEntries(terminOwner);
            Appointment termin = null;
            while (iterator.hasNext()) {
                termin = (Appointment)iterator.next();
                if (termin.getStartDate().after(bis) | termin.getEndDate().before(von)) continue;
                System.out.print("Appointment found: ");
                System.out.print("from:" + termin.getStartDate());
                System.out.println("until:" + termin.getEndDate());
                appointmentListe.add(termin);
            }
        }
        return appointmentListe;
    }
}

