/*
 * Decompiled with CFR 0.152.
 */
package de.upb.ois.nt2.data;

import de.upb.ois.nt2.data.CalendarEntry;
import de.upb.ois.nt2.data.LimitedTimeCalendarEntry;
import de.upb.ois.nt2.data.Person;
import de.upb.ois.nt2.data.Reminder;
import de.upb.ois.nt2.remote.NoSuchPersonException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Calendar
implements Serializable {
    static final long serialVersionUID = -4681662866914371912L;
    private Set persons;
    private Set entries;
    private Map personEntryMap = new HashMap();
    private String calendarName = "";

    public Calendar() {
        this.persons = Collections.synchronizedSet(new HashSet());
        this.entries = Collections.synchronizedSet(new HashSet());
        this.personEntryMap = Collections.synchronizedMap(new HashMap());
    }

    public Collection getPersons() {
        return this.persons;
    }

    public void setPersons(Collection persons) {
        Iterator iterator = persons.iterator();
        Person person = null;
        while (iterator.hasNext()) {
            person = (Person)iterator.next();
            if (this.persons.contains(person)) continue;
            this.persons.add(person);
            this.personEntryMap.put(person, Collections.synchronizedSet(new HashSet()));
        }
        iterator = this.persons.iterator();
        while (iterator.hasNext()) {
            person = (Person)iterator.next();
            if (persons.contains(person)) continue;
            this.persons.remove(person);
            this.personEntryMap.remove(person);
        }
    }

    public void addPerson(Person person) {
        if (this.persons.contains(person)) {
            return;
        }
        this.persons.add(person);
        this.personEntryMap.put(person, Collections.synchronizedSet(new HashSet()));
    }

    public void removePerson(Person person) {
        this.persons.remove(person);
        this.personEntryMap.remove(person);
    }

    public List getParticipants(CalendarEntry calendarEntry) {
        LinkedList<Person> tempList = new LinkedList<Person>();
        Set keySet = this.personEntryMap.keySet();
        Iterator iterator = keySet.iterator();
        Set entrySet = null;
        Person person = null;
        while (iterator.hasNext()) {
            person = (Person)iterator.next();
            entrySet = (Set)this.personEntryMap.get(person);
            if (!entrySet.contains(calendarEntry)) continue;
            tempList.add(person);
        }
        return tempList;
    }

    public Iterator getCalendarEntries(Person person, Date date) {
        LinkedList<CalendarEntry> list = new LinkedList<CalendarEntry>();
        Set entrySet = (Set)this.personEntryMap.get(person);
        if (entrySet == null && this.persons.contains(person)) {
            entrySet = Collections.synchronizedSet(new HashSet());
            this.personEntryMap.put(person, entrySet);
        }
        if (entrySet != null) {
            CalendarEntry entry = null;
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                entry = (CalendarEntry)iterator.next();
                if (entry.getStartDate().equals(date)) {
                    list.add(entry);
                    continue;
                }
                if (!(entry instanceof LimitedTimeCalendarEntry) || (!entry.getStartDate().before(date) || !((LimitedTimeCalendarEntry)entry).getEndDate().after(date)) && !((LimitedTimeCalendarEntry)entry).getEndDate().equals(date)) continue;
                list.add(entry);
            }
        }
        return list.iterator();
    }

    public Iterator getAllCalendarEntries(Date startDate, Date endDate) {
        Iterator iterator = this.entries.iterator();
        CalendarEntry current = null;
        LimitedTimeCalendarEntry limited = null;
        LinkedList<CalendarEntry> tempList = new LinkedList<CalendarEntry>();
        while (iterator.hasNext()) {
            current = (CalendarEntry)iterator.next();
            if (current instanceof LimitedTimeCalendarEntry) {
                limited = (LimitedTimeCalendarEntry)current;
                if (!limited.getStartDate().equals(startDate) && !limited.getStartDate().after(startDate) || !limited.getEndDate().before(endDate) && !limited.getEndDate().equals(endDate)) continue;
                tempList.add(limited);
                continue;
            }
            if (!(current instanceof Reminder) || !startDate.equals(current.getStartDate()) && (!startDate.before(current.getStartDate()) || !current.getStartDate().before(endDate)) && !endDate.equals(current.getStartDate())) continue;
            tempList.add(current);
        }
        return tempList.iterator();
    }

    public Iterator getAllCalendarEntries() {
        return this.entries.iterator();
    }

    public Iterator getAllCalendarEntries(Person person) {
        if (this.personEntryMap.get(person) == null) {
            this.personEntryMap.put(person, Collections.synchronizedSet(new HashSet()));
        }
        return ((Set)this.personEntryMap.get(person)).iterator();
    }

    public Iterator getAllPersons() {
        return this.persons.iterator();
    }

    public void addCalendarEntry(CalendarEntry entry) {
        this.entries.add(entry);
        Iterator iterator = this.personEntryMap.keySet().iterator();
        Person currentPerson = null;
        Set<CalendarEntry> entrySet = null;
        while (iterator.hasNext()) {
            currentPerson = (Person)iterator.next();
            entrySet = (Set<CalendarEntry>)this.personEntryMap.get(currentPerson);
            if (entrySet == null) {
                entrySet = Collections.synchronizedSet(new HashSet());
                this.personEntryMap.put(currentPerson, entrySet);
            }
            entrySet.add(entry);
        }
    }

    public void addCalendarEntry(CalendarEntry entry, Person person) throws NoSuchPersonException {
        Set<CalendarEntry> entrySet;
        if (!this.persons.contains(person)) {
            throw new NoSuchPersonException("The given person is not a member of this calendar.");
        }
        if (!this.entries.contains(entry)) {
            this.entries.add(entry);
        }
        if ((entrySet = (Set<CalendarEntry>)this.personEntryMap.get(person)) == null) {
            entrySet = Collections.synchronizedSet(new HashSet());
            this.personEntryMap.put(person, entrySet);
        }
        entrySet.add(entry);
    }

    public void removeCalendarEntry(CalendarEntry entry) {
        boolean found = this.entries.remove(entry);
        if (!found) {
            return;
        }
        Iterator iterator = this.personEntryMap.keySet().iterator();
        Set entrySet = null;
        while (iterator.hasNext()) {
            entrySet = (Set)this.personEntryMap.get(iterator.next());
            if (entrySet == null) continue;
            entrySet.remove(entry);
        }
    }

    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    public String getCalendarName() {
        return this.calendarName;
    }

    public void merge(Calendar c) {
        Iterator foreignEntries = c.getAllCalendarEntries();
        Iterator foreignPersons = c.getPersons().iterator();
        CalendarEntry foreignEntry = null;
        while (foreignEntries.hasNext()) {
            foreignEntry = (CalendarEntry)foreignEntries.next();
            if (this.entries.contains(foreignEntry)) continue;
            this.entries.add(foreignEntry);
        }
        Person currentPerson = null;
        Iterator foreignPersonEntries = null;
        Set mapping = null;
        while (foreignPersons.hasNext()) {
            currentPerson = (Person)foreignPersons.next();
            if (!this.persons.contains(currentPerson)) {
                this.persons.add(currentPerson);
            }
            foreignPersonEntries = c.getAllCalendarEntries(currentPerson);
            mapping = (Set)this.personEntryMap.get(currentPerson);
            while (foreignPersonEntries.hasNext()) {
                foreignEntry = (CalendarEntry)foreignPersonEntries.next();
                if (mapping != null && mapping.contains(foreignEntry)) continue;
                try {
                    this.addCalendarEntry(foreignEntry, currentPerson);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }
}

