/*
 * Decompiled with CFR 0.152.
 */
package de.upb.ois.nt2.server;

import de.upb.ois.nt2.data.Appointment;
import de.upb.ois.nt2.data.Calendar;
import de.upb.ois.nt2.data.CalendarEntry;
import de.upb.ois.nt2.data.ConfigurationData;
import de.upb.ois.nt2.data.Meeting;
import de.upb.ois.nt2.data.NotesID;
import de.upb.ois.nt2.data.Person;
import de.upb.ois.nt2.remote.NoSuchCalendarException;
import de.upb.ois.nt2.remote.NoSuchPersonException;
import de.upb.ois.nt2.remote.NotesDelegate;
import de.upb.ois.nt2.server.contenthandler.AbstractDefaultHandler;
import de.upb.ois.nt2.server.contenthandler.CalendarNameRetriever;
import de.upb.ois.nt2.server.contenthandler.CalendarPersonsRetriever;
import de.upb.ois.nt2.server.contenthandler.CalendarRetriever;
import de.upb.ois.nt2.server.contenthandler.ContentHandlerChain;
import de.upb.ois.nt2.server.contenthandler.NamesNSFHandler;
import de.upb.ois.nt2.server.helper.DataProcessor;
import de.upb.ois.nt2.server.helper.PropertyCheck;
import de.upb.ois.nt2.server.helper.StreamEncapsulator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import lotus.dxl.DXLDatabase;
import lotus.dxl.DXLExportOptions;
import lotus.dxl.DXLExporter;
import lotus.dxl.DXLImportOptions;
import lotus.dxl.DXLImporter;
import lotus.dxl.DXLSession;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NotesDelegateImpl
extends UnicastRemoteObject
implements NotesDelegate {
    static final long serialVersionUID = -4283688464062373735L;
    private static StreamEncapsulator redirect = null;
    private SAXParser parser = null;
    private File input = null;
    private DXLSession session = null;
    private HashMap sessionStorage = new HashMap();
    private ConfigurationData data = this.retrieveConfiguration();
    private static String defaultServer = null;
    private static String defaultUser = null;
    private static String defaultPassword = null;
    private static final String[] cmdLineParams = new String[]{"-nogui"};
    static /* synthetic */ Class class$de$upb$ois$nt2$server$contenthandler$AbstractDefaultHandler;
    static /* synthetic */ Class class$de$upb$ois$nt2$server$contenthandler$NamesNSFHandler;

    public NotesDelegateImpl() throws RemoteException, ParserConfigurationException, SAXException, Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        this.parser = factory.newSAXParser();
    }

    public void finalize() throws Exception {
        Object session = null;
        Iterator iterator = this.sessionStorage.entrySet().iterator();
        while (iterator.hasNext()) {
            ((DXLSession)iterator.next()).term();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] getCalendarNames(Person person) throws RemoteException {
        Exception remembered;
        CalendarNameRetriever retriever;
        block13: {
            String mailserver = person.getId().getServer();
            String mailfile = person.getId().getMailFile();
            String user = person.getId().getUserName();
            String password = person.getId().getPassword();
            retriever = new CalendarNameRetriever();
            InputStream in = null;
            remembered = null;
            in = this.getInputStream(user, password, mailfile, mailserver);
            SAXParser sAXParser = this.parser;
            synchronized (sAXParser) {
                this.parser.parse(in, (DefaultHandler)retriever);
            }
            Object var12_12 = null;
            try {
                in.close();
            }
            catch (Exception e2) {
                e2.printStackTrace(System.err);
            }
            this.closeSessionFor(Thread.currentThread());
            {
                break block13;
                catch (Exception e) {
                    remembered = e;
                    Object var12_13 = null;
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace(System.err);
                    }
                    this.closeSessionFor(Thread.currentThread());
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    in.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace(System.err);
                }
                this.closeSessionFor(Thread.currentThread());
                throw throwable;
            }
        }
        if (remembered != null) {
            throw new RemoteException("Couldn't parse Mail File: ", remembered);
        }
        return retriever.getNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Calendar getCalendar(String name, Person person) throws RemoteException, NoSuchPersonException {
        NamesNSFHandler currentHandler;
        String currentName;
        HashMap<String, NamesNSFHandler> map;
        Calendar c;
        block35: {
            Exception remembered;
            InputStream in;
            CalendarNameRetriever nameRetriever;
            CalendarPersonsRetriever persRetriever;
            CalendarRetriever calRetriever;
            ContentHandlerChain chain;
            String mailserver;
            String password;
            String username;
            block32: {
                c = null;
                username = person.getId().getUserName();
                password = person.getId().getPassword();
                mailserver = person.getId().getServer();
                String mailfile = person.getId().getMailFile();
                if (username == null || password == null || mailserver == null || mailfile == null) {
                    throw new RemoteException("Unsufficient data in person identity.");
                }
                chain = new ContentHandlerChain();
                calRetriever = new CalendarRetriever();
                calRetriever.getCalendar().addPerson(person);
                chain.addDefaultHandler(class$de$upb$ois$nt2$server$contenthandler$AbstractDefaultHandler == null ? (class$de$upb$ois$nt2$server$contenthandler$AbstractDefaultHandler = NotesDelegateImpl.class$("de.upb.ois.nt2.server.contenthandler.AbstractDefaultHandler")) : class$de$upb$ois$nt2$server$contenthandler$AbstractDefaultHandler, calRetriever);
                persRetriever = new CalendarPersonsRetriever(name);
                chain.addDefaultHandler(class$de$upb$ois$nt2$server$contenthandler$AbstractDefaultHandler == null ? (class$de$upb$ois$nt2$server$contenthandler$AbstractDefaultHandler = NotesDelegateImpl.class$("de.upb.ois.nt2.server.contenthandler.AbstractDefaultHandler")) : class$de$upb$ois$nt2$server$contenthandler$AbstractDefaultHandler, persRetriever);
                nameRetriever = new CalendarNameRetriever();
                chain.addDefaultHandler(class$de$upb$ois$nt2$server$contenthandler$AbstractDefaultHandler == null ? (class$de$upb$ois$nt2$server$contenthandler$AbstractDefaultHandler = NotesDelegateImpl.class$("de.upb.ois.nt2.server.contenthandler.AbstractDefaultHandler")) : class$de$upb$ois$nt2$server$contenthandler$AbstractDefaultHandler, nameRetriever);
                in = null;
                remembered = null;
                in = this.getInputStream(username, password, mailfile, mailserver);
                SAXParser sAXParser = this.parser;
                synchronized (sAXParser) {
                    this.parser.parse(in, (DefaultHandler)chain);
                }
                Object var17_19 = null;
                try {
                    in.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace(System.err);
                }
                this.closeSessionFor(Thread.currentThread());
                {
                    break block32;
                    catch (Exception e) {
                        remembered = e;
                        var17_19 = null;
                        try {
                            in.close();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace(System.err);
                        }
                        this.closeSessionFor(Thread.currentThread());
                    }
                }
                catch (Throwable throwable) {
                    Object var17_20 = null;
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace(System.err);
                    }
                    this.closeSessionFor(Thread.currentThread());
                    throw throwable;
                }
            }
            if (remembered != null) {
                throw new RemoteException("Error while retrieving calendar data.", remembered);
            }
            boolean found = false;
            String[] names = nameRetriever.getNames();
            int i = 0;
            while (i < names.length && !found) {
                found = names[i].equals(name);
                ++i;
            }
            if (!found) {
                throw new NoSuchPersonException("Person is not in given Group Calendar.");
            }
            c = calRetriever.getCalendar();
            c.setCalendarName(name);
            Iterator persons = persRetriever.getPersons();
            map = new HashMap<String, NamesNSFHandler>(5);
            currentName = null;
            currentHandler = null;
            chain = new ContentHandlerChain();
            while (persons.hasNext()) {
                currentName = persRetriever.getNaturalName(((Person)persons.next()).getName());
                currentHandler = new NamesNSFHandler(currentName);
                map.put(currentName, currentHandler);
                chain.addDefaultHandler(class$de$upb$ois$nt2$server$contenthandler$NamesNSFHandler == null ? NotesDelegateImpl.class$("de.upb.ois.nt2.server.contenthandler.NamesNSFHandler") : class$de$upb$ois$nt2$server$contenthandler$NamesNSFHandler, currentHandler);
            }
            chain.removeDefaultHandler(class$de$upb$ois$nt2$server$contenthandler$NamesNSFHandler == null ? (class$de$upb$ois$nt2$server$contenthandler$NamesNSFHandler = NotesDelegateImpl.class$("de.upb.ois.nt2.server.contenthandler.NamesNSFHandler")) : class$de$upb$ois$nt2$server$contenthandler$NamesNSFHandler, (AbstractDefaultHandler)map.get(person.getName()));
            map.remove(person.getName());
            in = this.getInputStream(username, password, "names.nsf", mailserver);
            SAXParser sAXParser = this.parser;
            synchronized (sAXParser) {
                this.parser.parse(in, (DefaultHandler)chain);
            }
            Object var24_31 = null;
            try {
                in.close();
            }
            catch (Exception e3) {
                e3.printStackTrace(System.err);
            }
            this.closeSessionFor(Thread.currentThread());
            {
                break block35;
                catch (Exception e) {
                    remembered = e;
                    var24_31 = null;
                    try {
                        in.close();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace(System.err);
                    }
                    this.closeSessionFor(Thread.currentThread());
                }
            }
            catch (Throwable throwable) {
                Object var24_32 = null;
                try {
                    in.close();
                }
                catch (Exception e3) {
                    e3.printStackTrace(System.err);
                }
                this.closeSessionFor(Thread.currentThread());
                throw throwable;
            }
        }
        Person currentPerson = null;
        NotesID currentId = null;
        HashMap<String, Person> personMap = new HashMap<String, Person>(10);
        Iterator keySet = map.keySet().iterator();
        while (keySet.hasNext()) {
            currentName = (String)keySet.next();
            currentHandler = (NamesNSFHandler)map.get(currentName);
            currentPerson = new Person();
            currentPerson.setName(currentName);
            currentId = new NotesID();
            currentPerson.setId(currentId);
            currentId.setMailFile(currentHandler.getMailFile());
            currentId.setServer(currentHandler.getMailServer());
            currentPerson.setEmail(currentHandler.getMailAddress());
            personMap.put(currentName, currentPerson);
        }
        keySet = personMap.keySet().iterator();
        Calendar currentCal = null;
        while (keySet.hasNext()) {
            currentName = (String)keySet.next();
            currentPerson = (Person)personMap.get(currentName);
            if (currentPerson.getId().getServer() == null || !currentPerson.getId().getServer().equals(person.getId().getServer())) continue;
            try {
                currentCal = this.getPersonalCalendarFor(currentPerson, person);
                c.merge(currentCal);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCalendarEntry(CalendarEntry entry, Calendar calendar, Person person) throws RemoteException, NoSuchPersonException, NoSuchCalendarException {
        if (!(entry instanceof Appointment)) {
            System.err.println("Entries other than appointments are currently not supported.");
            return;
        }
        boolean meeting = entry instanceof Meeting;
        if (this.data == null) {
            throw new RuntimeException("Configuration not available.");
        }
        String smtpServer = this.data.getMailServer();
        if (smtpServer == null || smtpServer.equals("")) {
            throw new RuntimeException("Configuration not available.");
        }
        String smtpUser = this.data.getMailUser();
        if (smtpUser == null || smtpUser.equals("")) {
            throw new RuntimeException("Configuration not available.");
        }
        String smtpPass = this.data.getMailPassword();
        if (smtpPass == null || smtpPass.equals("")) {
            throw new RuntimeException("Configuration not available.");
        }
        DataProcessor processor = new DataProcessor(person, (Appointment)entry);
        if (!this.data.isDebug()) {
            PromptFooler fooler = new PromptFooler(person.getId().getPassword());
            fooler.start();
            DXLSession localSession = (DXLSession)this.sessionStorage.get(Thread.currentThread());
            Exception remembered = null;
            try {
                Object var18_19;
                try {
                    if (localSession == null) {
                        localSession = new DXLSession();
                        this.sessionStorage.put(Thread.currentThread(), localSession);
                    }
                    DXLDatabase database = new DXLDatabase(person.getId().getMailFile());
                    localSession.init(person.getId().getUserName());
                    DXLImportOptions options = new DXLImportOptions();
                    options.setDefaults();
                    options.setCreateDbOption(2);
                    options.setDesignOption(1);
                    options.setDocumentsOption(2);
                    options.setReplaceDbProperties(false);
                    DXLImporter importer = new DXLImporter(this.session);
                    importer.setImportOptions(options);
                    DXLDatabase target = new DXLDatabase(person.getId().getMailFile(), person.getId().getServer());
                    ByteArrayInputStream in = new ByteArrayInputStream(processor.getDXL().getBytes());
                    importer.importDXL((InputStream)in, target);
                }
                catch (Exception e) {
                    remembered = e;
                    e.printStackTrace(System.err);
                    var18_19 = null;
                    fooler.stopMe();
                    this.closeSessionFor(Thread.currentThread());
                }
                var18_19 = null;
                fooler.stopMe();
                this.closeSessionFor(Thread.currentThread());
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                fooler.stopMe();
                this.closeSessionFor(Thread.currentThread());
                throw throwable;
            }
            if (remembered != null) {
                throw new RuntimeException("Exception encountered", remembered);
            }
        }
        Properties props = System.getProperties();
        props.put("mail.smtp.host", smtpServer);
        try {
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(person.getEmail()));
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(person.getEmail()));
            msg.setSubject("Gruppen-Kalender-Eintrag");
            String text = processor.getMailText(this.data.isDebug());
            text = text + " Bitte \u00fcberpr\u00fcfen Sie, ob die Daten bereits in Ihren Kalender \u00fcbernommen wurden.";
            msg.setText(text);
            Transport.send((Message)msg);
            if (meeting) {
                msg = new MimeMessage(session);
                msg.setFrom((Address)new InternetAddress(person.getEmail()));
                Iterator iterator = calendar.getAllPersons();
                while (iterator.hasNext()) {
                    msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(((Person)iterator.next()).getEmail()));
                }
                text = processor.getMailText(this.data.isDebug());
                text = text + "Bitte setzen Sie sich mit dem Ersteller des Termins in Verbindung, um die G\u00fcltigkeit zu pr\u00fcfen.";
                msg.setText(text);
                Transport.send((Message)msg);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    public void removeCalendarEntry(CalendarEntry entry, Calendar calendar, Person person) throws NoSuchPersonException, RemoteException, NoSuchCalendarException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(String username, String password, String databaseName, String serverName) throws Exception {
        InputStream in = null;
        if (this.data.isDebug()) {
            in = databaseName.endsWith("names.nsf") || databaseName.endsWith("names") ? this.getClass().getResourceAsStream("contentHandler/debugdata/names.nsf.xml") : this.getClass().getResourceAsStream("contentHandler/debugdata/msteckenborn.nsf.xml");
        } else {
            PromptFooler fooler = new PromptFooler(password);
            fooler.start();
            DXLSession localSession = (DXLSession)this.sessionStorage.get(Thread.currentThread());
            if (localSession == null) {
                localSession = new DXLSession();
                this.sessionStorage.put(Thread.currentThread(), localSession);
            }
            DXLDatabase database = new DXLDatabase(databaseName);
            localSession.init(username);
            DXLExportOptions options = new DXLExportOptions();
            options.setInterpretNotes(false);
            options.setInterpretRichText(false);
            options.setExportedSchemaName("");
            DXLExporter exporter = new DXLExporter(localSession);
            exporter.setExportOptions(options);
            in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream((PipedInputStream)in);
            Exception remembered = null;
            try {
                try {
                    exporter.exportDXL(database, (OutputStream)out);
                }
                catch (Exception e) {
                    remembered = e;
                    e.printStackTrace(System.err);
                    Object var15_14 = null;
                    fooler.stopMe();
                }
                Object var15_13 = null;
                fooler.stopMe();
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                fooler.stopMe();
                throw throwable;
            }
            if (remembered != null) {
                throw remembered;
            }
        }
        return in;
    }

    private void closeSessionFor(Thread thread) {
        DXLSession threadSession = (DXLSession)this.sessionStorage.get(thread);
        if (threadSession != null) {
            threadSession.term();
            this.sessionStorage.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Calendar getPersonalCalendarFor(Person person, Person requester) throws Exception {
        Exception remembered;
        Calendar calendar;
        block14: {
            calendar = new Calendar();
            String mailserver = person.getId().getServer();
            String mailfile = person.getId().getMailFile();
            if (mailserver == null || mailserver.equals("") || mailfile == null || mailfile.equals("")) {
                return calendar;
            }
            String username = requester.getId().getUserName();
            String password = requester.getId().getPassword();
            InputStream in = null;
            CalendarRetriever retriever = new CalendarRetriever();
            calendar = retriever.getCalendar();
            calendar.addPerson(person);
            remembered = null;
            in = this.getInputStream(username, password, mailfile, mailserver);
            SAXParser sAXParser = this.parser;
            synchronized (sAXParser) {
                this.parser.parse(in, (DefaultHandler)retriever);
            }
            Object var14_14 = null;
            try {
                in.close();
            }
            catch (Exception e2) {
                e2.printStackTrace(System.err);
            }
            this.closeSessionFor(Thread.currentThread());
            {
                break block14;
                catch (Exception e) {
                    remembered = e;
                    Object var14_15 = null;
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace(System.err);
                    }
                    this.closeSessionFor(Thread.currentThread());
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    in.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace(System.err);
                }
                this.closeSessionFor(Thread.currentThread());
                throw throwable;
            }
        }
        if (remembered != null) {
            throw remembered;
        }
        return calendar;
    }

    public void setConfiguration(ConfigurationData data) throws RemoteException {
        this.data = data;
        try {
            this.saveConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException("Configuration couldn't be saved: ", e);
        }
    }

    public ConfigurationData getConfiguration() throws RemoteException {
        return this.data;
    }

    private void saveConfiguration() throws IOException {
        File file = new File(".notesrmiserver");
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        out.writeObject(this.data);
    }

    private ConfigurationData retrieveConfiguration() throws IOException {
        File file = new File(".notesrmiserver");
        if (!file.exists()) {
            return new ConfigurationData();
        }
        ConfigurationData config = null;
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
        try {
            config = (ConfigurationData)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException");
        }
        return config;
    }

    public static void registerToRegistry(String name, Remote obj, boolean create) throws RemoteException, MalformedURLException {
        if (name == null) {
            throw new IllegalArgumentException("registration name can not be null");
        }
        Naming.rebind(name, obj);
        System.out.println("Registered");
    }

    private static boolean checkParameterValidity(String[] args) {
        boolean foundAll = true;
        boolean found = false;
        int i = 0;
        while (i < args.length) {
            found = false;
            int j = 0;
            while (j < cmdLineParams.length && !found) {
                found = cmdLineParams[j].equals(args[i]);
                ++j;
            }
            foundAll = foundAll && found;
            ++i;
        }
        return foundAll;
    }

    public static void main(String[] args) throws Exception {
        redirect = new StreamEncapsulator();
        if (!NotesDelegateImpl.checkParameterValidity(args)) {
            System.out.println("Usage: java de.upb.ois.nt2.server.NotesDelegateImpl [-nogui]");
            redirect.getBufferedOutput();
            System.exit(1);
        }
        HashSet<String> params = new HashSet<String>();
        int i = 0;
        while (i < args.length) {
            params.add(args[i]);
            ++i;
        }
        if (params.contains("-nogui")) {
            System.setProperties(new PropertyCheck().runCheck(false));
        } else {
            System.setProperties(new PropertyCheck().runCheck(true));
        }
        System.setSecurityManager(new RMISecurityManager());
        try {
            NotesDelegateImpl obj = new NotesDelegateImpl();
            NotesDelegateImpl.registerToRegistry("//" + System.getProperties().getProperty("java.rmi.server") + "/NotesDelegate", obj, false);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace(System.err);
        }
        catch (SAXException ex) {
            ex.printStackTrace(System.err);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        redirect.getBufferedOutput();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PromptFooler
    extends Thread {
        private String password = null;
        private boolean keepGoing = true;

        PromptFooler(String password) {
            if (password == null) {
                throw new IllegalArgumentException("Not a valid password.");
            }
            this.password = password;
        }

        public void run() {
            StringBuffer buffer = new StringBuffer(1024);
            while (this.keepGoing) {
                buffer.append(redirect.getBufferedOutput());
                if (buffer.toString().indexOf("password") >= 0) {
                    redirect.writePassword(this.password);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public void stopMe() {
            this.keepGoing = false;
        }
    }
}

