/*
 * Decompiled with CFR 0.152.
 */
package de.upb.ois.nt2.server.contenthandler;

import de.upb.ois.nt2.data.Appointment;
import de.upb.ois.nt2.data.Person;
import de.upb.ois.nt2.server.contenthandler.AbstractDefaultHandler;
import de.upb.ois.nt2.server.contenthandler.DateImparsableException;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CalendarRetriever
extends AbstractDefaultHandler {
    public static final int IRRELEVANT = -1;
    public static final String EMPTY = "";
    public static final String NAME = "name";
    public static final String FORM = "form";
    public static final String NAMES = "names";
    public static final String DOCUMENT = "document";
    public static final String ITEM = "item";
    public static final String TEXT = "text";
    public static final String TEXTLIST = "textlist";
    public static final String DATETIME = "datetime";
    public static final int APPOINTMENT_MODE = 0;
    public static final int APPOINTMENT_BODY_MODE = 1;
    public static final int APPOINTMENT_BODY_TEXT_MODE = 14;
    public static final int APPOINTMENT_SUBJECT_MODE = 2;
    public static final int APPOINTMENT_SUBJECT_TEXT_MODE = 3;
    public static final int APPOINTMENT_STARTDATE_MODE = 4;
    public static final int APPOINTMENT_STARTDATE_DATETIME_MODE = 5;
    public static final int APPOINTMENT_ENDDATE_MODE = 6;
    public static final int APPOINTMENT_ENDDATE_DATETIME_MODE = 7;
    public static final int APPOINTMENT_LOCATION_MODE = 8;
    public static final int APPOINTMENT_LOCATION_TEXT_MODE = 9;
    public static final int APPOINTMENT_PRINCIPAL_MODE = 10;
    public static final int APPOINTMENT_PRINCIPAL_TEXT_MODE = 11;
    public static final int APPOINTMENT_PUBLIC_ACCESS_MODE = 12;
    public static final int APPOINTMENT_PUBLIC_ACCESS_TEXT_MODE = 13;
    public static final int APPOINTMENT_APPT_UNID_MODE = 25;
    public static final int APPOINTMENT_APPT_UNID_TEXT_MODE = 26;
    public static final String APPOINTMENT = "Appointment";
    public static final String SUBJECT = "Subject";
    public static final String STARTDATETIME = "STARTDATETIME";
    public static final String LOCATION = "Location";
    public static final String BODY = "Body";
    public static final String PUBLICACCESS = "$PublicAccess";
    public static final String PRINICPAL = "Principal";
    public static final String ENDDATETIME = "EndDateTime";
    public static final String APPT_UNID = "ApptUNID";
    private de.upb.ois.nt2.data.Calendar calendar = new de.upb.ois.nt2.data.Calendar();
    private String location = null;
    private String body = null;
    private String subject = null;
    private String uniqueID = null;
    private int privacy = 0;
    private Date startDate = null;
    private Date endDate = null;
    private int mode = -1;
    private String owner = null;
    private StringBuffer buffer = null;

    public CalendarRetriever(Person owner) {
        if (owner != null) {
            this.calendar.addPerson(owner);
        }
    }

    public CalendarRetriever() {
        this(null);
    }

    private void init() {
        this.location = EMPTY;
        this.body = EMPTY;
        this.subject = EMPTY;
        this.privacy = 0;
        this.startDate = null;
        this.endDate = null;
        this.owner = null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        switch (this.mode) {
            case 14: {
                this.body = this.buffer.toString();
                break;
            }
            case 7: {
                this.endDate = this.getDateRepresentation(this.buffer.toString());
                break;
            }
            case 9: {
                this.location = this.buffer.toString();
                break;
            }
            case 11: {
                this.owner = this.getNameRepresentation(this.buffer.toString());
                break;
            }
            case 13: {
                this.privacy = Integer.parseInt(this.buffer.toString());
                break;
            }
            case 5: {
                this.startDate = this.getDateRepresentation(this.buffer.toString());
                break;
            }
            case 3: {
                this.subject = this.buffer.toString();
                break;
            }
            case 26: {
                this.uniqueID = this.buffer.toString();
                break;
            }
        }
        switch (this.mode) {
            case 14: {
                this.mode = 1;
                break;
            }
            case 7: {
                this.mode = 6;
                break;
            }
            case 9: {
                this.mode = 8;
                break;
            }
            case 11: {
                this.mode = 10;
                break;
            }
            case 13: {
                this.mode = 12;
                break;
            }
            case 5: {
                this.mode = 4;
                break;
            }
            case 3: {
                this.mode = 2;
                break;
            }
            case 26: {
                this.mode = 25;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 25: {
                this.mode = 0;
                break;
            }
            case 0: {
                if (!qName.equals(DOCUMENT)) break;
                Appointment entry = new Appointment();
                entry.setLocation(this.location);
                entry.setDescription(this.body);
                entry.setSubject(this.subject);
                entry.setStartDate(this.startDate);
                entry.setEndDate(this.endDate);
                entry.setPrivacy(this.privacy);
                entry.setUniqueID(this.uniqueID);
                this.calendar.addCalendarEntry(entry);
                this.init();
                this.mode = -1;
                break;
            }
            default: {
                this.mode = -1;
            }
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String attValue;
        this.buffer = new StringBuffer(64);
        if (qName.equals(DOCUMENT)) {
            attValue = null;
            attValue = atts.getValue(FORM);
            if ((attValue != null || (attValue = atts.getValue(EMPTY, FORM)) != null) && attValue.equals(APPOINTMENT)) {
                this.init();
                this.mode = 0;
            }
        }
        if (this.mode == 0 && qName.equals(ITEM)) {
            attValue = null;
            attValue = atts.getValue(NAME);
            if (attValue != null || (attValue = atts.getValue(EMPTY, NAME)) != null) {
                if (attValue.equals(BODY)) {
                    this.mode = 1;
                } else if (attValue.equals(ENDDATETIME)) {
                    this.mode = 6;
                } else if (attValue.equals(LOCATION)) {
                    this.mode = 8;
                } else if (attValue.equals(PRINICPAL)) {
                    this.mode = 10;
                } else if (attValue.equals(PUBLICACCESS)) {
                    this.mode = 12;
                } else if (attValue.equals(STARTDATETIME)) {
                    this.mode = 4;
                } else if (attValue.equals(SUBJECT)) {
                    this.mode = 2;
                } else if (attValue.equals(APPT_UNID)) {
                    this.mode = 25;
                }
            }
        }
        if (this.mode == 1 && qName.equals(TEXT)) {
            this.mode = 14;
        }
        if (this.mode == 6 && qName.equals(DATETIME)) {
            this.mode = 7;
        }
        if (this.mode == 8 && qName.equals(TEXT)) {
            this.mode = 9;
        }
        if (this.mode == 10 && qName.equals(TEXT)) {
            this.mode = 11;
        }
        if (this.mode == 12 && qName.equals(TEXT)) {
            this.mode = 13;
        }
        if (this.mode == 4 && qName.equals(DATETIME)) {
            this.mode = 5;
        }
        if (this.mode == 2 && qName.equals(TEXT)) {
            this.mode = 3;
        }
        if (this.mode == 25 && qName.equals(TEXT)) {
            this.mode = 26;
        }
    }

    public void fatalError(SAXParseException e) throws SAXParseException {
        System.err.println("Error has occured.");
        System.err.println("\tmode: " + this.mode);
        System.err.println("\tbuffer: " + this.buffer.toString());
        System.err.println("\n");
        throw e;
    }

    private Date getDateRepresentation(String notesDate) {
        if (notesDate == null || notesDate.equals(EMPTY)) {
            return null;
        }
        try {
            int year = Integer.parseInt(notesDate.substring(0, 4));
            int month = Integer.parseInt(notesDate.substring(4, 6)) - 1;
            int day = Integer.parseInt(notesDate.substring(6, 8));
            int hours = Integer.parseInt(notesDate.substring(9, 11));
            int mins = Integer.parseInt(notesDate.substring(11, 13));
            String timeZoneSign = notesDate.substring(18, 19);
            int timeZoneOffset = Integer.parseInt(notesDate.substring(19, 21));
            if (timeZoneSign.equals("-")) {
                timeZoneOffset *= -1;
            }
            Calendar c = Calendar.getInstance(new SimpleTimeZone(timeZoneOffset, "Notes TimeZone"));
            c.set(1, year);
            c.set(2, month);
            c.set(5, day);
            c.set(11, hours);
            c.set(12, mins);
            c.set(13, 0);
            c.set(14, 0);
            return c.getTime();
        }
        catch (Exception e) {
            throw new DateImparsableException("Couldn't parse the given date.");
        }
    }

    public de.upb.ois.nt2.data.Calendar getCalendar() {
        return this.calendar;
    }

    public Object[] getResults() {
        return new Object[]{this.getCalendar()};
    }
}

