/*
 * Decompiled with CFR 0.152.
 */
package de.upb.ois.nt2.server.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class EnvSettings
extends JDialog {
    private JButton policyButton;
    private JTextField policyField;
    private JTextField nameField;
    private JLabel nameLabel;
    private JPanel jPanel2;
    private JTextField baseField;
    private JPanel settings;
    private JButton exit;
    private JLabel header;
    private JButton baseButton;
    private JLabel baseLabel;
    private JLabel policyLabel;

    public EnvSettings() {
        this.setModal(true);
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.header = new JLabel();
        this.settings = new JPanel();
        this.baseLabel = new JLabel();
        this.baseField = new JTextField();
        this.baseButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.policyLabel = new JLabel();
        this.policyField = new JTextField();
        this.policyButton = new JButton();
        this.jPanel2 = new JPanel();
        this.exit = new JButton();
        this.setTitle("Settings for Runtime Environment");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EnvSettings.this.exitForm(evt);
            }
        });
        this.header.setFont(new Font("SansSerif", 1, 18));
        this.header.setHorizontalAlignment(0);
        this.header.setText("Environmental Settings");
        this.getContentPane().add((Component)this.header, "North");
        this.settings.setLayout(new GridBagLayout());
        this.settings.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.baseLabel.setText("Codebase (java.rmi.server.codebase):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settings.add((Component)this.baseLabel, gridBagConstraints);
        this.baseField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.settings.add((Component)this.baseField, gridBagConstraints);
        this.baseButton.setText("Select");
        this.baseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnvSettings.this.baseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settings.add((Component)this.baseButton, gridBagConstraints);
        this.nameLabel.setText("Server Name (java.rmi.server):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settings.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.settings.add((Component)this.nameField, gridBagConstraints);
        this.policyLabel.setText("Custom policy file, if any (java.security.policy):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settings.add((Component)this.policyLabel, gridBagConstraints);
        this.policyField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.settings.add((Component)this.policyField, gridBagConstraints);
        this.policyButton.setText("Select");
        this.policyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnvSettings.this.policyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settings.add((Component)this.policyButton, gridBagConstraints);
        this.getContentPane().add((Component)this.settings, "Center");
        this.exit.setText("Ok");
        this.exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnvSettings.this.exitActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.exit);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void exitActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void policyButtonActionPerformed(ActionEvent evt) {
        File dir = new File(System.getProperty("user.dir"));
        if (this.policyField.getText() != null && !this.policyField.getText().equals("")) {
            dir = new File(this.policyField.getText()).getParentFile();
        }
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "Java Policy Files";
            }

            public boolean accept(File f) {
                return f.isDirectory() || f.getPath().endsWith(".policy");
            }
        });
        chooser.setAcceptAllFileFilterUsed(false);
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            this.policyField.setText("file://" + chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void baseButtonActionPerformed(ActionEvent evt) {
        File dir = new File(System.getProperty("user.dir"));
        String name = this.baseField.getText();
        if (name != null && !name.equals("")) {
            dir = new File(name);
        }
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "Java Archives and Directories";
            }

            public boolean accept(File f) {
                return f.isDirectory() || f.getPath().endsWith(".jar");
            }
        });
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(2);
        chooser.setApproveButtonText("Select");
        chooser.setApproveButtonMnemonic('S');
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            dir = chooser.getSelectedFile();
            if (dir.isDirectory()) {
                this.baseField.setText("file://" + dir.getAbsolutePath() + File.separator);
            } else {
                this.baseField.setText("file://" + dir.getAbsolutePath());
            }
        }
    }

    public void setCodebase(String base) {
        this.baseField.setText(base);
    }

    public String getCodebase() {
        return this.baseField.getText();
    }

    public void setName(String name) {
        this.nameField.setText(name);
    }

    public String getName() {
        return this.nameField.getText();
    }

    public void setPolicy(String policyFile) {
        this.policyField.setText(policyFile);
    }

    public String getPolicy() {
        return this.policyField.getText();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
    }
}

