/*
 * Decompiled with CFR 0.152.
 */
package de.upb.ois.nt2.server.helper;

import de.upb.ois.nt2.server.gui.EnvSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;

public class PropertyCheck {
    private static final String POLICY = "java.security.policy";
    private static final String CODEBASE = "java.rmi.server.codebase";
    private static final String SERVER = "java.rmi.server";
    private static final String EMPTY = "";

    public Properties runCheck(boolean interactively) {
        Properties sysProps = System.getProperties();
        Properties stored = PropertyCheck.loadStoredValues();
        Properties merged = this.mergeProperties(sysProps, stored);
        if (interactively) {
            EnvSettings settings = new EnvSettings();
            settings.setCodebase(merged.getProperty(CODEBASE));
            settings.setName(merged.getProperty(SERVER));
            settings.setPolicy(merged.getProperty(POLICY));
            settings.show();
            merged.put(CODEBASE, settings.getCodebase());
            merged.put(SERVER, settings.getName());
            merged.put(POLICY, settings.getPolicy());
        }
        PropertyCheck.storeProperties(merged);
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Properties loadStoredValues() {
        Properties props;
        block9: {
            props = new Properties();
            File f = new File(".rmiserver.properties");
            if (f.exists()) {
                FileInputStream in = null;
                in = new FileInputStream(f);
                props.load(in);
                Object var5_3 = null;
                try {
                    ((InputStream)in).close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                break block9;
                {
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        Object var5_4 = null;
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace(System.err);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                    }
                    throw throwable;
                }
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void storeProperties(Properties props) {
        block8: {
            Properties temp = new Properties();
            temp.put(CODEBASE, props.getProperty(CODEBASE));
            temp.put(SERVER, props.getProperty(SERVER));
            temp.put(POLICY, props.getProperty(POLICY));
            File f = new File(".rmiserver.properties");
            FileOutputStream out = null;
            out = new FileOutputStream(f);
            temp.store(out, "Lotus Notes Group Calendar RMI Server Settings - DO NOT MODIFY");
            Object var6_4 = null;
            try {
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            break block8;
            {
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    Object var6_5 = null;
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    out.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                throw throwable;
            }
        }
    }

    private Properties mergeProperties(Properties systemProperties, Properties storedProperties) {
        String server;
        String codebase;
        systemProperties = (Properties)systemProperties.clone();
        String policy = storedProperties.getProperty(POLICY);
        if (policy == null) {
            policy = EMPTY;
        }
        if ((codebase = storedProperties.getProperty(CODEBASE)) == null) {
            codebase = EMPTY;
        }
        if ((server = storedProperties.getProperty(SERVER)) == null) {
            server = EMPTY;
        }
        if (!systemProperties.containsKey(POLICY)) {
            systemProperties.put(POLICY, policy);
        }
        if (!systemProperties.containsKey(SERVER)) {
            systemProperties.put(SERVER, server);
        }
        if (!systemProperties.containsKey(CODEBASE)) {
            systemProperties.put(CODEBASE, codebase);
        }
        return systemProperties;
    }
}

