/*
 * ConfigureClient.java
 *
 * Created on 21. September 2003, 23:58
 */

package de.upb.ois.nt2.client;
import de.upb.ois.nt2.data.*;
import de.upb.ois.nt2.remote.*;
import java.rmi.*;
import javax.swing.*;
/**
 * @author  $Author: lindhrst $
 * @version $Id: ConfigureClient.java,v 1.1.1.1 2003/09/25 10:25:41 lindhrst Exp $
 */
public class ConfigureClient extends javax.swing.JFrame {
    private ConfigurationData data=new ConfigurationData();
    
    /** Creates new form ConfigureClient */
    public ConfigureClient() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        servicePane = new javax.swing.JPanel();
        serverLabel = new javax.swing.JLabel();
        serverField = new javax.swing.JTextField();
        getConfigButton = new javax.swing.JButton();
        configPane = new javax.swing.JPanel();
        smtpLabel = new javax.swing.JLabel();
        smtpField = new javax.swing.JTextField();
        userLabel = new javax.swing.JLabel();
        userField = new javax.swing.JTextField();
        passLabel = new javax.swing.JLabel();
        passField = new javax.swing.JTextField();
        debugLable = new javax.swing.JLabel();
        debugBox = new javax.swing.JCheckBox();
        setConfigButton = new javax.swing.JButton();

        getContentPane().setLayout(new javax.swing.BoxLayout(getContentPane(), javax.swing.BoxLayout.Y_AXIS));

        setTitle("Notes RMI Service Configuration Client");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        servicePane.setLayout(new java.awt.GridBagLayout());

        servicePane.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.TitledBorder("Service Data"), new javax.swing.border.EmptyBorder(new java.awt.Insets(5, 5, 5, 5))));
        serverLabel.setText("Servername (or IP):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        gridBagConstraints.weightx = 1.0;
        servicePane.add(serverLabel, gridBagConstraints);

        serverField.setColumns(20);
        serverField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                serverFieldKeyTyped(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        gridBagConstraints.weightx = 1.0;
        servicePane.add(serverField, gridBagConstraints);

        getConfigButton.setMnemonic('G');
        getConfigButton.setText("Get Configuration");
        getConfigButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                getConfigButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        servicePane.add(getConfigButton, gridBagConstraints);

        getContentPane().add(servicePane);

        configPane.setLayout(new java.awt.GridBagLayout());

        configPane.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.TitledBorder("Configuration Data"), new javax.swing.border.EmptyBorder(new java.awt.Insets(5, 5, 5, 5))));
        smtpLabel.setText("SMTP Server (or IP):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        configPane.add(smtpLabel, gridBagConstraints);

        smtpField.setColumns(20);
        smtpField.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        configPane.add(smtpField, gridBagConstraints);

        userLabel.setText("Mail User:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        configPane.add(userLabel, gridBagConstraints);

        userField.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        configPane.add(userField, gridBagConstraints);

        passLabel.setText("Password:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        configPane.add(passLabel, gridBagConstraints);

        passField.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        configPane.add(passField, gridBagConstraints);

        debugLable.setText("Debug Mode:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        configPane.add(debugLable, gridBagConstraints);

        debugBox.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        configPane.add(debugBox, gridBagConstraints);

        setConfigButton.setMnemonic('S');
        setConfigButton.setText("Set Configuration");
        setConfigButton.setEnabled(false);
        setConfigButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setConfigButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        configPane.add(setConfigButton, gridBagConstraints);

        getContentPane().add(configPane);

        pack();
    }//GEN-END:initComponents

    private void serverFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_serverFieldKeyTyped
        data=new ConfigurationData();
        
        smtpField.setEditable(false);
        userField.setEditable(false);
        passField.setEditable(false);
        debugBox.setEnabled(false);
        setConfigButton.setEnabled(false);
        getConfigButton.setEnabled(true);
        updateConfigVisuals();
    }//GEN-LAST:event_serverFieldKeyTyped

    private void setConfigButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setConfigButtonActionPerformed
        data.setDebug(debugBox.isSelected());
        data.setMailPassword(passField.getText());
        data.setMailServer(smtpField.getText());
        data.setMailUser(userField.getText());
        
        try {
            NotesDelegate remote=(NotesDelegate)Naming.lookup("//"+serverField.getText()+"/NotesDelegate");
            remote.setConfiguration(data);
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this,e,"Exception has occured",JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_setConfigButtonActionPerformed

    private void getConfigButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_getConfigButtonActionPerformed
        try {
            NotesDelegate remote=(NotesDelegate)Naming.lookup("//"+serverField.getText()+"/NotesDelegate");
            data=remote.getConfiguration();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this,e,"Exception has occured",JOptionPane.ERROR_MESSAGE);
            return ;
        }
        updateConfigVisuals();
        getConfigButton.setEnabled(false);
        setConfigButton.setEnabled(true);
        debugBox.setEnabled(true);
        passField.setEditable(true);
        userField.setEditable(true);
        smtpField.setEditable(true);
    }//GEN-LAST:event_getConfigButtonActionPerformed
    
    private void updateConfigVisuals() {
        debugBox.setSelected(data.isDebug());
        passField.setText(data.getMailPassword());
        userField.setText(data.getMailUser());
        smtpField.setText(data.getMailServer());
    }
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        if (System.getSecurityManager()==null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        new ConfigureClient().show();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel smtpLabel;
    private javax.swing.JButton getConfigButton;
    private javax.swing.JTextField smtpField;
    private javax.swing.JTextField passField;
    private javax.swing.JButton setConfigButton;
    private javax.swing.JCheckBox debugBox;
    private javax.swing.JLabel serverLabel;
    private javax.swing.JPanel configPane;
    private javax.swing.JPanel servicePane;
    private javax.swing.JLabel userLabel;
    private javax.swing.JTextField serverField;
    private javax.swing.JTextField userField;
    private javax.swing.JLabel debugLable;
    private javax.swing.JLabel passLabel;
    // End of variables declaration//GEN-END:variables
    
}
