/** Java class "Calendar.java" generated from Poseidon for UML.
 *  Poseidon for UML is developed by <A HREF="http://www.gentleware.com">Gentleware</A>.
 *  Generated with <A HREF="http://jakarta.apache.org/velocity/">velocity</A> template engine.
 */
package de.upb.ois.nt2.data;

import de.upb.ois.nt2.remote.*;

import java.io.Serializable;

import java.util.*;
import java.util.Date;
import java.util.Iterator;
import java.util.List;


/**
 * Represents a Lotus Notes (Group) Calendar and holds all relevant data such as
 * members and their appointments
 * @author $Author: lindhrst $
 * @version $Id: Calendar.java,v 1.1.1.1 2003/09/25 10:25:04 lindhrst Exp $
 */
public class Calendar implements Serializable {
    static final long serialVersionUID = -4681662866914371912L;
    private Set persons;
    private Set entries;
    private Map personEntryMap = new HashMap();
    private String calendarName = "";

    /**
     * Instantiates a Calendar
     */    
    public Calendar() {
        persons = Collections.synchronizedSet(new HashSet());
        entries = Collections.synchronizedSet(new HashSet());
        personEntryMap = Collections.synchronizedMap(new HashMap());
    }

    /** Retrieves all persons participating in the Lotus Notes Group Calendar
     * represented by the current instance.
     * @return a collection of {@link Person} objects representing group calendar members
     */    
    public Collection getPersons() {
        return persons;
    }

    // end getPersons
    /**
     * Installs the person objects of the given collection as members of the current
     * Calendar instance. <B>Note:</B> This will <I>not</I> have impact on the
     * information regarding members of the calendar as stored on the Notes/Domino
     * side. It just makes the RMI server end interpret these persons as members of
     * the calendar.
     * @param persons the collection of {@link Person} objects
     */    
    public void setPersons(Collection persons) {
        //check for persons not in list
        Iterator iterator = persons.iterator(); //parameter!
        Person person = null;

        while (iterator.hasNext()) {
            person = (Person) iterator.next();

            if (this.persons.contains(person)) { //instance variable!

                continue; //gon on
            }

            //add it to the list
            this.persons.add(person);
            personEntryMap.put(person,
                Collections.synchronizedSet(new HashSet())); //initialize entry store
        }

        //check for persons to remove
        iterator = this.persons.iterator();

        while (iterator.hasNext()) {
            person = (Person) iterator.next();

            if (!persons.contains(person)) { //parameter!
                this.persons.remove(person);
                personEntryMap.remove(person);
            }
        }
    }

    // end setPersons
    /** Adds the given {@link Person } instance to the collection of persons interpreted
     * as members of the current calendar.
     * @param person the person to be added
     * @see #removePerson(Peson)
     */    
    public void addPerson(Person person) {
        if(persons.contains(person)) {
            return;
        }
        persons.add(person);
        personEntryMap.put(person, Collections.synchronizedSet(new HashSet()));
    }

    /** Removes the named person from the calendar
     * @see #addPerson(Person)
     * @param person the person to be removed
     */    
    public void removePerson(Person person) {
        persons.remove(person);
        personEntryMap.remove(person);
    }

    // end removePerson

    /**
     * Retrieves participants for the given calendar entry
     * @return a List of Person instances
     * @param calendarEntry the entry in question
     */
    public List getParticipants(CalendarEntry calendarEntry) {
        List tempList = new LinkedList();
        Set keySet = personEntryMap.keySet();
        Iterator iterator = keySet.iterator();
        Set entrySet = null;
        Person person = null;

        while (iterator.hasNext()) {
            person = (Person) iterator.next();
            entrySet = (Set) personEntryMap.get(person);

            if (entrySet.contains(calendarEntry)) {
                tempList.add(person);
            }
        }

        return tempList;
    }

    // end getParticipants

    /**
     * Retrieves a person's calendar entries for the given point in time.
     * @return an Iterator of CalendarEntry instances
     * @param person the person to which the entries belong
     * @param date the date in question
     */
    public Iterator getCalendarEntries(Person person, Date date) {
        List list = new LinkedList();
        Set entrySet = (Set) personEntryMap.get(person);
        if(entrySet==null&&persons.contains(person)) {
            entrySet=Collections.synchronizedSet(new HashSet());
            personEntryMap.put(person,entrySet);
        }

        if (entrySet != null) { //gotch

            CalendarEntry entry = null;
            Iterator iterator = entrySet.iterator(); //holds CalendarEntries

            while (iterator.hasNext()) {
                entry = (CalendarEntry) iterator.next();

                if (entry.getStartDate().equals(date)) {
                    list.add(entry);
                } else if (entry instanceof LimitedTimeCalendarEntry &&
                        ((entry.getStartDate().before(date) &&
                        ((LimitedTimeCalendarEntry) entry).getEndDate().after(date)) ||
                        ((LimitedTimeCalendarEntry) entry).getEndDate().equals(date))) {
                    list.add(entry);
                }
            }
        }

        return list.iterator();
    }

    // end getCalendarEntries

    /**
     * Retrieves all available CalendarEntry instances for the given period
     * @return a Iterator holding CalendarEntry instances
     * @param startDate the period's start date
     * @param endDate the period's end date
     */
    public Iterator getAllCalendarEntries(Date startDate, Date endDate) {
        Iterator iterator = entries.iterator();
        CalendarEntry current = null;
        LimitedTimeCalendarEntry limited = null;
        List tempList = new LinkedList();

        while (iterator.hasNext()) {
            current = (CalendarEntry) iterator.next();

            if (current instanceof LimitedTimeCalendarEntry) {
                limited = (LimitedTimeCalendarEntry) current;

                if ((limited.getStartDate().equals(startDate) ||
                        limited.getStartDate().after(startDate)) &&
                        (limited.getEndDate().before(endDate) ||
                        limited.getEndDate().equals(endDate))) {
                    tempList.add(limited);
                }
            } else if (current instanceof Reminder) {
                if (startDate.equals(current.getStartDate()) ||
                        (startDate.before(current.getStartDate()) &&
                        current.getStartDate().before(endDate)) ||
                        endDate.equals(current.getStartDate())) {
                    tempList.add(current);
                }
            }
        }

        return tempList.iterator();
    }

    /**
     *Retrieves all entries in the calendar
     *@return an iterator of CalendarEntry instances
     */
    public Iterator getAllCalendarEntries() {
        return entries.iterator();
    }

    // end getAllCalendarEntries

    /**
     *Retrieves all know entries for the given person
     *@param person the person
     *@return the associated entries in an iterator
     */
    public Iterator getAllCalendarEntries(Person person) {
        if(personEntryMap.get(person)==null) {
            personEntryMap.put(person,Collections.synchronizedSet(new HashSet()));
        }
        return ((Set) personEntryMap.get(person)).iterator();
    }

    /** Retrieves all members of the calendar
     * @return an Iterator holding all available Person instances
     */
    public Iterator getAllPersons() {
        return persons.iterator();
    }

    // end getAllPersons

    /** Adds a calendar entry for all persons.
     * @param entry the instance to be added
     */
    public void addCalendarEntry(CalendarEntry entry) {
        entries.add(entry);

        //add it to all personal lists
        Iterator iterator = personEntryMap.keySet().iterator();
        Person currentPerson = null;
        Set entrySet=null;

        while (iterator.hasNext()) {
            currentPerson = (Person) iterator.next();
            entrySet=(Set)personEntryMap.get(currentPerson);
            if(entrySet==null) {
                entrySet=Collections.synchronizedSet(new HashSet());
                personEntryMap.put(currentPerson, entrySet);
            }
            entrySet.add(entry);
        }
    }

    /** Adds a calendar entry for the given person.
     * @throws NoSuchPersonException if the given person is not a member of the
     *  current Calendar instance
     * @param entry the CalendarEntry
     * @param person the Person instance
     */
    public void addCalendarEntry(CalendarEntry entry, Person person)
        throws de.upb.ois.nt2.remote.NoSuchPersonException {
        if (!persons.contains(person)) {
            throw new de.upb.ois.nt2.remote.NoSuchPersonException(
                "The given person is not a member of this calendar.");
        }

        //FIXME
        if (!entries.contains(entry)) {
            entries.add(entry);
        }

        Set entrySet=(Set)personEntryMap.get(person);
        if(entrySet==null) {
            entrySet=Collections.synchronizedSet(new HashSet());
            personEntryMap.put(person,entrySet);
        }
        entrySet.add(entry);
    }

    /** Removes a calendar entry from all persons' calendars.
     * @param entry the entry to be removed
     */
    public void removeCalendarEntry(CalendarEntry entry) {
        boolean found = entries.remove(entry);

        if (!found) {
            return; //go back
        }

        Iterator iterator = personEntryMap.keySet().iterator();
        
        Set entrySet=null;
        while (iterator.hasNext()) {
            entrySet=(Set) personEntryMap.get(iterator.next());
            if(entrySet!=null) {
                entrySet.remove(entry);
            }
        }
    }

    /**
     * Sets the calendar's name to the given value
     * @param calendarName the name for the calendar
     */    
    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    /** Retrieves the group calendar's name
     * @return the name
     */    
    public String getCalendarName() {
        return calendarName;
    }

    /**
     *Merges the current Calendar instance with the given parameter
     *@param c the Calendar instance to be merged
     */
    public void merge(de.upb.ois.nt2.data.Calendar c) {
        Iterator foreignEntries = c.getAllCalendarEntries();
        Iterator foreignPersons = c.getPersons().iterator();

        //add it to all entries
        CalendarEntry foreignEntry = null;

        while (foreignEntries.hasNext()) {
            foreignEntry = (CalendarEntry) foreignEntries.next();

            if (!entries.contains(foreignEntry)) {
                entries.add(foreignEntry);
            }
        }

        //add all person/entry mappings selectively
        Person currentPerson = null;
        Iterator foreignPersonEntries = null;
        Set mapping = null;

        while (foreignPersons.hasNext()) {
            currentPerson = (Person) foreignPersons.next();

            if (!persons.contains(currentPerson)) {
                persons.add(currentPerson);
            }

            //add entries
            foreignPersonEntries = c.getAllCalendarEntries(currentPerson);
            mapping = (Set) personEntryMap.get(currentPerson);

            while (foreignPersonEntries.hasNext()) {
                foreignEntry = (CalendarEntry) foreignPersonEntries.next();

                if ((mapping == null) || !mapping.contains(foreignEntry)) {
                    try {
                        addCalendarEntry(foreignEntry, currentPerson);
                    } catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
    }
}


// end Calendar
