/** Java class "CalendarEntry.java" generated from Poseidon for UML.
 *  Poseidon for UML is developed by <A HREF="http://www.gentleware.com">Gentleware</A>.
 *  Generated with <A HREF="http://jakarta.apache.org/velocity/">velocity</A> template engine.
 */
package de.upb.ois.nt2.data;

import java.io.Serializable;

import java.util.*;
import java.util.Date;


/**
 * Represents an (abstract) Calendar Entry
 * @author $Author: lindhrst $
 * @version $Id: CalendarEntry.java,v 1.1.1.1 2003/09/25 10:25:04 lindhrst Exp $
 */
public abstract class CalendarEntry implements Serializable {
    static final long serialVersionUID=-1306995013840562794L;
    /**
     * Indicates a public privacy status
     */
    public static final int PUBLIC = 1;

    /**
     * Indicates a private privacy status
     */
    public static final int PRIVATE = 2;

    /**
     * Indicates a confidential privacy status
     */
    public static final int CONFIDENTIAL = 3;

    ///////////////////////////////////////
    // attributes

    /**
     * The entry's subject
     */
    private String subject="";

    /**
     * The entry's start date
     */
    private Date startDate=new Date();

    /**
     * the entry's location
     */
    private String location="";

    /**
     * the entry's description
     */
    private String description="";

    /**
     * the entry's privacy status
     */
    private int privacy=0;

    /**
     * the entry's owner.
     */
    private Person owner=new Person();

    ///////////////////////////////////////
    // operations

    /**
     * Retrieves the start date
     * @return the entry's start date
     */
    public Date getStartDate() {
        return startDate;
    }
     // end getStartDate        

    /** Sets the entry's start date
     * @param startDate the start date
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
     // end setStartDate        

    /**
     * Retrieves the location
     * @return the entry's location
     */
    public String getLocation() {
        return location;
    }
     // end getLocation        

    /** Sets the entry's location
     * @param location the location
     */
    public void setLocation(String location) {
        this.location = location;
    }
     // end setLocation        

    /**
     * Retrieves the description
     * @return the entry's description
     */
    public String getDescription() {
        return description;
    }
     // end getDescription        

    /** Sets the entry's description
     * @param description the description
     */
    public void setDescription(String description) {
        this.description = description;
    }
     // end setDescription        

    /** Retrieves the privacy level
     * @return the entry's privacy status
     * @see #PUBLIC
     * @see #PRIVATE
     * @see #CONFIDENTIAL
     */
    public int getPrivacy() {
        return privacy;
    }
     // end getPrivacy        

    /** Sets the entry's privacy status
     * @param privacy the new privacy level
     * @see #PUBLIC
     * @see #PRIVATE
     * @see #CONFIDENTIAL
     */
    public void setPrivacy(int privacy) {
        this.privacy = privacy;
    }
     // end setPrivacy        

    /** Retrieves the entry's owner (the person who scheduled it)
     * @return the entry's owner.
     */
    public Person getOwner() {
        return owner;
    }
     // end getOwner        

    /** Sets the entry's owner (the person who scheduled it)
     * @param owner the owner
     */
    public void setOwner(Person owner) {
        this.owner = owner;
    }
     // end setOwner        

    /**
     * Retrieves the start date's hour part
     * @return the start date's hours
     * @see #getStartDate
     */
    public int getStartHours() {
        java.util.Calendar c=java.util.Calendar.getInstance();
        c.setTime(getStartDate());
        return c.get(java.util.Calendar.HOUR_OF_DAY);
    }
     // end getStartHours        

    /**
     * Retrieves the start date's minute part for convenience
     * @return minutes of start time
     * @see #getStartDate
     */
    public int getStartMinutes() {
        java.util.Calendar c=java.util.Calendar.getInstance();
        c.setTime(getStartDate());
        return c.get(java.util.Calendar.MINUTE);
    }
     // end getStartMinutes        

    /** Retrieves the subject or the title
     * @return the entry's subject
     */
    public String getSubject() {
        return subject;
    }
     // end getSubject        

    /** Sets the entry's subject
     * @param subject this entry's subject or title
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }
     // end setSubject    
    
    /** Checks for equalness of the current instance and another instance. Returns
     * <CODE>true</CODE> if and only if both objects are instances of CalendarEntry,
     * both are not null. Furthermore, let a={properties of the current instance},
     * b={properties of <CODE>o</CODE>}, then for every i:
     * <code>a<sub>i</sub>.equals(b<sub>i</sub>)</code>.
     * @param o the instance to be compared to
     * @return <CODE>true</CODE> if the requirements layed out above are met, <CODE>false</CODE> otherwise
     */    
    public boolean equals(Object o) {
        if (o==null ||!(o instanceof CalendarEntry)) {
            return false;
        }
        
        CalendarEntry other=(CalendarEntry)o;
        
        String oSubject=other.getSubject();
        Date oStartDate=other.getStartDate();
        
        boolean equalSubject=oSubject!=null&&subject!=null?oSubject.equals(subject):oSubject==subject;
        boolean equalStart=oStartDate!=null&&startDate!=null?oStartDate.equals(startDate):oStartDate==startDate;

        return equalSubject&&equalStart;
    }
}
 // end CalendarEntry
