/*
 * ConfigurationData.java
 *
 * Created on 21. September 2003, 22:02
 */

package de.upb.ois.nt2.data;

import java.io.*;

/**
 * Represents the server's configuration
 * @author  $Author: lindhrst $
 * @version $Id: ConfigurationData.java,v 1.1.1.1 2003/09/25 10:25:04 lindhrst Exp $
 */
public class ConfigurationData implements Serializable {
    static final long serialVersionUID=762043059691524333L;
    private String mailServer="";
    private String mailUser="";
    private String mailPassword="";
    private boolean debug=true;
    
    /** Creates a new instance of ConfigurationData */
    public ConfigurationData(String mailServer, String mailUser,String mailPassword,boolean debug) {
        this.mailServer=mailServer;
        this.mailUser=mailUser;
        this.mailPassword=mailPassword;
        this.debug=debug;
    }
    
    public ConfigurationData() {
        this("","","",true);
    }
    
    public void setMailServer(String mailServer) {
        this.mailServer=mailServer;
    }
    
    public String getMailServer() {
        return mailServer;
    }
    
    public void setMailUser(String mailUser) {
        this.mailUser=mailUser;
    }
    
    public String getMailUser(){
        return mailUser;
    }
    
    public void setMailPassword(String mailPassword) {
        this.mailPassword=mailPassword;
    }
    
    public String getMailPassword() {
        return mailPassword;
    }
    
    public void setDebug(boolean debug) {
        this.debug=debug;
    }
    
    public boolean isDebug() {
        return debug;
    }    
}
