/*
 * LimitedTimeCalendarEntry.java
 *
 * Created on 22. Juli 2003, 23:20
 */
package de.upb.ois.nt2.data;

import java.util.*;


/**
 * Represents a CalendarEntry with a determinable point in time marking its
 * end.
 * @version $Id: LimitedTimeCalendarEntry.java,v 1.1.1.1 2003/09/25 10:25:04 lindhrst Exp $
 * @author  $Author: lindhrst $
 */
public class LimitedTimeCalendarEntry extends CalendarEntry {
    private Date endDate = new Date(System.currentTimeMillis()+3600000);

    /** Sets the end date
     * @param endDate the end date
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    /** Retrieves the entry's end date.
     * @return the end date
     */
    public Date getEndDate() {
        return endDate;
    }

    public boolean equals(Object o) {
        if ((o == null) || !(o instanceof LimitedTimeCalendarEntry)) {
            return false;
        }

        boolean ok = super.equals(o); //check for subject and start date

        LimitedTimeCalendarEntry other = (LimitedTimeCalendarEntry) o;
        Date oEndDate = other.getEndDate();

        boolean endOk = ((oEndDate != null) && (endDate != null))
            ? oEndDate.equals(endDate) : (oEndDate == endDate);

        return ok && endOk;
    }
}
