/** Java interface "NotesDelegate.java" generated from Poseidon for UML.
 *  Poseidon for UML is developed by <A HREF="http://www.gentleware.com">Gentleware</A>.
 *  Generated with <A HREF="http://jakarta.apache.org/velocity/">velocity</A> template engine.
 */
package de.upb.ois.nt2.remote;

import de.upb.ois.nt2.data.Calendar;
import de.upb.ois.nt2.data.CalendarEntry;
import de.upb.ois.nt2.data.Person;
import de.upb.ois.nt2.data.ConfigurationData;

import java.rmi.Remote;
import java.rmi.RemoteException;

import java.util.*;


/** Represents the remote interface for RMI services providing access to
 * Notes/Domino group calendars.
 * @author $Author: lindhrst $
 * @version $Id: NotesDelegate.java,v 1.1.1.1 2003/09/25 10:25:04 lindhrst Exp $
 */
public interface NotesDelegate extends Remote {
    ///////////////////////////////////////
    // operations

    /** Retrieves all available calendars for the given person.
     * @param person the person on whose behalf to retrieve the data
     * @throws RemoteException upon communication link mishaps
     * @return all found group calendar names for the given person
     */
    public String[] getCalendarNames(Person person) throws RemoteException;

    /**
     *Fetches a Lotus Notes Group Calendar initialized with entries
     *of the calendar members. The named person's credentials will be used to
     *retrieve the required information. <b>Note:</b> If the named calendar
     *has members who are not members of the caller's domain, no information
     *about their calendars will be available.
     *@param name the Group Calendar name
     *@param person the person for which to fetch the calendar entries
     *@return the initialized calendar
     *@throws RemoteException upon RMI mishaps
     *@throws NoSuchPersonException if the named person is not a member of the
     *  named Group Calendar
     */
    public Calendar getCalendar(String name, Person person)
        throws RemoteException, NoSuchPersonException;

    /** Adds a calendar entry to the Group Calendar of the given name for the
     * given person
     * @param entry the entry
     * @param calendar the Group Calendar
     * @param person the person whose calendar to use
     * @throws RemoteException upon communication layer errors
     * @throws NoSuchPersonException ff the the given person does not seem to exist in the retrieved data
     * @throws NoSuchCalendarException if no calendar with the given name could be found
     */
    public void addCalendarEntry(CalendarEntry entry, Calendar calendar,
        Person person)
        throws RemoteException, NoSuchPersonException, NoSuchCalendarException;

    /** Removes the given calendar entry from the named group calendar of the given
     * person
     * @param entry the calendar entry
     * @param calendar the group calendar's name
     * @param person the person from whose calendar to remove the entry
     * @throws NoSuchPersonException if the given person could not be found
     * @throws RemoteException upon mishaps on the communication layer
     * @throws NoSuchCalendarException if the named calendar could not be found
     */
    public void removeCalendarEntry(CalendarEntry entry, Calendar calendar,
        Person person)
        throws NoSuchPersonException, RemoteException, NoSuchCalendarException;
    
    /** Sets the configuration data for the server instance
     * @param data the configuration data
     * @throws RemoteException upon any errors
     */    
    public void setConfiguration(ConfigurationData data) throws RemoteException;
    
    /** Retrieves the server instance's configuration data
     * @throws RemoteException upon mishaps
     * @return the configuration data found or default values if no such data was found
     */    
    public ConfigurationData getConfiguration() throws RemoteException;
}
 // end NotesDelegate
