/*
 * NotesDelegateImpl.java
 *
 * Created on 19. Juli 2003, 11:37
 */

package de.upb.ois.nt2.server;

import de.upb.ois.nt2.data.*;
import de.upb.ois.nt2.remote.*;
import de.upb.ois.nt2.server.contenthandler.*;
import de.upb.ois.nt2.server.helper.*;
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.net.MalformedURLException;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.*;
import lotus.dxl.*;
import javax.mail.*;
import javax.mail.internet.*;
import java.net.*;

/** Unicast remote object implementing remote interface.
 *
 * @author $Author: lindhrst $
 * @version $Id: NotesDelegateImpl.java,v 1.3 2003/09/25 21:04:08 lindhrst Exp $
 */
public class NotesDelegateImpl extends java.rmi.server.UnicastRemoteObject implements de.upb.ois.nt2.remote.NotesDelegate {
    static final long serialVersionUID = -4283688464062373735L;
    private static StreamEncapsulator redirect=null;
    private SAXParser parser=null;
    private File input=null;
    private DXLSession session=null;
    private HashMap sessionStorage=new HashMap();
    private ConfigurationData data=new ConfigurationData();
    
    private static String defaultServer=null;
    private static String defaultUser=null;
    private static String defaultPassword=null;
    private static final String[] cmdLineParams={"-nogui"};
    
    /* #######################################
     * #### Construction and finalization ####
     * #######################################
     */
    
    /** Constructs NotesDelegateImpl object and exports it on default port.
     */
    public NotesDelegateImpl() throws RemoteException,ParserConfigurationException,SAXException,Exception{
        super();
        
        data=retrieveConfiguration(); //retrieve saved state
        
        //get a parser
        SAXParserFactory factory=SAXParserFactory.newInstance();
        //For crying out loud, we are gettin' our stuff from Notes! You really tellin' me
        //it ain't gonna be buggy?
        factory.setValidating(false);
        //we do only DXL, no need for namespaces
        factory.setNamespaceAware(false);
        parser=factory.newSAXParser();
        
    }
    
    public void finalize() throws Exception  {
        DXLSession session=null;
        Iterator iterator=sessionStorage.entrySet().iterator();
        while(iterator.hasNext()){
            ((DXLSession)iterator.next()).term();
        }
    }
    
    /* ###########################################################
     * ############## Remote interface methods ###################
     * ###########################################################
     */
    
    /** Retrieves all available calendars for the given person.
     * @param person the person for whom to retrieve data
     */
    public String[] getCalendarNames(Person person) throws RemoteException {
        /* Steps:
         * 1. get relevant info from Person instance: Mailserver and -file,
         *      username, password
         * 2. Fetch XML and parse it
         */
        
        //1. Get relevant information bits
        String mailserver=person.getId().getServer();
        String mailfile=person.getId().getMailFile();
        String user=person.getId().getUserName();
        String password=person.getId().getPassword();
        
        //2. Fetch XML and parse it
        //Note: This constructor should fetch all group calendars, no mapping to
        //person names will be performed
        CalendarNameRetriever retriever=new CalendarNameRetriever();
        InputStream in=null;
        Exception remembered=null;
        try {
            in=getInputStream(user,password, mailfile,mailserver);
            synchronized(parser) {
                parser.parse(in,retriever);
            }
        } catch(Exception e) {
            remembered=e;
        } finally {
            try {
                in.close();
            } catch (Exception e) {
                e.printStackTrace(System.err);
            }
            closeSessionFor(Thread.currentThread());
        }
        if (remembered!=null) {
            throw new RemoteException("Couldn't parse Mail File: ",remembered);
        }
        
        return retriever.getNames();
    }
    
    /**
     *Fetches a Lotus Notes Group Calendar initialized with only entries
     *regarding the named Person instance.
     *@param name the Group Calendar name
     *@param person the person for which to fetch the calendar entries
     *@return the initialized calendar
     *@throws RemoteException upon RMI mishaps
     *@throws NoSuchPersonException if the named person is not a member of the
     *  named Group Calendar
     */
    public de.upb.ois.nt2.data.Calendar getCalendar(String name, Person person) throws RemoteException, NoSuchPersonException {
        /* Steps:
         * 1. Get relevant info: Mailfile and -server, username, password
         * 2. Initiate Parser Chain
         * 3. Fill it with several handlers for retrieval of personal calendar,
         *      readout of members for named group calendar
         * 4. Read out personal calendar and check if the given group calendar
         *      is available for the current person
         * 5. Initiate Parser chain
         * 6. Fill it with handler for names.nsf readout for each member's data
         * 7. Parse names.nsf
         * 8. For each member instantiate Person object and
         * 9. Read personal calendar for each such Person
         */
        
        de.upb.ois.nt2.data.Calendar c = null;
        
        //1. Get relevant info
        String username=person.getId().getUserName();
        String password=person.getId().getPassword();
        String mailserver=person.getId().getServer();
        String mailfile=person.getId().getMailFile();
        
        if(username==null||password==null||mailserver==null||mailfile==null) {
            throw new RemoteException("Unsufficient data in person identity.");
        }
        
        //2. Initiate Parser Chain
        ContentHandlerChain chain=new ContentHandlerChain();
        
        //3. Fill it with handlers
        CalendarRetriever calRetriever=new CalendarRetriever();
        calRetriever.getCalendar().addPerson(person);
        chain.addDefaultHandler(AbstractDefaultHandler.class,calRetriever);
        CalendarPersonsRetriever persRetriever=new CalendarPersonsRetriever(name);
        chain.addDefaultHandler(AbstractDefaultHandler.class, persRetriever);
        CalendarNameRetriever nameRetriever=new CalendarNameRetriever();
        chain.addDefaultHandler(AbstractDefaultHandler.class,nameRetriever);
        
        //4. Read out personal calendar ...
        InputStream in=null;
        Exception remembered=null;
        try {
            in=getInputStream(username, password, mailfile, mailserver);
            synchronized (parser){
                parser.parse(in,chain);
            }
        } catch (Exception e) {
            remembered=e;
        } finally {
            try {
                in.close();
            } catch (Exception e) {
                e.printStackTrace(System.err);
            }
            closeSessionFor(Thread.currentThread());
        }
        
        if (remembered!=null) {
            throw new RemoteException("Error while retrieving calendar data.", remembered);
        }
        
        // ... and check if person is in named calendar
        boolean found=false;
        String[] names=nameRetriever.getNames();
        for (int i=0;i<names.length&&!found;i++) {
            found=names[i].equals(name);
        }
        if (!found) {
            throw new NoSuchPersonException("Person is not in given Group Calendar.");
        }
        
        //We got our prime suspect's calendar ...
        c=calRetriever.getCalendar();
        //... and we know its name cuz it's where we got'em data from
        c.setCalendarName(name);
        
        Iterator persons=persRetriever.getPersons();
        HashMap map=new HashMap(5); //should be 'nuff
        String currentName=null;
        NamesNSFHandler currentHandler=null;
        
        // 5. Initiate Parser chain
        chain=new ContentHandlerChain();
        while (persons.hasNext()) {
            //6. Fill it with handler for names.nsf readout for each member's data
            currentName=persRetriever.getNaturalName(((Person)persons.next()).getName());
            currentHandler=new NamesNSFHandler(currentName);
            map.put(currentName,currentHandler);
            chain.addDefaultHandler(NamesNSFHandler.class,currentHandler);
        }
        
        //current person already checked, remove it
        chain.removeDefaultHandler(NamesNSFHandler.class, (AbstractDefaultHandler)map.get(person.getName()));
        map.remove(person.getName());
        
        //7. parse Names.nsf
        try {
            in=getInputStream(username, password, "names.nsf", mailserver);
            synchronized (parser){
                parser.parse(in,chain);
            }
        } catch (Exception e) {
            remembered=e;
        } finally {
            try {
                in.close();
            } catch (Exception e) {
                e.printStackTrace(System.err);
            }
            closeSessionFor(Thread.currentThread());
        }
        
        
        //8.  For each member instantiate Person object and
        Person currentPerson=null;
        NotesID currentId=null;
        HashMap personMap=new HashMap(10);
        Iterator keySet=map.keySet().iterator();
        while (keySet.hasNext()) {
            currentName=(String)keySet.next();
            currentHandler=(NamesNSFHandler)map.get(currentName);
            
            currentPerson=new Person();
            currentPerson.setName(currentName);
            currentId=new NotesID();
            currentPerson.setId(currentId);
            currentId.setMailFile(currentHandler.getMailFile());
            currentId.setServer(currentHandler.getMailServer());
            currentPerson.setEmail(currentHandler.getMailAddress());
            personMap.put(currentName,currentPerson);
        }
        
        //9. ... read out personal mail file
        keySet=personMap.keySet().iterator();
        de.upb.ois.nt2.data.Calendar currentCal=null;
        while (keySet.hasNext()) {
            currentName=(String)keySet.next();
            currentPerson=(Person)personMap.get(currentName);
            if (currentPerson.getId().getServer()==null||!currentPerson.getId().getServer().equals(person.getId().getServer())) {
                continue; //other domain, so not this one, baby
            }
            try {
                currentCal=getPersonalCalendarFor(currentPerson, person);
                c.merge(currentCal);
            } catch (Exception e) {
            }
        }
        
        return c;
    }
    
    public void addCalendarEntry(CalendarEntry entry, de.upb.ois.nt2.data.Calendar calendar, Person person) throws RemoteException, NoSuchPersonException, NoSuchCalendarException {
        if (!(entry instanceof Appointment)) {
            System.err.println("Entries other than appointments are currently not supported.");
            return ;
        }
        
        boolean meeting = entry instanceof Meeting;
        
        //checks
        if (data==null) {
            throw new RuntimeException("Configuration not available.");
        }
        String smtpServer=data.getMailServer();
        if (smtpServer==null||smtpServer.equals("")) {
            throw new RuntimeException("Configuration not available.");
        }
        String smtpUser=data.getMailUser();
        if (smtpUser==null||smtpUser.equals("")) {
            throw new RuntimeException("Configuration not available.");
        }
        String smtpPass=data.getMailPassword();
        if (smtpPass==null||smtpPass.equals("")) {
            throw new RuntimeException("Configuration not available.");
        }
        //config ok
        
        //Generate XML
        DataProcessor processor=new DataProcessor(person, (Appointment)entry);
        if (!data.isDebug()) {
            PromptFooler fooler=new PromptFooler(person.getId().getPassword());
            fooler.start();
            DXLSession localSession=(DXLSession)sessionStorage.get(Thread.currentThread());
            Exception remembered=null;
            
            try {
                if (localSession==null) {
                    localSession=new DXLSession();
                    sessionStorage.put(Thread.currentThread(),localSession);
                }
                DXLDatabase database=new DXLDatabase(person.getId().getMailFile());
                localSession.init(person.getId().getUserName());
                DXLImportOptions options=new DXLImportOptions();
                options.setDefaults();
                options.setCreateDbOption(DXLImportOptions.CREATEDB_NEVER);
                options.setDesignOption(DXLImportOptions.IMPORT_IGNORE);
                options.setDocumentsOption(DXLImportOptions.IMPORT_REPLACE);
                options.setReplaceDbProperties(false);
                DXLImporter importer=new DXLImporter(session);
                importer.setImportOptions(options);
                DXLDatabase target=new DXLDatabase(person.getId().getMailFile(),person.getId().getServer());
                InputStream in=new ByteArrayInputStream(processor.getDXL().getBytes());
                importer.importDXL(in,target);
            } catch(Exception e){
                remembered=e;
                e.printStackTrace(System.err);
            } finally {
                fooler.stopMe();
                closeSessionFor(Thread.currentThread());
            }
            if(remembered!=null){
                throw new RuntimeException("Exception encountered",remembered);
            }
        }
        //prepare mail
        Properties props=System.getProperties();
        props.put("mail.smtp.host", smtpServer);
        
        try {
            Session session=Session.getDefaultInstance(props, null);
            MimeMessage msg=new MimeMessage(session);
            msg.setFrom(new InternetAddress(person.getEmail()));
            msg.addRecipient(Message.RecipientType.TO,new InternetAddress(person.getEmail()));
            msg.setSubject("Gruppen-Kalender-Eintrag");
            String text=processor.getMailText(data.isDebug());
            text=text+DataProcessor.CHECK;
            msg.setText(text);
            Transport.send(msg);
            if (meeting) {
                msg=new MimeMessage(session);
                msg.setFrom(new InternetAddress(person.getEmail()));
                java.util.Iterator iterator=calendar.getAllPersons();
                while (iterator.hasNext()) {
                    msg.addRecipient(Message.RecipientType.TO,new InternetAddress(((Person)iterator.next()).getEmail()));
                }
                text=processor.getMailText(data.isDebug());
                text=text+processor.PLEASE_VALIDATE;
                msg.setText(text);
                Transport.send(msg);
            }
        } catch (Exception e) {
            throw new RuntimeException("",e);
        }
        
    }
    
    public void removeCalendarEntry(CalendarEntry entry, de.upb.ois.nt2.data.Calendar calendar, Person person) throws NoSuchPersonException, RemoteException, NoSuchCalendarException {
    }
    
    /* ############################################
     * ########### Helper methods #################
     * ############################################
     */
    
    private InputStream getInputStream(String username, String password ,String databaseName,String serverName) throws Exception{
        InputStream in=null;
        if (data.isDebug()) {
            /* We're in debug mode, get data from bundled XML Files */
            if (databaseName.endsWith("names.nsf")||databaseName.endsWith("names")) {
                in=this.getClass().getResourceAsStream("contentHandler/debugdata/names.nsf.xml");
            } else {
                in=this.getClass().getResourceAsStream("contentHandler/debugdata/msteckenborn.nsf.xml");
            }
        } else {
            PromptFooler fooler=new PromptFooler(password);
            fooler.start();
            DXLSession localSession=(DXLSession)sessionStorage.get(Thread.currentThread());
            if (localSession==null) {
                localSession=new DXLSession();
                sessionStorage.put(Thread.currentThread(),localSession);
            }
            DXLDatabase database=new DXLDatabase(databaseName);
            localSession.init(username);
            DXLExportOptions options=new DXLExportOptions();
            options.setInterpretNotes(false);
            options.setInterpretRichText(false);
            options.setExportedSchemaName("");
            DXLExporter exporter=new DXLExporter(localSession);
            exporter.setExportOptions(options);
            
            //Watch out for dead locks!
            in=new PipedInputStream();
            //this will provide a means of output for the application
            PipedOutputStream out=new PipedOutputStream((PipedInputStream)in);
            
            Exception remembered=null;
            try{
                exporter.exportDXL(database,out);
            } catch(Exception e){
                remembered=e;
                e.printStackTrace(System.err);
            } finally {
                fooler.stopMe();
            }
            if(remembered!=null){
                throw remembered;
            }
        }
        return in;
    }
    
    private void closeSessionFor(Thread thread) {
        DXLSession threadSession=(DXLSession) sessionStorage.get(thread);
        if (threadSession!=null) {
            threadSession.term();
            sessionStorage.remove(thread);
        }
    }
    
    /**
     * Retrieves calendar data of one person using the credentials of another.
     * This is normally the case when one person tries to retrieve a group
     * calendar and - in that process - has to access other Notes users' data.
     * @person the calendar owner
     * @requester the person on whose behalf the request is made
     * @return a calendar object containing retrieved data (maybe empty but never
     *      <code>null</code>)
     * @throws Exception upon mishaps
     */
    private de.upb.ois.nt2.data.Calendar getPersonalCalendarFor(Person person,Person requester) throws Exception{
        de.upb.ois.nt2.data.Calendar calendar=new de.upb.ois.nt2.data.Calendar();
        
        String mailserver=person.getId().getServer();
        String mailfile=person.getId().getMailFile();
        if (mailserver==null||mailserver.equals("")||mailfile==null||mailfile.equals("")) {
            return calendar; //nothing to retrieve
        }
        
        String username=requester.getId().getUserName();
        String password=requester.getId().getPassword();
        
        InputStream in=null;
        CalendarRetriever retriever=new CalendarRetriever();
        calendar=retriever.getCalendar();
        calendar.addPerson(person);
        Exception remembered=null;
        try {
            in=getInputStream(username, password, mailfile,mailserver);
            synchronized (parser) {
                parser.parse(in,retriever);
            }
            
        } catch (Exception e) {
            remembered=e;
        } finally {
            try {
                in.close();
            } catch (Exception e) {
                e.printStackTrace(System.err);
            }
            closeSessionFor(Thread.currentThread());
        }
        
        if (remembered!=null) {
            throw remembered;
        }
        
        return calendar;
    }
    
    public void setConfiguration(ConfigurationData data) throws RemoteException {
        this.data=data;
        try {
            saveConfiguration();
        } catch (Exception e) {
            throw new RuntimeException("Configuration couldn't be saved: ",e);
        }
    }
    
    public ConfigurationData getConfiguration() throws RemoteException {
        return data;
    }
    
    /**
     *serializes configuration data
     */
    private void saveConfiguration() throws IOException{
        File file=new File(".notesrmiserver");
        ObjectOutputStream out=new ObjectOutputStream(new FileOutputStream(file));
        out.writeObject(data);
    }
    
    /**
     *deserializes Settings
     */
    private ConfigurationData retrieveConfiguration() throws IOException {
        File file=new File(".notesrmiserver");
        if (!file.exists()) {
            return new ConfigurationData(); //defaults
        }
        
        ConfigurationData config=null;
        ObjectInputStream in=new ObjectInputStream(new FileInputStream(file));
        try {
            config=(ConfigurationData)in.readObject();
        } catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException");
        }
        return config;
    }
    
    
    /* #######################################
     * ########## Static stuff ###############
     * #######################################
     */
    
    
    /** Register NotesDelegateImpl object with the RMI registry.
     * @param name - name identifying the service in the RMI registry
     * @param create - create local registry if necessary
     * @throw RemoteException if cannot be exported or bound to RMI registry
     * @throw MalformedURLException if name cannot be used to construct a valid URL
     * @throw IllegalArgumentException if null passed as name
     */
    public static void registerToRegistry(String name, Remote obj, boolean create) throws RemoteException, MalformedURLException{
        
        if (name == null) throw new IllegalArgumentException("registration name can not be null");
        
        Naming.rebind(name,obj);
        System.out.println("Registered");
    }
    
    private static boolean checkParameterValidity(String[] args) {
        boolean foundAll=true;
        boolean found=false;
        for (int i=0;i<args.length;i++) {
            found=false;
            for (int j=0;j<cmdLineParams.length&&!found;j++) {
                found=cmdLineParams[j].equals(args[i]);
            }
            foundAll=foundAll&&found;
        }
        return foundAll;
    }
    
    /** Main method
     */
    public static void main(String[] args) throws Exception {
        //ok now every kind of output should be handled directly
        redirect=new StreamEncapsulator();
        
        //1. Check if all parameters are valid
        if (!checkParameterValidity(args)) {
            System.out.println("Usage: java de.upb.ois.nt2.server.NotesDelegateImpl [-nogui]");
            redirect.getBufferedOutput();
            System.exit(1);
        }
        
        //3. Make a set
        Set params=new HashSet();
        for (int i=0;i<args.length;i++) {
            params.add(args[i]);
        }
        
        //now for the real action
        
        //check system properties
        if (params.contains("-nogui")) {
            System.setProperties(new PropertyCheck().runCheck(false));
        } else {
            System.setProperties(new PropertyCheck().runCheck(true));
        }
        
        //Gentlemen, start your engines
        System.setSecurityManager(new RMISecurityManager());
        
        try {
            NotesDelegateImpl obj = new NotesDelegateImpl();
            registerToRegistry("//"+System.getProperties().getProperty("java.rmi.server")+"/NotesDelegate", obj, false);
        } catch (RemoteException ex) {
            ex.printStackTrace();
        } catch (MalformedURLException ex) {
            ex.printStackTrace();
        } catch (ParserConfigurationException ex) {
            ex.printStackTrace(System.err);
        } catch (SAXException ex) {
            ex.printStackTrace(System.err);
        } catch(Exception e) {
            e.printStackTrace(System.err);
        }
        redirect.getBufferedOutput();
    }
    
    private class PromptFooler extends Thread {
        private String password=null;
        private boolean keepGoing=true;
        
        PromptFooler(String password) {
            if(password==null) {
                throw new IllegalArgumentException("Not a valid password.");
            }
            this.password=password;
        }
        
        public void run() {
            StringBuffer buffer=new StringBuffer(1024);
            while(keepGoing) {
                buffer.append(redirect.getBufferedOutput());
                if(buffer.toString().indexOf("password")>=0){
                    redirect.writePassword(password);
                }
                try {
                    Thread.sleep(100);
                } catch(Exception e){
                    //so what
                }
            }
        }
        
        public void stopMe(){
            keepGoing=false;
        }
    }
}