/*
 * AbstractDefaultHandler.java
 *
 * Created on 23. Juli 2003, 21:39
 */
package de.upb.ois.nt2.server.contenthandler;


/**
 *
 * @author  $Author: lindhrst $
 * @version $Id: AbstractDefaultHandler.java,v 1.1.1.1 2003/09/25 10:25:05 lindhrst Exp $
 */
public abstract class AbstractDefaultHandler
    extends org.xml.sax.helpers.DefaultHandler {
    /**
     *Returns a representation of the given name where the hierarchical
     *inidicators such as CN and O are removed. Furthermore, other than in 
     *{@link #getNameRepresentation(String)}, organizational information will
     *be removed entirely, leaving only a natural name.
     *@param originalName the original name
     *@return the natural name contained in the given parameter
     *@see #getNameRepresentation(String)
     */
    public String getNaturalName(String originalName) {
        if ((originalName == null) || originalName.equals("")) {
            return originalName;
        }

        int startIndex = originalName.indexOf('=');

        if (startIndex < 0) {
            startIndex = 0;
        } else {
            startIndex++; //also take away the letter itself
        }

        int endIndex = originalName.indexOf('/');

        if ((endIndex > originalName.length()) || (endIndex < startIndex)) {
            endIndex = originalName.length();
        }

        String representation = originalName.substring(startIndex, endIndex);

        return representation;
    }

    /**
     *Returns a representation of the given original Name where the normal
     *hierarchical indicator for common name (CN) and organization (O) are
     *removed and the name and the organization are concatenated, separated
     *only by a slash.
     *@param originalName the name
     *@return the shortened representation
     */
    public String getNameRepresentation(String originalName) {
        if ((originalName == null) || originalName.equals("")) {
            return originalName;
        }

        int startIndex = originalName.indexOf('=');

        if (startIndex < 0) {
            startIndex = 0;
        } else {
            startIndex++; //also take away the letter itself
        }

        int endIndex = originalName.indexOf('/');

        if ((endIndex > originalName.length()) || (endIndex < startIndex)) {
            endIndex = originalName.length();
        }

        String representation = originalName.substring(startIndex, endIndex);

        if (endIndex < originalName.length()) {
            String secondHalf = getNameRepresentation(originalName.substring(endIndex +
                        1, originalName.length()));

            if ((secondHalf != null) && (secondHalf.length() > 0)) {
                representation = representation + "/" + secondHalf;
            }
        }

        return representation;
    }

    public abstract Object[] getResults();
}
