/*
 * CalendarNameRetriever.java
 *
 * Created on 19. Juli 2003, 12:23
 */
package de.upb.ois.nt2.server.contenthandler;

import de.upb.ois.nt2.data.*;

import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

import java.util.*;


/**
 *
 * @author  $Author: lindhrst $
 * @version $Id: CalendarNameRetriever.java,v 1.1.1.1 2003/09/25 10:25:05 lindhrst Exp $
 */
public class CalendarNameRetriever extends AbstractDefaultHandler {
    private static final int IRRELEVANT_MODE = 0;
    private static final int DOCUMENT_MODE = 1;
    private static final int NAME_TEXT_MODE = 2;
    private static final int PERSON_TEXT_MODE = 3;
    private static final int NAME_MODE = 4;
    private static final int PERSON_MODE = 5;
    private static final String DOCUMENT = "document";
    private static final String ITEM = "item";
    private static final String TEXT = "text";
    private static final String NAME = "name";
    private static final String MEMBERS = "Members";
    private static final String EMPTY = "";
    private static final String FORM = "form";
    private static final String SUBJECT = "Subject";
    private static final String GROUP_CALENDAR = "(GroupCalendar)";
    private int mode = IRRELEVANT_MODE;
    private List names = new LinkedList();
    private List persons = new LinkedList();
    private StringBuffer nameBuffer = null;
    private StringBuffer personBuffer = null;
    private String personName = "";

    public CalendarNameRetriever(Person person) {
        if ((person != null) && (person.getName() != null)) {
            personName = person.getName(); //find all calendars
        }
    }

    public CalendarNameRetriever() {
        this(null);
    }

    public void characters(char[] ch, int start, int length)
        throws SAXException {
        if (mode == NAME_TEXT_MODE) {
            nameBuffer.append(ch, start, length);
        }

        if (mode == PERSON_TEXT_MODE) {
            personBuffer.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName)
        throws SAXException {
        if (qName.equals(DOCUMENT) && (mode == DOCUMENT_MODE)) {
            mode = IRRELEVANT_MODE;

            //are we to add the calendar to available calendars for the given
            //person?
            Iterator iterator = persons.iterator();

            while (iterator.hasNext()) {
                //the following line adds all calendars if no person is given
                //because personName==""
                if (((String) iterator.next()).indexOf(personName) >= 0) {
                    names.add(nameBuffer.toString());

                    break;
                }
            }

            nameBuffer = new StringBuffer(); //clean out the rest

            return;
        }

        if (((mode == NAME_MODE) || (mode == PERSON_MODE)) &&
                qName.equals(ITEM)) {
            mode = DOCUMENT_MODE;
        }

        if (qName.equals(TEXT) && (mode == NAME_TEXT_MODE)) {
            mode = NAME_MODE;

            return;
        }

        if (qName.equals(TEXT) && (mode == PERSON_TEXT_MODE)) {
            //append current buffer
            persons.add(getNameRepresentation(personBuffer.toString()));
            mode = PERSON_MODE;

            return;
        }
    }

    public void startElement(String namespaceURI, String localName,
        String qName, Attributes atts) throws SAXException {
        if ((mode == IRRELEVANT_MODE) && qName.equals(DOCUMENT)) {
            String attValue = null;

            if (((attValue = atts.getValue(FORM)) != null) ||
                    ((attValue = atts.getValue(EMPTY, FORM)) != null)) {
                if (attValue.equals(GROUP_CALENDAR)) {
                    mode = DOCUMENT_MODE;
                    persons.clear();
                }
            }

            return;
        }

        if ((mode == DOCUMENT_MODE) && qName.equals(ITEM)) {
            //we need name="Subject"
            String attValue = null;

            if (((attValue = atts.getValue(NAME)) != null) ||
                    ((attValue = atts.getValue(EMPTY, NAME)) != null)) {
                if (attValue.equals(SUBJECT)) {
                    mode = NAME_MODE;
                } else if (attValue.equals(MEMBERS)) {
                    mode = PERSON_MODE;
                }
            }

            return;
        }

        if ((mode == NAME_MODE) && qName.equals(TEXT)) {
            nameBuffer = new StringBuffer();
            mode = NAME_TEXT_MODE;

            return;
        }

        if ((mode == PERSON_MODE) && qName.equals(TEXT)) {
            personBuffer = new StringBuffer();
            mode = PERSON_TEXT_MODE;
        }
    }

    public String[] getNames() {
        String[] array = new String[names.size()];
        Iterator iterator = names.iterator();
        int i = 0;

        while (iterator.hasNext()) {
            array[i] = (String) iterator.next(); //danger: IndexOutOfBounds?
            i++;
        }

        return array;
    }

    public Object[] getResults() {
        String[] array = getNames();
        Object[] results = new Object[array.length];
        System.arraycopy(array, 0, results, 0, array.length);

        return results;
    }
}
