/*
 * CalendarPersonsRetriever.java
 *
 * Created on 23. Juli 2003, 09:12
 */
package de.upb.ois.nt2.server.contenthandler;

import de.upb.ois.nt2.data.*;

import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

import java.util.*;


/**
 *
 * @author  $Author: lindhrst $
 * @version $Id: CalendarPersonsRetriever.java,v 1.1.1.1 2003/09/25 10:25:05 lindhrst Exp $
 */
public class CalendarPersonsRetriever extends AbstractDefaultHandler {
    private static final int IRRELEVANT_MODE = 0;
    private static final int DOCUMENT_MODE = 1;
    private static final int NAME_TEXT_MODE = 2;
    private static final int PERSON_TEXT_MODE = 3;
    private static final int NAME_MODE = 4;
    private static final int PERSON_MODE = 5;
    private static final String DOCUMENT = "document";
    private static final String ITEM = "item";
    private static final String TEXT = "text";
    private static final String NAME = "name";
    private static final String MEMBERS = "Members";
    private static final String EMPTY = "";
    private static final String FORM = "form";
    private static final String SUBJECT = "Subject";
    private static final String GROUP_CALENDAR = "(GroupCalendar)";
    private int mode = IRRELEVANT_MODE;
    private List persons = null;
    private List returnablePersons = null;
    private StringBuffer nameBuffer = null;
    private StringBuffer personBuffer = null;
    private String calendarName = "";
    private boolean addFlag = false;

    public CalendarPersonsRetriever(String calendarName) {
        this.calendarName = calendarName;
        persons = new LinkedList();
        returnablePersons = new LinkedList();
    }

    public void characters(char[] ch, int start, int length)
        throws SAXException {
        if (mode == NAME_TEXT_MODE) {
            nameBuffer.append(ch, start, length);
        }

        if (mode == PERSON_TEXT_MODE) {
            personBuffer.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName)
        throws SAXException {
        if (qName.equals(DOCUMENT) && (mode == DOCUMENT_MODE)) {
            mode = IRRELEVANT_MODE;

            //if we were in the right section the addFlag is set
            if (addFlag) {
                Iterator iterator = persons.iterator(); //holds persons
                Person temPerson = null;

                while (iterator.hasNext()) {
                    temPerson = (Person) iterator.next();
                    returnablePersons.add(temPerson);
                }
            }

            return;
        }

        if (((mode == NAME_MODE) || (mode == PERSON_MODE)) &&
                qName.equals(ITEM)) {
            mode = DOCUMENT_MODE;
        }

        if (qName.equals(TEXT) && (mode == NAME_TEXT_MODE)) {
            mode = NAME_MODE;

            if (nameBuffer.toString().equals(calendarName)) {
                addFlag = true; //we found the calendar
            }

            return;
        }

        if (qName.equals(TEXT) && (mode == PERSON_TEXT_MODE)) {
            //append current buffer
            Person person = new Person();
            person.setName(getNaturalName(personBuffer.toString()));
            persons.add(person);
            mode = PERSON_MODE;

            return;
        }
    }

    public void startElement(String namespaceURI, String localName,
        String qName, Attributes atts) throws SAXException {
        if ((mode == IRRELEVANT_MODE) && qName.equals(DOCUMENT)) {
            String attValue = null;

            if (((attValue = atts.getValue(FORM)) != null) ||
                    ((attValue = atts.getValue(EMPTY, FORM)) != null)) {
                if (attValue.equals(GROUP_CALENDAR)) {
                    mode = DOCUMENT_MODE;
                    persons.clear();
                    addFlag = false;
                }
            }

            return;
        }

        if ((mode == DOCUMENT_MODE) && qName.equals(ITEM)) {
            //we need name="Subject"
            String attValue = null;

            if (((attValue = atts.getValue(NAME)) != null) ||
                    ((attValue = atts.getValue(EMPTY, NAME)) != null)) {
                if (attValue.equals(SUBJECT)) {
                    mode = NAME_MODE;
                } else if (attValue.equals(MEMBERS)) {
                    mode = PERSON_MODE;
                }
            }

            return;
        }

        if ((mode == NAME_MODE) && qName.equals(TEXT)) {
            nameBuffer = new StringBuffer();
            mode = NAME_TEXT_MODE;

            return;
        }

        if ((mode == PERSON_MODE) && qName.equals(TEXT)) {
            personBuffer = new StringBuffer();
            mode = PERSON_TEXT_MODE;
        }
    }

    /**
     *Retrieves the list of persons belonging to the Group Calendar of the name
     *given to the constructor.
     */
    public Iterator getPersons() {
        return returnablePersons.iterator();
    }

    public Object[] getResults() {
        Object[] results = new Object[returnablePersons.size()];
        Iterator persons = getPersons();
        int i = 0;

        while (persons.hasNext()) {
            results[i] = persons.next();
            i++;
        }

        return results;
    }
}
