/*
 * CalendarRetriever.java
 *
 * Created on 22. Juli 2003, 08:21
 */
package de.upb.ois.nt2.server.contenthandler;

import de.upb.ois.nt2.data.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import java.util.*;


/**
 *
 * @author  $Author: lindhrst $
 * @version $Id: CalendarRetriever.java,v 1.1.1.1 2003/09/25 10:25:05 lindhrst Exp $
 */
public class CalendarRetriever extends AbstractDefaultHandler {
    public static final int IRRELEVANT = -1;

    /*Relevant attributes*/
    public static final String EMPTY = "";
    public static final String NAME = "name";
    public static final String FORM = "form";
    public static final String NAMES = "names";

    /*Relevant tags*/
    public static final String DOCUMENT = "document";
    public static final String ITEM = "item";
    public static final String TEXT = "text";
    public static final String TEXTLIST = "textlist";
    public static final String DATETIME = "datetime";

    /*APPOINTMENT CONSTANTS*/
    public static final int APPOINTMENT_MODE = 0;
    public static final int APPOINTMENT_BODY_MODE = 1;
    public static final int APPOINTMENT_BODY_TEXT_MODE = 14;
    public static final int APPOINTMENT_SUBJECT_MODE = 2;
    public static final int APPOINTMENT_SUBJECT_TEXT_MODE = 3;
    public static final int APPOINTMENT_STARTDATE_MODE = 4;
    public static final int APPOINTMENT_STARTDATE_DATETIME_MODE = 5;
    public static final int APPOINTMENT_ENDDATE_MODE = 6;
    public static final int APPOINTMENT_ENDDATE_DATETIME_MODE = 7;
    public static final int APPOINTMENT_LOCATION_MODE = 8;
    public static final int APPOINTMENT_LOCATION_TEXT_MODE = 9;
    public static final int APPOINTMENT_PRINCIPAL_MODE = 10;
    public static final int APPOINTMENT_PRINCIPAL_TEXT_MODE = 11;
    public static final int APPOINTMENT_PUBLIC_ACCESS_MODE = 12;
    public static final int APPOINTMENT_PUBLIC_ACCESS_TEXT_MODE = 13;
    public static final int APPOINTMENT_APPT_UNID_MODE = 25;
    public static final int APPOINTMENT_APPT_UNID_TEXT_MODE = 26;

    /*APPOINTMENT VALUES*/
    public static final String APPOINTMENT = "Appointment";
    public static final String SUBJECT = "Subject";
    public static final String STARTDATETIME = "STARTDATETIME";
    public static final String LOCATION = "Location";
    public static final String BODY = "Body";
    public static final String PUBLICACCESS = "$PublicAccess";
    public static final String PRINICPAL = "Principal";
    public static final String ENDDATETIME = "EndDateTime";
    public static final String APPT_UNID = "ApptUNID";

    /*Instance properties*/
    private de.upb.ois.nt2.data.Calendar calendar = null;
    private String location = null;
    private String body = null;
    private String subject = null;
    private String uniqueID = null;
    private int privacy = 0;
    private Date startDate = null;
    private Date endDate = null;
    private int mode = IRRELEVANT;
    private String owner = null;
    private StringBuffer buffer = null;

    /**
     * Creates a CalendarRetriever which will attribute all found calendar
     * data to the given person
     * @param owner the calendar's owner
     */
    public CalendarRetriever(Person owner) {
        calendar = new de.upb.ois.nt2.data.Calendar();

        if (owner != null) {
            calendar.addPerson(owner);
        }
    }

    /**
     * Creates a CalendarRetriever object with a calendar that is assigned to
     * nobody. Before using the instance for parsing, the inherent calendar
     * should be altered to have at least one person to which to attribute
     * found data to.
     * @see #getCalendar
     */
    public CalendarRetriever() {
        this(null);
    }

    private void init() {
        location = "";
        body = "";
        subject = "";
        privacy = 0;
        startDate = null;
        endDate = null;
        owner = null;
    }

    public void characters(char[] ch, int start, int length)
        throws SAXException {
        buffer.append(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName)
        throws SAXException {
        //Evaluate findings
        switch (mode) {
        case APPOINTMENT_BODY_TEXT_MODE:
            body = buffer.toString();

            break;

        case APPOINTMENT_ENDDATE_DATETIME_MODE:
            endDate = getDateRepresentation(buffer.toString());

            break;

        case APPOINTMENT_LOCATION_TEXT_MODE:
            location = buffer.toString();

            break;

        case APPOINTMENT_PRINCIPAL_TEXT_MODE:
            owner = getNameRepresentation(buffer.toString());

            break;

        case APPOINTMENT_PUBLIC_ACCESS_TEXT_MODE:
            privacy = Integer.parseInt(buffer.toString());

            break;

        case APPOINTMENT_STARTDATE_DATETIME_MODE:
            startDate = getDateRepresentation(buffer.toString());

            break;

        case APPOINTMENT_SUBJECT_TEXT_MODE:
            subject = buffer.toString();

            break;

        case APPOINTMENT_APPT_UNID_TEXT_MODE:
            uniqueID = buffer.toString();

            break;

        default: //do nutt'n
        }

        //then switch mode
        switch (mode) {
        case APPOINTMENT_BODY_TEXT_MODE:
            mode = APPOINTMENT_BODY_MODE;

            break;

        case APPOINTMENT_ENDDATE_DATETIME_MODE:
            mode = APPOINTMENT_ENDDATE_MODE;

            break;

        case APPOINTMENT_LOCATION_TEXT_MODE:
            mode = APPOINTMENT_LOCATION_MODE;

            break;

        case APPOINTMENT_PRINCIPAL_TEXT_MODE:
            mode = APPOINTMENT_PRINCIPAL_MODE;

            break;

        case APPOINTMENT_PUBLIC_ACCESS_TEXT_MODE:
            mode = APPOINTMENT_PUBLIC_ACCESS_MODE;

            break;

        case APPOINTMENT_STARTDATE_DATETIME_MODE:
            mode = APPOINTMENT_STARTDATE_MODE;

            break;

        case APPOINTMENT_SUBJECT_TEXT_MODE:
            mode = APPOINTMENT_SUBJECT_MODE;

            break;

        case APPOINTMENT_APPT_UNID_TEXT_MODE:
            mode = APPOINTMENT_APPT_UNID_MODE;

        case APPOINTMENT_APPT_UNID_MODE: //falls through
        case APPOINTMENT_BODY_MODE: //falls through
        case APPOINTMENT_ENDDATE_MODE: //falls through
        case APPOINTMENT_LOCATION_MODE: //falls through
        case APPOINTMENT_PRINCIPAL_MODE: //falls through
        case APPOINTMENT_PUBLIC_ACCESS_MODE: //falls through
        case APPOINTMENT_STARTDATE_MODE: //falls through
        case APPOINTMENT_SUBJECT_MODE:
            mode = APPOINTMENT_MODE;

            break;

        case APPOINTMENT_MODE:

            if (qName.equals(DOCUMENT)) { //only for documents!

                Appointment entry = new Appointment();
                entry.setLocation(location);
                entry.setDescription(body);
                entry.setSubject(subject);
                entry.setStartDate(startDate);
                entry.setEndDate(endDate);
                entry.setPrivacy(privacy); //falls through
                entry.setUniqueID(uniqueID);
                calendar.addCalendarEntry(entry);

                //reinit
                init();
                mode = IRRELEVANT;
            }

            break;

        default:
            mode = IRRELEVANT;
        }
    }

    public void startElement(String namespaceURI, String localName,
        String qName, Attributes atts) throws SAXException {
        //a new element starts, thus we need a new buffer
        buffer = new StringBuffer(64); //should be fine

        //set the right mode for text operations (characters(...))
        if (qName.equals(DOCUMENT)) {
            String attValue = null;

            if (((attValue = atts.getValue(FORM)) != null) ||
                    ((attValue = atts.getValue(EMPTY, FORM)) != null)) {
                if (attValue.equals(APPOINTMENT)) {
                    init();
                    mode = APPOINTMENT_MODE;
                }
            }
        }

        if ((mode == APPOINTMENT_MODE) && qName.equals(ITEM)) {
            String attValue = null;

            if (((attValue = atts.getValue(NAME)) != null) ||
                    ((attValue = atts.getValue(EMPTY, NAME)) != null)) {
                if (attValue.equals(BODY)) {
                    mode = APPOINTMENT_BODY_MODE;
                } else if (attValue.equals(ENDDATETIME)) {
                    mode = APPOINTMENT_ENDDATE_MODE;
                } else if (attValue.equals(LOCATION)) {
                    mode = APPOINTMENT_LOCATION_MODE;
                } else if (attValue.equals(PRINICPAL)) {
                    mode = APPOINTMENT_PRINCIPAL_MODE;
                } else if (attValue.equals(PUBLICACCESS)) {
                    mode = APPOINTMENT_PUBLIC_ACCESS_MODE;
                } else if (attValue.equals(STARTDATETIME)) {
                    mode = APPOINTMENT_STARTDATE_MODE;
                } else if (attValue.equals(SUBJECT)) {
                    mode = APPOINTMENT_SUBJECT_MODE;
                } else if (attValue.equals(APPT_UNID)) {
                    mode = APPOINTMENT_APPT_UNID_MODE;
                }
            }
        }

        if ((mode == APPOINTMENT_BODY_MODE) && qName.equals(TEXT)) {
            mode = APPOINTMENT_BODY_TEXT_MODE;
        }

        if ((mode == APPOINTMENT_ENDDATE_MODE) && qName.equals(DATETIME)) {
            mode = APPOINTMENT_ENDDATE_DATETIME_MODE;
        }

        if ((mode == APPOINTMENT_LOCATION_MODE) && qName.equals(TEXT)) {
            mode = APPOINTMENT_LOCATION_TEXT_MODE;
        }

        if ((mode == APPOINTMENT_PRINCIPAL_MODE) && qName.equals(TEXT)) {
            mode = APPOINTMENT_PRINCIPAL_TEXT_MODE;
        }

        if ((mode == APPOINTMENT_PUBLIC_ACCESS_MODE) && qName.equals(TEXT)) {
            mode = APPOINTMENT_PUBLIC_ACCESS_TEXT_MODE;
        }

        if ((mode == APPOINTMENT_STARTDATE_MODE) && qName.equals(DATETIME)) {
            mode = APPOINTMENT_STARTDATE_DATETIME_MODE;
        }

        if ((mode == APPOINTMENT_SUBJECT_MODE) && qName.equals(TEXT)) {
            mode = APPOINTMENT_SUBJECT_TEXT_MODE;
        }

        if ((mode == APPOINTMENT_APPT_UNID_MODE) && qName.equals(TEXT)) {
            mode = APPOINTMENT_APPT_UNID_TEXT_MODE;
        }
    }

    public void fatalError(SAXParseException e) throws SAXParseException {
        System.err.println("Error has occured.");
        System.err.println("\tmode: " + mode);
        System.err.println("\tbuffer: " + buffer.toString());
        System.err.println("\n");
        throw e;
    }

    /*some methods for data conversion*/
    private Date getDateRepresentation(String notesDate) {
        if ((notesDate == null) || notesDate.equals("")) {
            return null;
        }

        try {
            int year = Integer.parseInt(notesDate.substring(0, 4));
            int month = Integer.parseInt(notesDate.substring(4, 6)) - 1;
            int day = Integer.parseInt(notesDate.substring(6, 8));

            //leave out "T" for "Time"
            int hours = Integer.parseInt(notesDate.substring(9, 11));
            int mins = Integer.parseInt(notesDate.substring(11, 13));

            String timeZoneSign = notesDate.substring(18, 19);
            int timeZoneOffset = Integer.parseInt(notesDate.substring(19, 21));

            if (timeZoneSign.equals("-")) {
                timeZoneOffset *= (-1);
            }

            //make this a precisive moment in time, independent of timezone
            java.util.Calendar c = java.util.Calendar.getInstance(new SimpleTimeZone(
                        timeZoneOffset, "Notes TimeZone"));
            c.set(java.util.Calendar.YEAR, year);
            c.set(java.util.Calendar.MONTH, month);
            c.set(java.util.Calendar.DAY_OF_MONTH, day);
            c.set(java.util.Calendar.HOUR_OF_DAY, hours);
            c.set(java.util.Calendar.MINUTE, mins);
            c.set(java.util.Calendar.SECOND, 0);
            c.set(java.util.Calendar.MILLISECOND, 0);

            return c.getTime(); //give it back
        } catch (Exception e) {
            throw new DateImparsableException("Couldn't parse the given date.");
        }
    }

    public de.upb.ois.nt2.data.Calendar getCalendar() {
        return calendar;
    }

    public Object[] getResults() {
        return new Object[] { getCalendar() };
    }
}
