/*
 * ContentHandlerChain.java
 *
 * Created on 15. September 2003, 13:10
 */
package de.upb.ois.nt2.server.contenthandler;

import org.xml.sax.*;

import java.io.*;

import java.util.*;


/**
 *
 * @author  $Author: lindhrst $
 * @version $Id: ContentHandlerChain.java,v 1.1.1.1 2003/09/25 10:25:05 lindhrst Exp $
 */
public class ContentHandlerChain extends AbstractDefaultHandler {
    private HashMap map = new HashMap();

    /**
     *Adds a DefaultHandler to this chain, such that any method called upon
     *the current instance of this class can be forwarded to the named instance
     *added to this chain.<br>
     *<b>Note:</b> handlers added to the chain will be mappped  to the given
     *class; thus, it is possible to add the same single instance to the chain
     *multiple times by using different classes for mapping. However, it is
     *guaranteed that for any one given class there is only one reference to
     *a given object.
     *@param c the class of the handler
     *@param handler the handler to be added to the chain
     *@see #removeDefaultHandler(Class,AbstractDefaultHandler)
     */
    public void addDefaultHandler(Class c, AbstractDefaultHandler handler) {
        Set set = (Set) map.get(c);

        if (set == null) {
            set = new HashSet();
            map.put(c, set);
        }

        set.add(handler);
    }

    /**
     *Removes the given instance from the notification queue denominated by the
     *given class.
     *@param c the class mapping
     *@param handler the AbstractDefaultHandler instance
     *@see #addDefaultHandler(Class,AbstractDefaultHandler)
     */
    public void removeDefaultHandler(Class c, AbstractDefaultHandler handler) {
        Set set = (Set) map.get(c);

        if (set == null) {
            return;
        }

        set.remove(handler);
    }

    public void startElement(String uri, String localName, String qName,
        Attributes attributes) throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).startElement(uri,
                    localName, qName, attributes);
            }
        }
    }

    public void endElement(String uri, String localName, String qName)
        throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).endElement(uri,
                    localName, qName);
            }
        }
    }

    public void characters(char[] ch, int start, int length)
        throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).characters(ch,
                    start, length);
            }
        }
    }

    public void endDocument() throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).endDocument();
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).endPrefixMapping(prefix);
            }
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).error(exception);
            }
        }
    }

    public void fatalError(SAXParseException exception)
        throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).fatalError(exception);
            }
        }
    }

    public void ignorableWhiteSpace(char[] ch, int start, int length)
        throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).ignorableWhitespace(ch,
                    start, length);
            }
        }
    }

    public Object[] getResults() {
        return null;
    }

    public InputSource resolveEntity(String publicId, String systemId)
        throws SAXException {
        if (true) { //ugly, but won't compile otherwise
            throw new SAXException(new IllegalAccessException(
                    "Not supported, please direct this method call to single AbstractDefaultHanlder instances within this chain."));
        }

        return null;
    }

    public void processingInstruction(String target, String data)
        throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).processingInstruction(target,
                    data);
            }
        }
    }

    public void skippedEntity(String name) throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).skippedEntity(name);
            }
        }
    }

    public void startDocument() throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).startDocument();
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri)
        throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).startPrefixMapping(prefix,
                    uri);
            }
        }
    }

    public void notationDecl(String name, String publicId, String systemId)
        throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).notationDecl(name,
                    publicId, systemId);
            }
        }
    }

    public void unparsedEntityDecl(String name, String publicId,
        String systemId, String notationName) throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).unparsedEntityDecl(name,
                    publicId, systemId, notationName);
            }
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        Iterator classQueueIterator = map.keySet().iterator();
        Iterator classQueue = null;

        while (classQueueIterator.hasNext()) {
            classQueue = (Iterator) ((Set) map.get(classQueueIterator.next())).iterator();

            while (classQueue.hasNext()) {
                ((AbstractDefaultHandler) classQueue.next()).warning(exception);
            }
        }
    }
}
