/*
 * NamesNSFHandler.java
 *
 * Created on 24. Juli 2003, 04:28
 */
package de.upb.ois.nt2.server.contenthandler;

import org.xml.sax.*;


/**
 *
 * @author  $Author: lindhrst $
 * @version $Id: NamesNSFHandler.java,v 1.1.1.1 2003/09/25 10:25:05 lindhrst Exp $
 */
public class NamesNSFHandler extends AbstractDefaultHandler {
    private static final int IRRELEVANT_MODE = 0;
    private static final int PERSON_TEXT_MODE = 3;
    private static final int PERSON_MODE = 5;
    private static final int MAILSERVER_MODE = 6;
    private static final int MAILSERVER_TEXT_MODE = 7;
    private static final int MAILFILE_MODE = 8;
    private static final int MAILFILE_TEXT_MODE = 9;
    private static final int MAILADDRESS_MODE = 20;
    private static final int MAILADDRESS_TEXT_MODE = 21;
    private static final int NAME_MODE = 10;
    private static final int NAME_TEXT_MODE = 11;
    private static final String DOCUMENT = "document";
    private static final String ITEM = "item";
    private static final String TEXT = "text";
    private static final String EMPTY = "";
    private static final String FORM = "form";
    private static final String SUBJECT = "Subject";
    private static final String GROUP_CALENDAR = "(GroupCalendar)";
    private static final String PERSON = "Person";
    private static final String MAILSERVER = "MailServer";
    private static final String MAILFILE = "MailFile";
    private static final String MAILADDRESS = "InternetAddress";
    private static final String FULLNAME = "FullName";
    private static final String NAME = "name";
    private int mode = IRRELEVANT_MODE;
    private String mailboxOwner = null;
    private String mailFile = null;
    private String mailServer = null;
    private String mailAddress = null;
    private boolean found = false;
    private String fullName = null;
    private int counter = 0;
    private StringBuffer buffer = null;

    public NamesNSFHandler(String mailboxOwner) {
        this.mailboxOwner = mailboxOwner;
        mailFile = "";
        mailServer = "";
        mode = IRRELEVANT_MODE;
        fullName = "";
        found = false;
    }

    //FIXME: for debugging only
    public NamesNSFHandler() {
        this("Alexander Lindhorst");
    }

    /**
     *Method to inspect actual data and transform it into bits of needed information.
     *Depending on the state in which the current instance is (this will be
     *determined by {@link #startElement(String, String, String, Attributes)}),
     *this method will internally store information found in the part of the XML stream
     *stored in <code>chars</code> and defined by <code>start</code> and
     *<code>length</code> and make those infoormational pieces available.
     */
    public void characters(char[] chars, int start, int length)
        throws SAXException {
        if (mode == IRRELEVANT_MODE) {
            return; //speed it up
        }

        //Store current XML bit
        buffer.append(chars, start, length);
    }

    public void endElement(String uri, String localName, String qName)
        throws SAXException {
        if (mode == IRRELEVANT_MODE) {
            return;
        }

        //switch mode back
        if (!found) {
            switch (mode) {
            case NAME_TEXT_MODE:
                fullName = buffer.toString();
                mode = NAME_MODE;

                break;

            case NAME_MODE:
                mode = PERSON_MODE;

                break;

            case MAILSERVER_TEXT_MODE:
                mailServer = buffer.toString();
                mode = MAILSERVER_MODE;

                break;

            case MAILSERVER_MODE:
                mode = PERSON_MODE;

                break;

            case MAILFILE_TEXT_MODE:
                mailFile = buffer.toString();
                mode = MAILFILE_MODE;

                break;

            case MAILFILE_MODE:
                mode = PERSON_MODE;

                break;

            case MAILADDRESS_TEXT_MODE:
                mailAddress = buffer.toString();
                mode = MAILADDRESS_MODE;

                break;

            case MAILADDRESS_MODE:
                mode = PERSON_MODE;

                break;

            case PERSON_MODE:

                //only act when we're really through with all subelements
                if (qName.equals(DOCUMENT) || localName.equals(DOCUMENT)) {
                    found = found ||
                        getNameRepresentation(fullName).equals(mailboxOwner);

                    /*//still not found? Then reset everything
                    if (!found) {
                        mailServer = "";
                        mailFile = "";
                        mailAddress = "";
                        fullName = "";
                    }*/
                    mode = IRRELEVANT_MODE;
                }

                break;
            }
        }
    }

    public void startElement(String uri, String localName, String qName,
        Attributes atts) throws SAXException {
        if (found) {
            return;
        }

        buffer = new StringBuffer(128);

        String attValue = null;

        if ((mode == IRRELEVANT_MODE) && qName.equals(DOCUMENT)) {
            if (found) { //we are done, but don't disable item eval

                return;
            }

            if (((attValue = atts.getValue(FORM)) != null) ||
                    ((attValue = atts.getValue(EMPTY, FORM)) != null)) {
                if (attValue.equals(PERSON)) {
                    mode = PERSON_MODE;
                }
            }
        }

        if ((mode == PERSON_MODE) && qName.equals(ITEM)) {
            if (((attValue = atts.getValue(NAME)) != null) ||
                    ((attValue = atts.getValue(EMPTY, NAME)) != null)) {
                if (attValue.equals(MAILSERVER)) {
                    mode = MAILSERVER_MODE;
                } else if (attValue.equals(MAILFILE)) {
                    mode = MAILFILE_MODE;
                } else if (attValue.equals(FULLNAME)) {
                    mode = NAME_MODE;
                } else if (attValue.equals(MAILADDRESS)) {
                    mode = MAILADDRESS_MODE;
                }
            }
        }

        if ((mode == MAILSERVER_MODE) && qName.equals(TEXT)) {
            mode = MAILSERVER_TEXT_MODE;
        }

        if ((mode == MAILFILE_MODE) && qName.equals(TEXT)) {
            mode = MAILFILE_TEXT_MODE;
        }

        if ((mode == MAILADDRESS_MODE) && qName.equals(TEXT)) {
            mode = MAILADDRESS_TEXT_MODE;
        }

        if ((mode == NAME_MODE) && qName.equals(TEXT)) {
            mode = NAME_TEXT_MODE;
        }
    }

    public String getMailServer() {
        return mailServer;
    }

    public String getMailFile() {
        return mailFile;
    }

    public String getFullName() {
        return fullName;
    }

    public String getMailAddress() {
        return mailAddress;
    }

    public Object[] getResults() {
        return new Object[] {
            getFullName(), getMailAddress(), getMailFile(), getMailServer()
        };
    }
}
