/*
 * EnvSettings.java
 *
 * Created on 25. September 2003, 12:49
 */

package de.upb.ois.nt2.server.gui;
import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.*;
/**
 *Provides a dialog for the setting of environmental settings needed by the RMI
 *server component.
 *@verion $Id: EnvSettings.java,v 1.1 2003/09/25 11:47:12 lindhrst Exp $
 *@author $Author: lindhrst $
 */
public class EnvSettings extends javax.swing.JDialog {
    
    /** Creates new form EnvSettings */
    public EnvSettings() {
        setModal(true);
        initComponents();
        pack();
        setLocationRelativeTo(null);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        header = new javax.swing.JLabel();
        settings = new javax.swing.JPanel();
        baseLabel = new javax.swing.JLabel();
        baseField = new javax.swing.JTextField();
        baseButton = new javax.swing.JButton();
        nameLabel = new javax.swing.JLabel();
        nameField = new javax.swing.JTextField();
        policyLabel = new javax.swing.JLabel();
        policyField = new javax.swing.JTextField();
        policyButton = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        exit = new javax.swing.JButton();

        setTitle("Settings for Runtime Environment");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        header.setFont(new java.awt.Font("SansSerif", 1, 18));
        header.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        header.setText("Environmental Settings");
        getContentPane().add(header, java.awt.BorderLayout.NORTH);

        settings.setLayout(new java.awt.GridBagLayout());

        settings.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED), new javax.swing.border.EmptyBorder(new java.awt.Insets(5, 5, 5, 5))));
        baseLabel.setText("Codebase (java.rmi.server.codebase):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        settings.add(baseLabel, gridBagConstraints);

        baseField.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        settings.add(baseField, gridBagConstraints);

        baseButton.setText("Select");
        baseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                baseButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        settings.add(baseButton, gridBagConstraints);

        nameLabel.setText("Server Name (java.rmi.server):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        settings.add(nameLabel, gridBagConstraints);

        nameField.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        settings.add(nameField, gridBagConstraints);

        policyLabel.setText("Custom policy file, if any (java.security.policy):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        settings.add(policyLabel, gridBagConstraints);

        policyField.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        settings.add(policyField, gridBagConstraints);

        policyButton.setText("Select");
        policyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                policyButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        settings.add(policyButton, gridBagConstraints);

        getContentPane().add(settings, java.awt.BorderLayout.CENTER);

        exit.setText("Ok");
        exit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitActionPerformed(evt);
            }
        });

        jPanel2.add(exit);

        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents

    private void exitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitActionPerformed
        setVisible(false);
    }//GEN-LAST:event_exitActionPerformed

    private void policyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_policyButtonActionPerformed
        File dir=new File(System.getProperty("user.dir"));
        if (policyField.getText()!=null && !policyField.getText().equals("")) {
            dir=new File(policyField.getText()).getParentFile();
        }
        JFileChooser chooser=new JFileChooser(dir);
        chooser.setFileFilter(new javax.swing.filechooser.FileFilter() {
            public String getDescription() {
                return "Java Policy Files";
            }
            public boolean accept(File f) {
                return f.isDirectory()||f.getPath().endsWith(".policy");
            }
        });
        chooser.setAcceptAllFileFilterUsed(false);
        int value=chooser.showOpenDialog(this);
        if (value==JFileChooser.APPROVE_OPTION) {
            policyField.setText("file://"+chooser.getSelectedFile().getAbsolutePath());
        }
    }//GEN-LAST:event_policyButtonActionPerformed

    private void baseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_baseButtonActionPerformed
        File dir=new File(System.getProperty("user.dir"));
        String name=baseField.getText();
        if (name!=null && !name.equals("")) {
            dir=new File(name);
        }
        JFileChooser chooser=new JFileChooser(dir);
        chooser.setFileFilter(new javax.swing.filechooser.FileFilter() {
            public String getDescription() {
                return "Java Archives and Directories";
            }
            public boolean accept(File f) {
                return f.isDirectory()||f.getPath().endsWith(".jar");
            }
        });
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        chooser.setApproveButtonText("Select");
        chooser.setApproveButtonMnemonic('S');
        
        int value=chooser.showOpenDialog(this);
        if (value==JFileChooser.APPROVE_OPTION) {
            dir=chooser.getSelectedFile();
            if (dir.isDirectory()) {
                baseField.setText("file://"+dir.getAbsolutePath()+File.separator);
            } else {
                baseField.setText("file://"+dir.getAbsolutePath());
            }
        }

    }//GEN-LAST:event_baseButtonActionPerformed
    
    //########### Getter and Setter ################
    public void setCodebase(String base) {
        baseField.setText(base);
    }
    
    public String getCodebase() {
        return baseField.getText();
    }
    
    public void setName(String name) {
        nameField.setText(name);
    }
    
    public String getName() {
        return  nameField.getText();
    }
    
    public void setPolicy(String policyFile) {
        policyField.setText(policyFile);
    }
    
    public String getPolicy() {
        return policyField.getText();
    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        //System.exit(0);
        setVisible(false);
    }//GEN-LAST:event_exitForm
          
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton policyButton;
    private javax.swing.JTextField policyField;
    private javax.swing.JTextField nameField;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextField baseField;
    private javax.swing.JPanel settings;
    private javax.swing.JButton exit;
    private javax.swing.JLabel header;
    private javax.swing.JButton baseButton;
    private javax.swing.JLabel baseLabel;
    private javax.swing.JLabel policyLabel;
    // End of variables declaration//GEN-END:variables
    
}
