/*
 * MailNotifier.java
 *
 * Created on 30. September 2003, 20:41
 */

package de.upb.ois.nt2.server.helper;

import de.upb.ois.nt2.data.Appointment;
import de.upb.ois.nt2.data.Person;
import java.util.*;
import java.text.*;

/**
 *
 * @author  lindhrst
 */
public class DataProcessor {
    private Appointment appointment=null;
    private Person person=null;
    private static final String PROLOG="<?xml version='1.0'?>";
    private static final String DATABASE="<database>";
    private static final String DATABASE_CLOSING="</database>";
    private static final String DOCUMENT="<document form='Appointment'>";
    private static final String TEXT_CLOSING="</text>";
    private static final String DATETIME_CLOSING="</datetime>";
    private static final String ITEM_CLOSING="</item>";
    private static final String DOCUMENT_CLOSING="</document>";
    private static final String LOCATION="<item name='Location'><text>";
    private static final String OWNER="<item name='Principal'><text>";
    private static final String PRIVACY="<item name='$PublicAccess'><text>";
    private static final String STARTDATE="<item name='STARTDATETIME'><datetime>";
    private static final String SUBJECT="<item name='Subject'><text>";
    private static final String ENDDATE="<item name='EndDateTime'><datetime>";
    private static final String UNIQUE_ID="<item name='ApptUNID'><text>";
    private static final String DEBUG_WARNING="Diese Nachricht wurde im Debug-Modus erstellt. ";
    public static final String PLEASE_VALIDATE="Bitte setzen Sie sich mit dem Ersteller des Termins in Verbindung, um die Gültigkeit zu prüfen.";
    public static final String CHECK=" Bitte überprüfen Sie, ob die Daten bereits in Ihren Kalender übernommen wurden.";
    
    /** Creates a new instance of MailNotifier */
    public DataProcessor(Person person, Appointment appointment) {
        this.person=person;
        this.appointment=appointment;
        if (person==null||appointment==null) {
            throw new NullPointerException();
        }
    }
    
    public String getDXL() {
        StringBuffer buffer=new StringBuffer(1024);
        buffer.append(PROLOG);
        buffer.append(DATABASE);
        buffer.append(DOCUMENT);
        
        //subject
        buffer.append(SUBJECT);
        buffer.append(appointment.getSubject());
        buffer.append(TEXT_CLOSING);
        buffer.append(ITEM_CLOSING);
        
        //location
        buffer.append(LOCATION);
        buffer.append(appointment.getLocation());
        buffer.append(TEXT_CLOSING);
        buffer.append(ITEM_CLOSING);
        
        //owner
        buffer.append(OWNER);
        buffer.append(appointment.getOwner());
        buffer.append(TEXT_CLOSING);
        buffer.append(ITEM_CLOSING);
        
        //privacy
        buffer.append(PRIVACY);
        buffer.append(appointment.getPrivacy());
        buffer.append(TEXT_CLOSING);
        buffer.append(ITEM_CLOSING);
        
        
        //unique id
        buffer.append(UNIQUE_ID);
        buffer.append(appointment.getUniqueID());
        buffer.append(TEXT_CLOSING);
        buffer.append(ITEM_CLOSING);
        
        //start date
        buffer.append(STARTDATE);
        buffer.append(getDateTime(appointment.getStartDate()));
        buffer.append(DATETIME_CLOSING);
        buffer.append(ITEM_CLOSING);
        
        //end date
        buffer.append(ENDDATE);
        buffer.append(getDateTime(appointment.getEndDate()));
        buffer.append(DATETIME_CLOSING);
        buffer.append(ITEM_CLOSING);
        
        buffer.append(DOCUMENT_CLOSING);
        buffer.append(DATABASE_CLOSING);
        
        return buffer.toString();
    }
    
    private static String getDateTime(Date date) {
        Calendar c=Calendar.getInstance();
        c.setTime(date);
        StringBuffer buffer=new StringBuffer(40);
        buffer.append(c.get(Calendar.YEAR));
        buffer.append(c.get(Calendar.MONTH));
        buffer.append(c.get(Calendar.DAY_OF_MONTH));
        buffer.append('T');
        buffer.append(c.get(Calendar.HOUR_OF_DAY));
        buffer.append(c.get(Calendar.MINUTE));
        buffer.append("00, 00+01"); //Europe/Berlin
        return buffer.toString();
    }
    
    public String getMailText(boolean debug) {
        DateFormat format=DateFormat.getDateTimeInstance(DateFormat.MEDIUM,DateFormat.MEDIUM);
        StringBuffer buffer=new StringBuffer(512);
        buffer.append("Der folgende Termin wurde vom Notes Gruppenkalender-Client generiert:\n");
        buffer.append("\nTitel: ");
        buffer.append(appointment.getSubject());
        buffer.append("\nBesitzer: ");
        buffer.append(appointment.getOwner());
        buffer.append("\nOrt: ");
        buffer.append(appointment.getLocation());
        buffer.append("\nStartzeit: ");
        buffer.append(format.format(appointment.getStartDate()));
        buffer.append("\nEndzeit: ");
        buffer.append(format.format(appointment.getEndDate()));
        if (debug) {
            buffer.append(DEBUG_WARNING);
        }
        return buffer.toString();
    }
}
