/*
 * PropertyCheck.java
 *
 * Created on 25. September 2003, 15:00
 */
package de.upb.ois.nt2.server.helper;

import de.upb.ois.nt2.server.gui.*;

import java.io.*;

import java.util.*;


/**
 * Checks system properties for needed values and - if necessary - retrieves them
 * from file and from user interaction.
 *
 * @author  $Author: lindhrst $
 * @version $Id: PropertyCheck.java,v 1.1 2003/09/25 13:48:58 lindhrst Exp $
 */
public class PropertyCheck {
    private static final String POLICY = "java.security.policy";
    private static final String CODEBASE = "java.rmi.server.codebase";
    private static final String SERVER = "java.rmi.server";
    private static final String EMPTY = "";

    /** Runs necessary checks
     * @param interactively <CODE>true</CODE> if the user should be asked to
     *   provide values, <CODE>false</CODE> otherwise
     * @return properties with the necessary values merged in
     */
    public Properties runCheck(boolean interactively) {
        Properties sysProps = System.getProperties();
        Properties stored = loadStoredValues();
        Properties merged = mergeProperties(sysProps, stored);

        if (interactively) {
            EnvSettings settings = new EnvSettings();
            settings.setCodebase(merged.getProperty(CODEBASE));
            settings.setName(merged.getProperty(SERVER));
            settings.setPolicy(merged.getProperty(POLICY));

            //get new values
            settings.show();

            //retrieve changes
            merged.put(CODEBASE, settings.getCodebase());
            merged.put(SERVER, settings.getName());
            merged.put(POLICY, settings.getPolicy());
        }

        //make'em persistent
        storeProperties(merged);

        return merged; //make results available
    }

    private static Properties loadStoredValues() {
        Properties props = new Properties();
        File f = new File(".rmiserver.properties");

        if (f.exists()) {
            InputStream in = null;

            try {
                in = new FileInputStream(f);
                props.load(in);
            } catch (Exception e) {
                e.printStackTrace(System.err);
            } finally {
                try {
                    in.close();
                } catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }

        return props;
    }

    private static void storeProperties(Properties props) {
        //we only want to save "relevant" values, disect the whole thing first
        Properties temp = new Properties();
        temp.put(CODEBASE, props.getProperty(CODEBASE));
        temp.put(SERVER, props.getProperty(SERVER));
        temp.put(POLICY, props.getProperty(POLICY));

        File f = new File(".rmiserver.properties");
        FileOutputStream out = null;

        try {
            out = new FileOutputStream(f);
            temp.store(out,
                "Lotus Notes Group Calendar RMI Server Settings - DO NOT MODIFY");
        } catch (Exception e) {
            e.printStackTrace(System.err);
        } finally {
            try {
                out.close();
            } catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private Properties mergeProperties(Properties systemProperties,
        Properties storedProperties) {
        systemProperties = (Properties) systemProperties.clone(); //work on copies

        String policy = storedProperties.getProperty(POLICY);

        if (policy == null) {
            policy = EMPTY;
        }

        String codebase = storedProperties.getProperty(CODEBASE);

        if (codebase == null) {
            codebase = EMPTY;
        }

        String server = storedProperties.getProperty(SERVER);

        if (server == null) {
            server = EMPTY;
        }

        if (!systemProperties.containsKey(POLICY)) {
            systemProperties.put(POLICY, policy);
        }

        if (!systemProperties.containsKey(SERVER)) {
            systemProperties.put(SERVER, server);
        }

        if (!systemProperties.containsKey(CODEBASE)) {
            systemProperties.put(CODEBASE, codebase);
        }

        return systemProperties;
    }
}
