/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import lindhorst.apps.jdbc.swing.LogInDialog;
import lindhorst.apps.jdbc.swing.administration.ModuleAdministration;
import lindhorst.apps.jdbc.swing.data.SessionDataModel;
import lindhorst.apps.jdbc.swing.event.LoginEvent;
import lindhorst.apps.jdbc.swing.event.LoginListener;
import lindhorst.apps.jdbc.swing.event.ModuleRequestEvent;
import lindhorst.apps.jdbc.swing.event.ModuleRequestListener;
import lindhorst.apps.jdbc.swing.helpers.Helpers;
import lindhorst.apps.jdbc.swing.info.LoggingStatusDialog;
import lindhorst.apps.jdbc.swing.modules.Queries;
import lindhorst.apps.jdbc.swing.modules.QueryMaker;
import lindhorst.apps.jdbc.swing.modules.Table;
import lindhorst.apps.jdbc.swing.modules.datamodels.QueriesDataModel;
import lindhorst.apps.jdbc.swing.modules.datamodels.TableDataModel;

public class AppPane
extends JDesktopPane
implements ModuleRequestListener {
    public static final Integer APPLICATION_LAYER = new Integer(500);
    public static final Integer DIALOG_LAYER = new Integer(1000);
    public static final Integer ADMINISTRATION_LAYER = new Integer(250);
    private Component focusedComponent = null;
    private SessionDataModel model = null;
    private Dimension prefSize = null;

    public AppPane() {
        this.putClientProperty("JDesktopPane.dragMode", "outline");
    }

    public void createSession() {
        this.createSession(null);
    }

    public void createSession(Properties props) {
        this.closeAll();
        LogInDialog dialog = null;
        try {
            if (this.model != null) {
                this.model.close();
                this.model.removeModuleRequestListener(this);
            }
            LoginStatusWatch watch = new LoginStatusWatch();
            dialog = new LogInDialog(Helpers.getTopLevelContainer());
            if (props != null) {
                dialog.setProperties(props);
            }
            dialog.setVisible(true);
            if (!dialog.isProperlyClosed()) {
                throw new NullPointerException(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("action_aborted.no_properties"));
            }
            dialog.setVisible(false);
            props = dialog.getProperties();
            this.model = new SessionDataModel(props, watch);
            this.model.addModuleRequestListener(this);
            ModuleAdministration admin = this.model.getAdministrationPanel();
            Dimension adminPSize = admin.getPreferredSize();
            Dimension size = this.getSize();
            admin.setBounds((size.width - adminPSize.width) / 2, (size.height - adminPSize.height) / 2, adminPSize.width, adminPSize.height);
            this.add((Component)admin, ADMINISTRATION_LAYER);
            admin.setVisible(true);
            admin.setSelected(true);
            Helpers.toFront();
        }
        catch (NullPointerException ne) {
            ne.printStackTrace(System.err);
            if (dialog.isProperlyClosed()) {
                Helpers.showError(ne);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Helpers.showError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSession() {
        try {
            try {
                this.closeAll();
            }
            catch (Exception e) {
                Helpers.showError(e);
                Object var3_2 = null;
                this.removeAll();
                this.focusedComponent = null;
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.removeAll();
            this.focusedComponent = null;
            throw throwable;
        }
        this.removeAll();
        this.focusedComponent = null;
    }

    public void closeAll() {
        JInternalFrame[] frames = this.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            frames[i].dispose();
            ++i;
        }
        try {
            if (this.model != null) {
                this.model.close();
                this.model = null;
            }
        }
        catch (Exception e) {
            Helpers.showError(e);
        }
        this.repaint();
        System.gc();
    }

    public SessionDataModel getModel() {
        return this.model;
    }

    public boolean isOpaque() {
        return true;
    }

    public void moduleRequested(ModuleRequestEvent event) {
        String type = event.getModuleType();
        String name = event.getModuleName();
        if (event.getModuleType().equals("queries")) {
            if (name.equals("<Neu>")) {
                try {
                    QueryMaker queries = new QueryMaker(this.model.getReadableConnection(), this.model.getWritableConnection());
                    Dimension size = this.getSize();
                    queries.setBounds(0, 0, size.width, size.height);
                    this.add((Component)queries, APPLICATION_LAYER);
                    queries.setSelected(true);
                }
                catch (Exception e) {
                    Helpers.showError(e);
                }
                return;
            }
            try {
                QueriesDataModel qModel = new QueriesDataModel(this.model.getReadableConnection(), this.model.getWritableConnection());
                qModel.executeSQL(this.model.getProperties().getProperty("jdbcsession.queries." + name + ".command"));
                Queries queries = new Queries(qModel, name);
                Dimension size = this.getSize();
                queries.setBounds(0, 0, size.width, size.height);
                this.add((Component)queries, APPLICATION_LAYER);
                queries.setSelected(true);
            }
            catch (Exception e) {
                Helpers.showError(e);
            }
        } else {
            if (name.equals("<Neu>")) {
                try {
                    name = JOptionPane.showInputDialog(this, ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("enter_table_name"), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("table_name"), 3);
                    if (name == null || name.equals("")) {
                        return;
                    }
                }
                catch (Exception e) {
                    Helpers.showError(e);
                }
            }
            try {
                TableDataModel tModel = new TableDataModel(this.model.getReadableConnection(), this.model.getWritableConnection(), name);
                Table table = new Table(tModel);
                Dimension size = this.getSize();
                table.setBounds(0, 0, size.width, size.height);
                this.add((Component)table, APPLICATION_LAYER);
                table.setSelected(true);
            }
            catch (Exception e) {
                Helpers.showError(e);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            int w = screen.width * 7 / 8;
            int h = screen.height * 3 / 4;
            this.prefSize = new Dimension(w, h);
        }
        return this.prefSize;
    }

    private AppPane getSelfReference() {
        return this;
    }

    private class LoginStatusWatch
    implements LoginListener,
    Runnable {
        private LoggingStatusDialog dialog = new LoggingStatusDialog();

        LoginStatusWatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loginStatusChanged(LoginEvent event) {
            this.dialog.setDialogType(event.getType());
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                Thread.yield();
            } else {
                switch (this.dialog.getDialogType()) {
                    case 0: 
                    case 1: {
                        AppPane.this.setCursor(Cursor.getPredefinedCursor(3));
                        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
                        this.dialog.reactToEvent();
                        break;
                    }
                    default: {
                        AppPane.this.setCursor(Cursor.getPredefinedCursor(0));
                        this.dialog.setCursor(Cursor.getPredefinedCursor(0));
                        this.dialog.reactToEvent();
                        LoggingStatusDialog loggingStatusDialog = this.dialog;
                        synchronized (loggingStatusDialog) {
                            this.dialog.dispose();
                            this.dialog = new LoggingStatusDialog();
                            this.dialog.pack();
                            break;
                        }
                    }
                }
                SQLException e = AppPane.this.model.getRaisedException();
                if (AppPane.this.model != null && e != null) {
                    Helpers.showError(e);
                    AppPane.this.closeAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            switch (this.dialog.getDialogType()) {
                case 0: 
                case 1: {
                    AppPane.this.setCursor(Cursor.getPredefinedCursor(3));
                    this.dialog.setCursor(Cursor.getPredefinedCursor(3));
                    this.dialog.reactToEvent();
                    break;
                }
                default: {
                    AppPane.this.setCursor(Cursor.getPredefinedCursor(0));
                    this.dialog.setCursor(Cursor.getPredefinedCursor(0));
                    this.dialog.reactToEvent();
                    LoggingStatusDialog loggingStatusDialog = this.dialog;
                    synchronized (loggingStatusDialog) {
                        this.dialog.dispose();
                        this.dialog = new LoggingStatusDialog();
                        this.dialog.pack();
                        break;
                    }
                }
            }
            if (AppPane.this.model != null && AppPane.this.model.getRaisedException() != null) {
                Helpers.showError(AppPane.this.model.getRaisedException());
                AppPane.this.closeAll();
            }
        }
    }

    private class FocusWatch
    extends FocusAdapter {
        private FocusWatch() {
        }

        public void focusGained(FocusEvent event) {
            AppPane.this.focusedComponent = (Component)event.getSource();
        }
    }
}

