/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import lindhorst.apps.jdbc.swing.AppPane;
import lindhorst.apps.jdbc.swing.AppToolBar;
import lindhorst.apps.jdbc.swing.action.CloseSessionAction;
import lindhorst.apps.jdbc.swing.action.NewAction;
import lindhorst.apps.jdbc.swing.action.OpenSessionAction;
import lindhorst.apps.jdbc.swing.action.SaveSessionAction;
import lindhorst.apps.jdbc.swing.helpers.Helpers;
import lindhorst.apps.jdbc.swing.info.InfoDialog;
import lindhorst.swing.menu.PLaFMenu;

public class JavaSQL
extends JFrame {
    private AppPane desktop = new AppPane();

    public JavaSQL() {
        super(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("JavaSQL"));
        this.setSize(600, 450);
        this.setIconImage(Helpers.getImage(this.getClass(), "jsql.gif"));
        Helpers.setTopLevelContainer(this);
        this.addWindowListener(new Exiter());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createAppToolBar(), "North");
        panel.add((Component)this.desktop, "Center");
        this.setJMenuBar(this.createAppMenuBar());
        this.setContentPane(panel);
        this.pack();
        Helpers.doCenterWindow(this);
        this.setVisible(true);
    }

    private JToolBar createAppToolBar() {
        AppToolBar bar = new AppToolBar(0);
        bar.add(new NewAction(this.desktop));
        bar.add(new OpenSessionAction(this.desktop));
        bar.add(new SaveSessionAction(this.desktop));
        bar.add(new CloseSessionAction(this.desktop));
        return bar;
    }

    private JMenuBar createAppMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("session"));
        menu.setMnemonic('S');
        menu.add(new NewAction(this.desktop));
        menu.add(new JSeparator(0));
        menu.add(new OpenSessionAction(this.desktop));
        menu.add(new SaveSessionAction(this.desktop));
        menu.add(new JSeparator(0));
        menu.add(new CloseSessionAction(this.desktop));
        menu.add(new JSeparator(0));
        JMenuItem item = new JMenuItem(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("end"));
        item.setMnemonic('B');
        item.addActionListener(new Exiter());
        menu.add(item);
        bar.add(menu);
        menu = new JMenu(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("view"));
        menu.setMnemonic('A');
        menu.add(new PLaFMenu(this));
        bar.add(menu);
        menu = new JMenu(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("help"));
        menu.setMnemonic('?');
        item = new JMenuItem(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("info"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InfoDialog dialog = new InfoDialog();
                dialog.pack();
                Dimension dtDims = JavaSQL.this.desktop.getSize();
                Dimension dgDims = dialog.getPreferredSize();
                dialog.setBounds((dtDims.width - dgDims.width) / 2, (dtDims.height - dgDims.height) / 2, dgDims.width, dgDims.height);
                JavaSQL.this.desktop.add((Component)dialog, AppPane.DIALOG_LAYER);
                dialog.setVisible(true);
                dialog.moveToFront();
                try {
                    dialog.setSelected(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        });
        menu.add(item);
        bar.add(menu);
        return bar;
    }

    public static void main(String[] args) throws Exception {
        System.getProperties().put("sun.java2d.noddraw", "");
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        new JavaSQL();
    }

    private class Exiter
    extends WindowAdapter
    implements ActionListener {
        private Exiter() {
        }

        public void windowClosing(WindowEvent event) {
            JavaSQL.this.setVisible(false);
            JavaSQL.this.desktop.closeAll();
            JavaSQL.this.dispose();
            System.exit(0);
        }

        public void actionPerformed(ActionEvent event) {
            JavaSQL.this.setVisible(false);
            JavaSQL.this.desktop.closeAll();
            JavaSQL.this.dispose();
            System.exit(0);
        }
    }
}

