/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import lindhorst.apps.jdbc.swing.PathExtensionDialog;
import lindhorst.apps.jdbc.swing.helpers.Helpers;
import lindhorst.apps.jdbc.swing.sql.UniversalDriverWrapper;

public class LogInDialog
extends JDialog
implements ActionListener {
    private JTextField url;
    private JTextField user;
    private JTextField password;
    private JComboBox driver;
    private JTextField classPathExt;
    private Properties props = null;
    private boolean properlyClosed = false;

    public LogInDialog(Frame parent, boolean modal) {
        super(parent == null ? Helpers.getTopLevelContainer() : parent, ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("login"), modal);
        this.init();
    }

    public LogInDialog(Frame parent) {
        this(parent, true);
    }

    public LogInDialog() {
        this((Frame)null, true);
    }

    private void init() {
        JPanel entries = new JPanel(new GridLayout(6, 2, 10, 10));
        JLabel lab = new JLabel("JDBC-URL:", 2);
        this.url = new JTextField();
        entries.add(lab);
        entries.add(this.url);
        lab = new JLabel(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("user"), 2);
        this.user = new JTextField();
        entries.add(lab);
        entries.add(this.user);
        lab = new JLabel(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("password"), 2);
        this.password = new JPasswordField();
        entries.add(lab);
        entries.add(this.password);
        lab = new JLabel(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("cp_extension"), 2);
        this.classPathExt = new JTextField();
        this.classPathExt.setColumns(20);
        entries.add(lab);
        GridBagLayout lm = new GridBagLayout();
        JPanel classPathPane = new JPanel(lm);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 5.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        lm.setConstraints(this.classPathExt, gbc);
        classPathPane.add(this.classPathExt);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        JButton pathSelector = new JButton("...");
        pathSelector.setActionCommand("choosepath");
        lm.setConstraints(pathSelector, gbc);
        classPathPane.add(pathSelector);
        entries.add(classPathPane);
        String value = null;
        if (this.props != null) {
            value = this.props.getProperty("jdbcsession.url");
            this.url.setText(value != null ? value : "");
            value = this.props.getProperty("jdbcsession.service");
            value = this.props.getProperty("jdbcsession.user");
            this.user.setText(value != null ? value : "");
            value = this.props.getProperty("jdbcsession.password");
            this.password.setText(value != null ? value : "");
            value = this.props.getProperty("jdbcsession.classpathextension");
            this.classPathExt.setText(value != null ? value : "");
            value = this.props.getProperty("jdbcsession.driver");
            if (value != null) {
                try {
                    Class.forName(value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        lab = new JLabel(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("driverclass"), 2);
        UniversalDriverWrapper.registerDriverClassName(value);
        this.driver = new JComboBox<Object>(UniversalDriverWrapper.getRegisteredDrivers());
        if (value != null) {
            this.driver.setSelectedItem(value);
        }
        this.driver.setEditable(true);
        entries.add(lab);
        entries.add(this.driver);
        JPanel entriesWrapper = new JPanel();
        entriesWrapper.setLayout(new BoxLayout(entriesWrapper, 1));
        entriesWrapper.add(Box.createVerticalGlue());
        entriesWrapper.add(entries);
        entriesWrapper.add(Box.createVerticalGlue());
        JPanel areaWrapper = new JPanel(new BorderLayout(20, 3));
        areaWrapper.add((Component)entriesWrapper, "East");
        lab = new JLabel(Helpers.getIcon(this.getClass(), "dbpic.gif"));
        areaWrapper.add((Component)lab, "West");
        areaWrapper.add((Component)new JSeparator(1), "South");
        JPanel buttons = new JPanel(new GridLayout(1, 2, 10, 10));
        JButton button = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("ok"));
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(2);
        button.setMnemonic('O');
        button.addActionListener(this);
        buttons.add(button);
        button = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("cancel"));
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(4);
        button.setMnemonic('A');
        button.addActionListener(this);
        buttons.add(button);
        JPanel buttonsWrapper = new JPanel(new FlowLayout(1));
        buttonsWrapper.add(buttons);
        pathSelector.addActionListener(this);
        this.classPathExt.addActionListener(this);
        this.password.addActionListener(this);
        this.url.addActionListener(this);
        this.user.addActionListener(this);
        JPanel all = new JPanel(new BorderLayout(20, 20));
        all.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        all.add((Component)areaWrapper, "Center");
        all.add((Component)buttonsWrapper, "South");
        all.add((Component)lab, "West");
        this.setContentPane(all);
        this.pack();
        Helpers.doCenterWindow(this);
        this.setResizable(false);
        this.password.requestFocus();
    }

    public void setProperties(Properties props) {
        this.props = props;
        this.init();
    }

    public void setProperties(Properties props, String sessionName) {
        this.props = props;
        this.init();
    }

    public Properties getProperties() {
        return this.props;
    }

    public void actionPerformed(ActionEvent event) {
        String value;
        if (event.getActionCommand().equalsIgnoreCase(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("cancel"))) {
            this.properlyClosed = false;
            this.setVisible(false);
            return;
        }
        if (event.getActionCommand().equalsIgnoreCase("choosepath")) {
            PathExtensionDialog dialog = new PathExtensionDialog(this.classPathExt.getText());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.classPathExt.setText(dialog.getPath());
            return;
        }
        this.setVisible(false);
        this.properlyClosed = true;
        if (this.url == null || this.props == null) {
            this.props = new Properties();
        }
        this.props.put("jdbcsession.url", (value = this.url.getText()) != null ? value : "");
        value = this.password.getText();
        this.props.put("jdbcsession.password", value != null ? value : "");
        value = this.user.getText();
        this.props.put("jdbcsession.user", value != null ? value : "");
        value = this.classPathExt.getText();
        this.props.put("jdbcsession.classpathextension", value != null ? value : "");
        value = (String)this.driver.getSelectedItem();
        this.props.put("jdbcsession.driver", value != null ? value : "");
    }

    public boolean isProperlyClosed() {
        return this.properlyClosed;
    }
}

