/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class PathExtensionDialog
extends JDialog {
    private File[] pathItems = null;
    private File[] defaultItems = null;
    private JList itemList = null;
    private JButton okButton;
    private JButton delEntry;
    private static final int ARCHIVE = 0;
    private static final int DIR = 1;

    public PathExtensionDialog() {
        this((String)null);
    }

    public PathExtensionDialog(String path) {
        this(PathExtensionDialog.splitPath(path));
    }

    public PathExtensionDialog(File[] items) {
        this.setPathItems(items);
        this.defaultItems = this.pathItems;
        this.initComponents();
    }

    private void initComponents() {
        JScrollPane scroller = new JScrollPane();
        this.itemList = new JList();
        JPanel buttonPane = new JPanel();
        JPanel innerButtonPane = new JPanel();
        this.okButton = new JButton();
        JButton cancelButton = new JButton();
        JPanel pathButtonPane = new JPanel();
        JPanel innerPathButtonPane = new JPanel();
        JButton addLib = new JButton();
        JButton addDir = new JButton();
        this.delEntry = new JButton();
        scroller.setName("scroller");
        this.itemList.setName("itemList");
        scroller.setViewportView(this.itemList);
        this.getContentPane().add((Component)scroller, "Center");
        buttonPane.setName("outerButtonPane");
        innerButtonPane.setLayout(new GridLayout(1, 3));
        innerButtonPane.setName("innerOkCancel");
        this.okButton.setText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("ok"));
        this.okButton.setName("ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PathExtensionDialog.this.okbuttonActionPerformed(evt);
            }
        });
        innerButtonPane.add(this.okButton);
        cancelButton.setName("cancel");
        cancelButton.setText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PathExtensionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        innerButtonPane.add(cancelButton);
        buttonPane.add(innerButtonPane);
        this.getContentPane().add((Component)buttonPane, "South");
        pathButtonPane.setLayout(new BoxLayout(pathButtonPane, 1));
        pathButtonPane.setName("okCancelPane");
        innerPathButtonPane.setLayout(new GridLayout(3, 1));
        innerPathButtonPane.setName("innerButtons");
        addLib.setText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("zip/jar"));
        addLib.setName("addLib");
        addLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PathExtensionDialog.this.addLibActionPerformed(evt);
            }
        });
        innerPathButtonPane.add(addLib);
        addDir.setText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("directory"));
        addDir.setName("addDir");
        addDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PathExtensionDialog.this.addDirActionPerformed(evt);
            }
        });
        innerPathButtonPane.add(addDir);
        this.delEntry.setText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("delEntry"));
        this.delEntry.setName("erase");
        this.delEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PathExtensionDialog.this.delEntryActionPerformed(evt);
            }
        });
        innerPathButtonPane.add(this.delEntry);
        pathButtonPane.add(innerPathButtonPane);
        this.getContentPane().add((Component)pathButtonPane, "East");
        this.okButton.setEnabled(false);
        this.delEntry.setEnabled(false);
        this.updateFileList();
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.pathItems = this.defaultItems;
        this.setVisible(false);
    }

    private void okbuttonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void delEntryActionPerformed(ActionEvent evt) {
        int index = this.itemList.getSelectedIndex();
        File[] newItems = new File[this.pathItems.length - 1];
        System.arraycopy(this.pathItems, 0, newItems, 0, index);
        System.arraycopy(this.pathItems, index + 1, newItems, index, this.pathItems.length - index - 1);
        this.pathItems = newItems;
        this.updateFileList();
    }

    private void addDirActionPerformed(ActionEvent evt) {
        File selection = PathExtensionDialog.selectFileOnGUI(1);
        if (selection != null) {
            int itemLength = 0;
            if (this.pathItems != null) {
                itemLength = this.pathItems.length;
            }
            File[] newItems = new File[++itemLength];
            if (this.pathItems != null) {
                System.arraycopy(this.pathItems, 0, newItems, 0, this.pathItems.length);
            }
            newItems[itemLength - 1] = selection;
            this.pathItems = newItems;
            this.updateFileList();
        }
    }

    private void addLibActionPerformed(ActionEvent evt) {
        File selection = PathExtensionDialog.selectFileOnGUI(0);
        if (selection != null) {
            int itemLength = 0;
            if (this.pathItems != null) {
                itemLength = this.pathItems.length;
            }
            File[] newItems = new File[++itemLength];
            if (this.pathItems != null) {
                System.arraycopy(this.pathItems, 0, newItems, 0, this.pathItems.length);
            }
            newItems[itemLength - 1] = selection;
            this.pathItems = newItems;
            this.updateFileList();
        }
    }

    public File[] getPathItems() {
        if (this.pathItems == null) {
            return new File[0];
        }
        return this.pathItems;
    }

    public void setPathItems(File[] items) {
        this.pathItems = items;
    }

    public void setPath(String systemStylePath) {
        this.setPathItems(PathExtensionDialog.splitPath(systemStylePath));
    }

    public String getPath() {
        if (this.pathItems == null) {
            return "";
        }
        return PathExtensionDialog.joinPath(this.pathItems);
    }

    private void updateFileList() {
        if (this.itemList == null) {
            this.itemList = new JList();
        }
        this.itemList.setModel(new AbstractListModel(){

            public Object getElementAt(int i) {
                return PathExtensionDialog.this.pathItems[i];
            }

            public int getSize() {
                return PathExtensionDialog.this.pathItems == null ? 0 : PathExtensionDialog.this.pathItems.length;
            }
        });
        this.itemList.getSelectionModel().addListSelectionListener(new ButtonEnabler());
        this.okButton.setEnabled(this.defaultItems != this.pathItems);
    }

    private static File[] splitPath(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator, false);
        ArrayList<File> files = new ArrayList<File>(10);
        while (tokenizer.hasMoreTokens()) {
            files.add(new File(tokenizer.nextToken()));
        }
        Object[] array = files.toArray();
        File[] fileArray = new File[array.length];
        System.arraycopy(array, 0, fileArray, 0, array.length);
        return fileArray;
    }

    private static String joinPath(File[] items) {
        StringBuffer buffer = new StringBuffer(items.length * 30);
        int i = 0;
        while (i < items.length) {
            buffer.append(items[i]);
            if (i < items.length - 1) {
                buffer.append(File.pathSeparatorChar);
            }
            ++i;
        }
        return buffer.toString();
    }

    private static File selectFileOnGUI(int whatType) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        if (whatType == 0) {
            chooser.setFileFilter(new ArchiveFilter());
        } else {
            chooser.setFileSelectionMode(1);
        }
        int retVal = chooser.showOpenDialog(null);
        if (retVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private static class ArchiveFilter
    extends FileFilter {
        private ArchiveFilter() {
        }

        public boolean accept(File pathname) {
            String suffix = pathname.getAbsolutePath();
            return (suffix = suffix.substring(suffix.length() - 3, suffix.length())).equalsIgnoreCase("jar") || suffix.equalsIgnoreCase("zip") || pathname.isDirectory();
        }

        public String getDescription() {
            return ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("Archive_File");
        }
    }

    private class ButtonEnabler
    implements ListSelectionListener {
        private ButtonEnabler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            PathExtensionDialog.this.delEntry.setEnabled(PathExtensionDialog.this.itemList.getSelectedValues().length > 0);
        }
    }
}

