/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.action;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import lindhorst.apps.jdbc.swing.AppPane;
import lindhorst.apps.jdbc.swing.action.Action;
import lindhorst.apps.jdbc.swing.helpers.Helpers;

public class OpenSessionAction
extends Action {
    public OpenSessionAction(AppPane target) {
        super(target);
        this.putValue("Name", ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/actions").getString("open"));
        this.putValue("ShortDescription", ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/actions").getString("open.tip"));
        this.putValue("LongDescription", ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/actions").getString("open.tip.long"));
        this.putValue("SmallIcon", Helpers.getIcon(this.getClass(), "open16x16.gif"));
        this.putValue("LargeIcon", Helpers.getIcon(this.getClass(), "open32x32.gif"));
    }

    public void fulfillMission() {
        try {
            File file = Helpers.showOpenFileDialog();
            if (file == null) {
                return;
            }
            Properties props = new Properties();
            props.load(new FileInputStream(file));
            props.put("jdbcsession.file", file.getAbsolutePath());
            this.getTarget().createSession(props);
        }
        catch (Exception e) {
            Helpers.showError(e);
        }
    }
}

