/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.action;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import lindhorst.apps.jdbc.swing.AppPane;
import lindhorst.apps.jdbc.swing.action.Action;
import lindhorst.apps.jdbc.swing.data.SessionDataModel;
import lindhorst.apps.jdbc.swing.helpers.Helpers;

public class SaveSessionAction
extends Action {
    public SaveSessionAction(AppPane target) {
        super(target);
        this.putValue("Name", ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/actions").getString("save"));
        this.putValue("ShortDescription", ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/actions").getString("save.tip"));
        this.putValue("LongDescription", ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/actions").getString("save.tip.long"));
        this.putValue("SmallIcon", Helpers.getIcon(this.getClass(), "save16x16.gif"));
        this.putValue("LargeIcon", Helpers.getIcon(this.getClass(), "save32x32.gif"));
    }

    public void fulfillMission() {
        try {
            SessionDataModel session = this.getTarget().getModel();
            if (session == null) {
                return;
            }
            File file = Helpers.showSaveFileDialog();
            if (file == null) {
                return;
            }
            Properties props = session.getProperties();
            props.remove("jdbcsession.password");
            props.store(new FileOutputStream(file), "Do not modify; this file was created automatically!");
        }
        catch (Exception e) {
            Helpers.showError(e);
        }
    }
}

