/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.administration;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

class ListCellRendererSuperLayout
implements LayoutManager {
    private static int[] width = new int[2];
    private static int height;
    private int columns = 2;

    ListCellRendererSuperLayout() {
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container c) {
        int size;
        Component[] comps = c.getComponents();
        if (comps == null || comps.length == 0) {
            return new Dimension(0, 0);
        }
        int i = 0;
        while (i < comps.length) {
            size = comps[i].getPreferredSize().height;
            if (size > height) {
                height = size;
            }
            ++i;
        }
        int index = 0;
        while (index < comps.length) {
            int lineIndex = 0;
            while (lineIndex < this.columns && index < comps.length) {
                size = comps[index].getPreferredSize().width;
                if (size > width[lineIndex]) {
                    ListCellRendererSuperLayout.width[lineIndex] = size;
                }
                ++lineIndex;
                ++index;
            }
        }
        boolean overflow = comps.length % this.columns > 0;
        int rows = comps.length / this.columns;
        if (overflow) {
            ++rows;
        }
        int totalHeight = rows * height;
        int totalWidth = 0;
        int i2 = 0;
        while (i2 < this.columns) {
            totalWidth += width[i2];
            ++i2;
        }
        Insets insets = c.getInsets();
        totalWidth = totalWidth + insets.left + insets.right;
        totalHeight = totalHeight + insets.top + insets.bottom;
        return new Dimension(totalWidth, totalHeight);
    }

    public void layoutContainer(Container c) {
        int containerWidth;
        boolean useCalculatedWidths;
        Component[] comps = c.getComponents();
        if (comps == null || comps.length == 0) {
            return;
        }
        Dimension pSize = this.preferredLayoutSize(c);
        Insets insets = c.getInsets();
        pSize = new Dimension(pSize.width - insets.left - insets.right, pSize.height - insets.top - insets.bottom);
        boolean overflow = comps.length % this.columns > 0;
        int rows = comps.length / this.columns;
        if (overflow) {
            ++rows;
        }
        int containerHeight = c.getSize().height - insets.top - insets.bottom;
        int actualHeight = height;
        if (containerHeight < pSize.height) {
            actualHeight = containerHeight / rows;
        }
        boolean bl = useCalculatedWidths = (containerWidth = c.getSize().width - insets.left - insets.right) >= pSize.width;
        if (useCalculatedWidths) {
            int index = 0;
            int x = insets.left;
            int y = insets.top;
            while (index < comps.length) {
                x = insets.left;
                int lineIndex = 0;
                while (lineIndex < this.columns && index < comps.length) {
                    comps[index].setBounds(x, y, width[lineIndex], actualHeight);
                    x += width[lineIndex];
                    ++lineIndex;
                    ++index;
                }
                y += actualHeight;
            }
        } else {
            int index = 0;
            int x = insets.left;
            int y = insets.top;
            int actualWidth = containerWidth / this.columns;
            while (index < comps.length) {
                x = insets.top;
                int lineIndex = 0;
                while (lineIndex < this.columns && index < comps.length) {
                    comps[index].setBounds(x, y, actualWidth, actualHeight);
                    x += width[lineIndex];
                    ++lineIndex;
                    ++index;
                }
                y += actualHeight;
            }
        }
    }

    public Dimension minimumLayoutSize(Container c) {
        return this.preferredLayoutSize(c);
    }

    static {
        int i = 0;
        while (i < width.length) {
            ListCellRendererSuperLayout.width[i] = 0;
            ++i;
        }
        height = 0;
    }
}

