/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.administration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lindhorst.apps.jdbc.swing.administration.ModuleListCellRenderer;
import lindhorst.apps.jdbc.swing.data.SessionDataModel;
import lindhorst.apps.jdbc.swing.helpers.Helpers;

public class TabbedModuleView
extends JPanel {
    private JTabbedPane pane = new JTabbedPane(1);
    private SessionDataModel model = null;

    public TabbedModuleView(SessionDataModel model) {
        this.model = model;
        this.setLayout(new BorderLayout());
        this.pane.addTab(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("tables"), new ModuleView("tables"));
        this.pane.addTab(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("queries"), new ModuleView("queries"));
        this.add((Component)this.pane, "Center");
    }

    protected void openModule(String moduleType, String moduleName) {
        this.model.requestModule(moduleType, moduleName);
    }

    /*
     * Unable to fully structure code
     */
    protected void eraseModule(String moduleType, String moduleName) {
        props = this.model.getProperties();
        found = false;
        index = 0;
        prefix = "jdbcsession." + moduleType + ".";
        suffix = ".name";
        prop = null;
        index = 0;
        while ((prop = props.getProperty(prefix + index + suffix)) != null) {
            if (prop.equals(moduleName)) {
                found = true;
                break;
            }
            ++index;
        }
        if (found) ** GOTO lbl20
        JOptionPane.showMessageDialog(Helpers.getTopLevelContainer(), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("modul") + moduleName + ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("not_found"), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("not_found.title"), 0);
        return;
lbl-1000:
        // 1 sources

        {
            props.put(prefix + index + suffix, prop);
            ++index;
lbl20:
            // 2 sources

            ** while ((prop = props.getProperty((String)(prefix + (index + 1) + suffix))) != null)
        }
lbl21:
        // 1 sources

        props.remove(prefix + index + suffix);
        props.remove("jdbcsession." + moduleType + "." + moduleName + ".command");
        props.remove("jdbcsession." + moduleType + "." + moduleName + ".description");
        try {
            this.model.save();
        }
        catch (Exception e) {
            Helpers.showError(e);
        }
    }

    private class ModuleView
    extends JPanel
    implements ListSelectionListener,
    ActionListener,
    ChangeListener {
        private JList list;
        private String moduleType;
        private JButton open;
        private JButton create;
        private JButton erase;

        ModuleView(String moduleType) {
            this.moduleType = moduleType;
            this.list = new JList();
            this.list.setCellRenderer(new ModuleListCellRenderer());
            this.list.addListSelectionListener(this);
            JScrollPane scrollPane = new JScrollPane(this.list);
            JPanel box = new JPanel(new FlowLayout());
            JPanel buttonTemp = new JPanel(new BorderLayout(10, 10));
            this.open = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("open"));
            this.open.setMnemonic(0);
            this.open.setEnabled(false);
            this.open.setToolTipText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("open.long"));
            this.open.addActionListener(this);
            buttonTemp.add((Component)this.open, "North");
            this.create = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("new"));
            this.create.setMnemonic(0);
            this.create.setToolTipText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("new.long"));
            this.create.addActionListener(this);
            buttonTemp.add((Component)this.create, "Center");
            this.erase = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("delete"));
            this.erase.setEnabled(false);
            this.erase.setMnemonic(0);
            this.erase.setToolTipText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("delete.long"));
            this.erase.addActionListener(this);
            buttonTemp.add((Component)this.erase, "South");
            box.add(buttonTemp);
            this.setLayout(new BorderLayout());
            this.add((Component)scrollPane, "Center");
            this.add((Component)box, "East");
            TabbedModuleView.this.model.addChangeListener(this);
        }

        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("new"))) {
                TabbedModuleView.this.model.requestModule(this.moduleType, "<Neu>");
                return;
            }
            if (ae.getActionCommand().equals(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("open"))) {
                String[] pair = (String[])this.list.getSelectedValue();
                TabbedModuleView.this.openModule(this.moduleType, pair[0]);
                this.list.clearSelection();
                this.open.setEnabled(false);
                this.erase.setEnabled(false);
                return;
            }
            if (ae.getActionCommand().equals(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("delete"))) {
                String[] pair = (String[])this.list.getSelectedValue();
                TabbedModuleView.this.eraseModule(this.moduleType, pair[0]);
                this.list.clearSelection();
                this.open.setEnabled(false);
                this.erase.setEnabled(false);
            }
        }

        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            this.open.setEnabled(true);
            this.erase.setEnabled(true);
        }

        public void stateChanged(ChangeEvent event) {
            this.extractModuleNames();
            this.list.setListData(this.extractModuleNames());
            this.list.clearSelection();
            this.open.setEnabled(false);
            this.erase.setEnabled(false);
        }

        /*
         * WARNING - void declaration
         */
        private Object[] extractModuleNames() {
            String name;
            Vector<String[]> vector = new Vector<String[]>(100);
            Properties props = TabbedModuleView.this.model.getProperties();
            String prefix = "jdbcsession." + this.moduleType + ".";
            String suffix = ".name";
            int index = 0;
            while ((name = props.getProperty(prefix + index + suffix)) != null) {
                void var5_6;
                String[] pair = new String[]{var5_6, props.getProperty(prefix + (String)var5_6 + ".description")};
                vector.addElement(pair);
                ++index;
            }
            vector.trimToSize();
            Object[] temp = new Object[vector.size()];
            vector.copyInto(temp);
            this.sort(temp);
            return temp;
        }

        private final void sort(Object[] array) {
            int index = 0;
            int i = 0;
            while (i < array.length - 1) {
                index = i;
                String name1 = ((String[])array[i])[0].toLowerCase();
                int j = i + 1;
                while (j < array.length) {
                    String name2 = ((String[])array[j])[0].toLowerCase();
                    if (name2.compareTo(name1) < 0) {
                        name1 = name2;
                        index = j;
                    }
                    ++j;
                }
                if (index != i) {
                    Object temp = array[i];
                    array[i] = array[index];
                    array[index] = temp;
                }
                ++i;
            }
        }
    }
}

