/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import lindhorst.apps.jdbc.swing.administration.ModuleAdministration;
import lindhorst.apps.jdbc.swing.event.LoginEvent;
import lindhorst.apps.jdbc.swing.event.LoginListener;
import lindhorst.apps.jdbc.swing.event.ModuleRequestEvent;
import lindhorst.apps.jdbc.swing.event.ModuleRequestListener;
import lindhorst.apps.jdbc.swing.sql.UniversalDriverWrapper;

public class SessionDataModel {
    public static final String NO_MODULE_NAME = "no module name";
    private static final int READ_CONNECTION = 0;
    private static final int WRITE_CONNECTION = 1;
    private Connection readConnection = null;
    private Connection writeConnection = null;
    private SQLException exception = null;
    private Properties props = null;
    private StringBuffer warnings = new StringBuffer();
    private EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$lindhorst$apps$jdbc$swing$event$LoginListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$lindhorst$apps$jdbc$swing$event$ModuleRequestListener;

    public SessionDataModel(Properties props) throws SQLException, ClassNotFoundException {
        this(props, null);
    }

    public SessionDataModel(Properties props, LoginListener listener) throws SQLException, ClassNotFoundException {
        this.props = props;
        this.addLoginListener(listener);
        this.init();
        System.gc();
        System.runFinalization();
    }

    public SessionDataModel() throws SQLException, ClassNotFoundException {
        this(null);
    }

    public void init() throws SQLException, ClassNotFoundException {
        Object exception = null;
        ConnectionFetcher readFetcher = new ConnectionFetcher(0);
        ConnectionFetcher writeFetcher = new ConnectionFetcher(1);
        readFetcher.start();
        writeFetcher.start();
    }

    public void close() throws SQLException {
        this.fireLoginStatusChanged(1);
        try {
            if (this.readConnection != null) {
                this.readConnection.close();
            }
            if (this.writeConnection != null) {
                this.writeConnection.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fireLoginStatusChanged(3);
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public Properties getProperties() {
        return this.props;
    }

    public Connection getReadableConnection() {
        return this.readConnection;
    }

    public Connection getWritableConnection() {
        return this.writeConnection;
    }

    public SQLException getRaisedException() {
        SQLException localCopy = this.exception;
        this.exception = null;
        return localCopy;
    }

    public ModuleAdministration getAdministrationPanel() {
        return new ModuleAdministration(this);
    }

    public void requestModule(String moduleType, String moduleName) {
        this.fireModuleRequestEvent(moduleType, moduleName);
    }

    public void addLoginListener(LoginListener listener) {
        this.listeners.add(class$lindhorst$apps$jdbc$swing$event$LoginListener == null ? (class$lindhorst$apps$jdbc$swing$event$LoginListener = SessionDataModel.class$("lindhorst.apps.jdbc.swing.event.LoginListener")) : class$lindhorst$apps$jdbc$swing$event$LoginListener, listener);
    }

    public void removeLoginListener(LoginListener listener) {
        this.listeners.remove(class$lindhorst$apps$jdbc$swing$event$LoginListener == null ? (class$lindhorst$apps$jdbc$swing$event$LoginListener = SessionDataModel.class$("lindhorst.apps.jdbc.swing.event.LoginListener")) : class$lindhorst$apps$jdbc$swing$event$LoginListener, listener);
    }

    private void fireLoginStatusChanged(int type) {
        EventListener[] array = this.listeners.getListeners(class$lindhorst$apps$jdbc$swing$event$LoginListener == null ? (class$lindhorst$apps$jdbc$swing$event$LoginListener = SessionDataModel.class$("lindhorst.apps.jdbc.swing.event.LoginListener")) : class$lindhorst$apps$jdbc$swing$event$LoginListener);
        LoginEvent event = new LoginEvent(this, type);
        int i = 0;
        while (i < array.length) {
            ((LoginListener)array[i]).loginStatusChanged(event);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = SessionDataModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        listener.stateChanged(new ChangeEvent(this));
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = SessionDataModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        Object[] changeListeners = this.listeners.getListenerList();
        int i = 0;
        while (i < changeListeners.length) {
            if (changeListeners[i] == (class$javax$swing$event$ChangeListener == null ? SessionDataModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ((ChangeListener)changeListeners[i + 1]).stateChanged(event);
            }
            i += 2;
        }
    }

    public void addModuleRequestListener(ModuleRequestListener listener) {
        this.listeners.add(class$lindhorst$apps$jdbc$swing$event$ModuleRequestListener == null ? (class$lindhorst$apps$jdbc$swing$event$ModuleRequestListener = SessionDataModel.class$("lindhorst.apps.jdbc.swing.event.ModuleRequestListener")) : class$lindhorst$apps$jdbc$swing$event$ModuleRequestListener, listener);
    }

    public void removeModuleRequestListener(ModuleRequestListener listener) {
        this.listeners.remove(class$lindhorst$apps$jdbc$swing$event$ModuleRequestListener == null ? (class$lindhorst$apps$jdbc$swing$event$ModuleRequestListener = SessionDataModel.class$("lindhorst.apps.jdbc.swing.event.ModuleRequestListener")) : class$lindhorst$apps$jdbc$swing$event$ModuleRequestListener, listener);
    }

    private void fireModuleRequestEvent(String type, String name) {
        ModuleRequestEvent event = new ModuleRequestEvent(this, type, name);
        Object[] list = this.listeners.getListenerList();
        int i = 0;
        while (i < list.length) {
            if (list[i] == (class$lindhorst$apps$jdbc$swing$event$ModuleRequestListener == null ? SessionDataModel.class$("lindhorst.apps.jdbc.swing.event.ModuleRequestListener") : class$lindhorst$apps$jdbc$swing$event$ModuleRequestListener)) {
                ((ModuleRequestListener)list[i + 1]).moduleRequested(event);
            }
            i += 2;
        }
    }

    public void save() throws IOException {
        String fileName = this.props.getProperty("jdbcsession.file");
        System.out.println(fileName);
        this.props.remove("jdbcsession.password");
        try {
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream stream = new FileOutputStream(this.props.getProperty("jdbcsession.file"));
            this.props.store(stream, "Do not modify - this file is machine created!");
            this.fireChangeEvent();
        }
        catch (IOException exc) {
            throw new IOException("Konnte Session nicht speichern - Datei nicht gefunden!");
        }
    }

    private static URL[] getURLArray(String concatenatedPath) {
        ArrayList<URL> list = new ArrayList<URL>(10);
        StringTokenizer tokenizer = new StringTokenizer(concatenatedPath, File.pathSeparator, false);
        File file = null;
        while (tokenizer.hasMoreTokens()) {
            file = new File(tokenizer.nextToken());
            try {
                list.add(file.toURL());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        Object[] temp = list.toArray();
        URL[] array = new URL[temp.length];
        System.arraycopy(temp, 0, array, 0, temp.length);
        return array;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LoginEventFirer
    implements Runnable {
        private int type = -1;

        LoginEventFirer(int type) {
            this.type = type;
        }

        public void run() {
            SessionDataModel.this.fireLoginStatusChanged(this.type);
        }
    }

    private class ConnectionFetcher
    extends Thread {
        private Connection connection = null;
        private int connectionType = -1;

        ConnectionFetcher(int connectionType) {
            this.connectionType = connectionType;
        }

        public void run() {
            try {
                SwingUtilities.invokeAndWait(new LoginEventFirer(0));
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            Thread.yield();
            String path = SessionDataModel.this.props.getProperty("jdbcsession.classpathextension");
            ClassLoader loader = null;
            if (path != null && path.length() > 0) {
                URL[] urls = SessionDataModel.getURLArray(path);
                loader = new URLClassLoader(urls);
            } else {
                loader = this.getClass().getClassLoader();
            }
            String url = SessionDataModel.this.props.getProperty("jdbcsession.url");
            String driver = SessionDataModel.this.props.getProperty("jdbcsession.driver");
            String user = SessionDataModel.this.props.getProperty("jdbcsession.user");
            String password = SessionDataModel.this.props.getProperty("jdbcsession.password");
            try {
                UniversalDriverWrapper d = new UniversalDriverWrapper(loader, driver);
                this.connection = user == null || password == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, user, password);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    SessionDataModel.this.exception = (SQLException)e;
                } else {
                    SessionDataModel.this.exception = new SQLException("SQLException based on: " + e.toString());
                }
                SwingUtilities.invokeLater(new LoginEventFirer(2));
            }
            switch (this.connectionType) {
                case 0: {
                    SessionDataModel.this.readConnection = this.connection;
                    break;
                }
                case 1: {
                    SessionDataModel.this.writeConnection = this.connection;
                    break;
                }
                default: {
                    SessionDataModel.this.exception = new SQLException("Not a valid connection type");
                }
            }
            SwingUtilities.invokeLater(new LoginEventFirer(2));
        }
    }
}

