/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.helpers;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import lindhorst.swing.filechooser.ExtensionFileFilter;

public class Helpers {
    private static boolean errorBeingShown = false;
    private static Frame topLevel = null;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;

    public static void doCenterWindow(Window w) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension size = w.getSize();
        Point location = null;
        if (topLevel == null || !topLevel.isShowing() || topLevel == w) {
            Dimension screen = tk.getScreenSize();
            location = new Point((screen.width - size.width) / 2, (screen.height - size.height) / 2);
        } else {
            Point topLocation = topLevel.getLocationOnScreen();
            Dimension topSize = topLevel.getSize();
            int xOffset = (topSize.width - size.width) / 2;
            int yOffset = (topSize.height - size.height) / 2;
            location = new Point(topLocation.x + xOffset, topLocation.y + yOffset);
        }
        w.setLocation(location);
    }

    public static void setTopLevelContainer(Frame container) {
        topLevel = container;
    }

    public static Frame getTopLevelContainer() {
        return topLevel;
    }

    public static void toFront() {
        if (topLevel != null && topLevel instanceof Window) {
            topLevel.toFront();
            topLevel.requestFocus();
        }
    }

    public static void showError(Throwable t) {
        if (errorBeingShown) {
            return;
        }
        errorBeingShown = true;
        System.err.println(t.getLocalizedMessage());
        if (t.getMessage() != null) {
            JOptionPane.showMessageDialog(topLevel, t.getMessage(), t.getClass().getName(), 0);
        } else {
            JOptionPane.showMessageDialog(topLevel, t.getClass().getName(), t.getClass().getName(), 0);
        }
        errorBeingShown = false;
    }

    public static void showErrorInternally(Throwable t, Component parent) {
        if (errorBeingShown) {
            return;
        }
        errorBeingShown = true;
        if (t.getMessage() != null) {
            JOptionPane.showInternalMessageDialog(parent, t.getMessage(), t.getClass().getName(), 0);
        } else {
            JOptionPane.showInternalMessageDialog(parent, t.getClass().getName(), t.getClass().getName(), 0);
        }
        errorBeingShown = false;
        t.printStackTrace(System.err);
    }

    public static void showInfo(String info) {
        JOptionPane.showMessageDialog(topLevel, info, "Information", 1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getResource(Class c, String fileName) {
        byte[] bytes = null;
        try {
            int b;
            InputStream in = c.getResourceAsStream(fileName);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            while ((b = in.read()) != -1) {
                void var5_6;
                out.write((int)var5_6);
            }
            bytes = out.toByteArray();
        }
        catch (Exception e) {}
        return bytes;
    }

    public static Image getImage(Class c, String fileName) {
        return Toolkit.getDefaultToolkit().createImage(Helpers.getResource(c, fileName));
    }

    public static ImageIcon getIcon(Class c, String fileName) {
        return new ImageIcon(Helpers.getResource(c, fileName));
    }

    public static File showOpenFileDialog() {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        ExtensionFileFilter filter = new ExtensionFileFilter();
        filter.addExtension("properties");
        filter.setDescription("Java-Properties Dateien");
        chooser.setFileFilter(filter);
        int retVal = chooser.showOpenDialog(topLevel);
        if (retVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static File showSaveFileDialog() {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        ExtensionFileFilter filter = new ExtensionFileFilter();
        filter.addExtension("properties");
        filter.setDescription("Java-Properties Dateien");
        chooser.setFileFilter(filter);
        int retVal = chooser.showSaveDialog(topLevel);
        if (retVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static void setCursor(Component comp, Cursor cursor) {
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            int i = 0;
            while (i < comps.length) {
                Helpers.setCursor(comps[i], cursor);
                ++i;
            }
        }
        comp.setCursor(cursor);
    }

    public static Number convertToNumber(String from, Class toClass) {
        if (toClass == (class$java$lang$Double == null ? (class$java$lang$Double = Helpers.class$("java.lang.Double")) : class$java$lang$Double) || toClass == (class$java$lang$Float == null ? (class$java$lang$Float = Helpers.class$("java.lang.Float")) : class$java$lang$Float)) {
            Double d = Double.valueOf(from);
            if (toClass == (class$java$lang$Double == null ? (class$java$lang$Double = Helpers.class$("java.lang.Double")) : class$java$lang$Double)) {
                return d;
            }
            return new Float(d.floatValue());
        }
        if (toClass == (class$java$lang$Long == null ? (class$java$lang$Long = Helpers.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(from);
        }
        return new Integer(Double.valueOf(from).intValue());
    }

    public static java.util.Date convertToDate(String from, Locale locale) {
        java.util.Date d = null;
        DateFormat formatter = DateFormat.getDateInstance(3, locale);
        d = Helpers.parseDate(formatter, from);
        if (d != null) {
            return d;
        }
        formatter = DateFormat.getDateInstance(2, locale);
        d = Helpers.parseDate(formatter, from);
        if (d != null) {
            return d;
        }
        formatter = DateFormat.getDateInstance(1, locale);
        d = Helpers.parseDate(formatter, from);
        if (d != null) {
            return d;
        }
        formatter = DateFormat.getDateTimeInstance(1, 1, locale);
        d = Helpers.parseDate(formatter, from);
        if (d != null) {
            return d;
        }
        formatter = DateFormat.getInstance();
        d = Helpers.parseDate(formatter, from);
        if (d != null) {
            return d;
        }
        if (!locale.equals(Locale.US)) {
            d = Helpers.convertToDate(from, Locale.US);
        }
        if (d != null) {
            return d;
        }
        d = Helpers.parseSQLDate(from);
        return d;
    }

    private static java.util.Date parseDate(DateFormat format, String date) {
        java.util.Date d = null;
        try {
            d = format.parse(date);
        }
        catch (Exception exc) {}
        return d;
    }

    private static java.util.Date parseSQLDate(String date) {
        java.util.Date d = null;
        try {
            d = Timestamp.valueOf(date);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (d != null) {
            return d;
        }
        try {
            d = Date.valueOf(date);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (d != null) {
            return d;
        }
        try {
            d = Time.valueOf(date);
        }
        catch (Exception e) {}
        return d;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

