/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.modules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.sql.Connection;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lindhorst.apps.jdbc.swing.helpers.Helpers;
import lindhorst.apps.jdbc.swing.modules.Module;
import lindhorst.apps.jdbc.swing.modules.datamodels.QueriesDataModel;

public class Queries
extends JInternalFrame
implements ChangeListener,
Module {
    private JTable table = new JTable(1, 1);
    private JPanel out = new JPanel(new BorderLayout(0, 0));
    private JTextArea errors = new JTextArea();
    private QueriesDataModel model = null;
    private String name = null;

    public Queries(QueriesDataModel model, String name) {
        super(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("queries"), true, true, true, true);
        this.name = name;
        this.setTitle(name);
        this.setFrameIcon(Helpers.getIcon(this.getClass(), "queries.gif"));
        this.setOpaque(false);
        this.model = model;
        model.addChangeListener(this);
        this.init();
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.validate();
    }

    public Queries(Connection readableConnection, Connection writableConnection, String name) {
        this(new QueriesDataModel(readableConnection, writableConnection), name);
    }

    public void init() {
        this.out.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("db_output")));
        this.table.setModel(this.model.getTableModelFromOutput());
        this.table.setAutoResizeMode(0);
        JScrollPane tableView = new JScrollPane(this.table);
        tableView.setPreferredSize(new Dimension(400, 350));
        this.out.add((Component)tableView, "Center");
        JSplitPane pane = new JSplitPane(1, false);
        pane.setOneTouchExpandable(true);
        pane.add(this.out);
        Box box2 = Box.createVerticalBox();
        JPanel err = new JPanel(new BorderLayout());
        err.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("sql_errors")));
        this.errors.setLineWrap(true);
        this.errors.setWrapStyleWord(true);
        JScrollPane errView = new JScrollPane(this.errors, 20, 31);
        errView.setPreferredSize(new Dimension(100, 200));
        this.errors.setEditable(false);
        err.add((Component)errView, "Center");
        box2.add(err);
        pane.add(box2);
        pane.resetToPreferredSizes();
        JPanel c = new JPanel(new BorderLayout(5, 5));
        c.setLayout(new BorderLayout(10, 10));
        c.add((Component)pane, "Center");
        this.setContentPane(c);
    }

    public QueriesDataModel getModel() {
        return this.model;
    }

    public void setModel(QueriesDataModel model) {
        this.model = model;
        model.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent event) {
        String warnings;
        if (this.model.isExecuting()) {
            Helpers.setCursor(this, Cursor.getPredefinedCursor(3));
        }
        this.errors.setText((warnings = this.model.getWarnings()) != null ? warnings : "");
        this.table.setModel(this.model.getTableModelFromOutput());
        this.table.validate();
        if (!this.model.isExecuting()) {
            Helpers.setCursor(this, Cursor.getDefaultCursor());
        }
    }
}

