/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.modules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lindhorst.apps.jdbc.swing.AppPane;
import lindhorst.apps.jdbc.swing.helpers.Helpers;
import lindhorst.apps.jdbc.swing.modules.Module;
import lindhorst.apps.jdbc.swing.modules.datamodels.QueriesDataModel;

public class QueryMaker
extends JInternalFrame
implements ChangeListener,
ListSelectionListener,
ActionListener,
Module {
    private JTextArea input = new JTextArea(3, 0);
    private JTable table = new JTable(1, 1);
    private JPanel out = new JPanel(new BorderLayout(0, 0));
    private JTextArea errors = new JTextArea();
    private QueriesDataModel model = null;
    private JList list = new JList();

    public QueryMaker(QueriesDataModel model) {
        super(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("queries"), true, true, true, true);
        this.setFrameIcon(Helpers.getIcon(this.getClass(), "queries.gif"));
        this.setOpaque(false);
        this.model = model;
        model.addChangeListener(this);
        this.init();
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.validate();
    }

    public QueryMaker(Connection readableConnection, Connection writableConnection) {
        this(new QueriesDataModel(readableConnection, writableConnection));
    }

    public void init() {
        this.out.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("db_output")));
        this.table.setModel(this.model.getTableModelFromOutput());
        this.table.setAutoResizeMode(0);
        JScrollPane tableView = new JScrollPane(this.table);
        tableView.setPreferredSize(new Dimension(400, 350));
        this.out.add((Component)tableView, "Center");
        JSplitPane pane = new JSplitPane(1, false);
        pane.setOneTouchExpandable(true);
        pane.add(this.out);
        Box box2 = Box.createVerticalBox();
        JPanel err = new JPanel(new BorderLayout());
        err.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("sql_errors")));
        this.errors.setLineWrap(true);
        this.errors.setWrapStyleWord(true);
        JScrollPane errView = new JScrollPane(this.errors, 20, 31);
        errView.setPreferredSize(new Dimension(100, 200));
        this.errors.setEditable(false);
        err.add((Component)errView, "Center");
        box2.add(err);
        box2.add(Box.createVerticalStrut(10));
        JPanel old = new JPanel(new BorderLayout());
        old.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("previous_commands")));
        JScrollPane listView = new JScrollPane(this.list);
        listView.setPreferredSize(new Dimension(100, 100));
        this.list.setListData(this.model.getOldCommands());
        this.list.addListSelectionListener(this);
        old.add((Component)listView, "Center");
        box2.add(old);
        pane.add(box2);
        pane.resetToPreferredSizes();
        JPanel command = new JPanel(new BorderLayout());
        command.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("sql_command")));
        this.input.setLineWrap(true);
        command.add((Component)new JScrollPane(this.input), "Center");
        JPanel buttonsSurroundings = new JPanel();
        buttonsSurroundings.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 10));
        buttonsSurroundings.setLayout(new GridLayout(3, 1, 5, 5));
        JButton button = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("ok"));
        button.setMnemonic('O');
        button.setToolTipText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("exec.tooltip"));
        button.addActionListener(this);
        buttonsSurroundings.add((Component)button, new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 1));
        button = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("save"));
        button.setMnemonic('S');
        button.setToolTipText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("save.tooltip"));
        button.addActionListener(this);
        buttonsSurroundings.add((Component)button, new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 1));
        button = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("delete"));
        button.setMnemonic('L');
        button.setToolTipText(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("delete.tooltip"));
        button.addActionListener(this);
        buttonsSurroundings.add((Component)button, new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 1));
        command.add((Component)buttonsSurroundings, "East");
        JPanel c = new JPanel(new BorderLayout(5, 5));
        c.setLayout(new BorderLayout(10, 10));
        c.add((Component)pane, "Center");
        c.add((Component)command, "South");
        this.setContentPane(c);
    }

    public QueriesDataModel getModel() {
        return this.model;
    }

    public void setModel(QueriesDataModel model) {
        this.model = model;
        model.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent event) {
        String warnings;
        if (this.model.isExecuting()) {
            Helpers.setCursor(this, Cursor.getPredefinedCursor(3));
        }
        this.errors.setText((warnings = this.model.getWarnings()) != null ? warnings : "");
        this.list.setListData(this.model.getOldCommands());
        this.list.ensureIndexIsVisible(this.list.getModel().getSize());
        this.table.setModel(this.model.getTableModelFromOutput());
        this.table.validate();
        if (!this.model.isExecuting()) {
            Helpers.setCursor(this, Cursor.getDefaultCursor());
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        this.input.setText((String)this.list.getSelectedValue());
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equalsIgnoreCase(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("save"))) {
            this.save();
            return;
        }
        if (ae.getActionCommand().equalsIgnoreCase(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("delete"))) {
            this.input.setText("");
            return;
        }
        String sql = this.input.getText().replace('\r', ' ');
        sql = sql.replace('\n', ' ');
        this.input.setText("");
        this.model.executeSQL(sql);
    }

    public void save() {
        String name;
        String command = this.input.getText();
        if (command == null || command.equals("")) {
            JOptionPane.showMessageDialog(Helpers.getTopLevelContainer(), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("no_sql_command"), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("no_command"), 0);
            return;
        }
        Object[] names = this.extractQueryNames();
        boolean doAgain = true;
        do {
            int retValue;
            if ((name = JOptionPane.showInputDialog(Helpers.getTopLevelContainer(), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("name_entry"), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("save_as"), 3)) == null) {
                return;
            }
            if (name.equals("") || name.indexOf(32) >= 0) continue;
            doAgain = false;
            int i = 0;
            while (i < names.length) {
                if (((String)names[i]).equals(name)) {
                    doAgain = true;
                    break;
                }
                ++i;
            }
            if (!doAgain || (retValue = JOptionPane.showConfirmDialog(Helpers.getTopLevelContainer(), name + ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("already_exists"), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("overwrite"), 0, 2)) != 0) continue;
            doAgain = false;
        } while (doAgain);
        String description = JOptionPane.showInputDialog(Helpers.getTopLevelContainer(), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("description"), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("save_as"), 3);
        if (description == null) {
            return;
        }
        boolean alreadyThere = false;
        int i = 0;
        while (i < names.length) {
            if (((String)names[i]).equals(name)) {
                alreadyThere = true;
                break;
            }
            ++i;
        }
        Properties props = ((AppPane)this.getParent()).getModel().getProperties();
        if (!alreadyThere) {
            props.put("jdbcsession.queries." + names.length + ".name", name);
        }
        props.put("jdbcsession.queries." + name + ".command", command);
        props.put("jdbcsession.queries." + name + ".description", description);
        try {
            ((AppPane)this.getParent()).getModel().save();
        }
        catch (Exception exc) {
            Helpers.showError(exc);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object[] extractQueryNames() {
        String name;
        ArrayList<void> array = new ArrayList<void>(20);
        Properties props = ((AppPane)this.getParent()).getModel().getProperties();
        int index = 0;
        while ((name = props.getProperty("jdbcsession.queries." + index + ".name")) != null) {
            void var4_4;
            array.add(var4_4);
            ++index;
        }
        return array.toArray();
    }
}

