/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.modules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import lindhorst.apps.jdbc.swing.AppPane;
import lindhorst.apps.jdbc.swing.helpers.Helpers;
import lindhorst.apps.jdbc.swing.modules.Module;
import lindhorst.apps.jdbc.swing.modules.SingleRecordEditor;
import lindhorst.apps.jdbc.swing.modules.datamodels.TableDataModel;

public class Table
extends JInternalFrame
implements Module {
    private TableDataModel model = null;
    private JTable table = null;
    private JLabel infoLabel;
    private JProgressBar bar;
    private JPanel info;
    private JButton deleter;

    public Table(TableDataModel model) {
        super(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("table"), true, true, true, true);
        this.model = model;
        this.setFrameIcon(Helpers.getIcon(this.getClass(), "tables.gif"));
        this.setTitle(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("table") + model.getTableName());
        this.setOpaque(false);
        this.init();
        this.pack();
        this.setVisible(true);
    }

    public Table(Connection readableConnection, Connection writableConnection, String name) {
        this(new TableDataModel(readableConnection, writableConnection, name));
    }

    protected void init() {
        this.table = new JTable();
        this.table.setAutoResizeMode(0);
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                JTableHeader header = (JTableHeader)event.getSource();
                int x = event.getPoint().x;
                TableColumnModel columnModel = header.getColumnModel();
                TableColumn column = columnModel.getColumn(columnModel.getColumnIndexAtX(x));
                String columnName = column.getHeaderValue().toString();
                Table.this.model.doSort(columnName);
            }
        });
        JScrollPane tableView = new JScrollPane(this.table);
        tableView.setPreferredSize(new Dimension(400, 250));
        JPanel cPane = new JPanel(new GridLayout(1, 1));
        cPane.add(tableView);
        cPane.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("table")));
        this.info = new JPanel(new GridLayout(1, 2));
        this.infoLabel = new JLabel(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("reading_table:"));
        this.info.add(this.infoLabel);
        this.bar = new JProgressBar(0, 100);
        this.info.add(this.bar);
        this.info.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.model.addChangeListener(new BarUpdater());
        JPanel buttons = new JPanel(new GridLayout(0, 1));
        JButton button = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("save"));
        button.setMnemonic('S');
        buttons.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Table.this.save();
            }
        });
        this.deleter = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("delete_row"));
        this.deleter.setActionCommand("DELETE");
        this.deleter.setMnemonic('l');
        this.deleter.setEnabled(false);
        this.deleter.addActionListener(new LineDeleter());
        buttons.add(this.deleter);
        button = new JButton(ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("insert_row"));
        button.setMnemonic('e');
        button.addActionListener(new LineInserter());
        buttons.add(button);
        JPanel outerButtons = new JPanel(new FlowLayout(1));
        outerButtons.add(buttons);
        JPanel all = new JPanel(new BorderLayout(5, 5));
        all.add((Component)cPane, "Center");
        all.add((Component)outerButtons, "East");
        all.add((Component)this.info, "South");
        this.setContentPane(all);
        this.table.setModel(this.model);
        this.table.getSelectionModel().addListSelectionListener(new DeleteEnabler());
        this.model.addChangeListener(new CursorSwitch());
    }

    public void save() {
        String name = this.model.getTableName();
        Object[] names = this.extractTableNames();
        boolean doAgain = true;
        String description = JOptionPane.showInputDialog(Helpers.getTopLevelContainer(), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("description"), ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("save_as"), 3);
        if (description == null) {
            return;
        }
        boolean alreadyThere = false;
        int i = 0;
        while (i < names.length) {
            if (((String)names[i]).equals(name)) {
                alreadyThere = true;
                break;
            }
            ++i;
        }
        Properties props = ((AppPane)this.getParent()).getModel().getProperties();
        if (!alreadyThere) {
            props.put("jdbcsession.tables." + names.length + ".name", name);
        }
        props.put("jdbcsession.tables." + name + ".description", description);
        try {
            ((AppPane)this.getParent()).getModel().save();
        }
        catch (Exception exc) {
            Helpers.showError(exc);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object[] extractTableNames() {
        String name;
        ArrayList<void> array = new ArrayList<void>(20);
        Properties props = ((AppPane)this.getParent()).getModel().getProperties();
        int index = 0;
        while ((name = props.getProperty("jdbcsession.tables." + index + ".name")) != null) {
            void var4_4;
            array.add(var4_4);
            ++index;
        }
        return array.toArray();
    }

    private JInternalFrame getInstance() {
        return this;
    }

    private class LineInserter
    implements ActionListener {
        private LineInserter() {
        }

        public void actionPerformed(ActionEvent ae) {
            block2: {
                SingleRecordEditor editor = new SingleRecordEditor(Table.this.model.getColumnNames(), Table.this.model.getColumnClasses());
                if (!editor.isProperlyClosed()) break block2;
                try {
                    Table.this.model.insertLine(editor.getData());
                }
                catch (SQLException e) {
                    Helpers.showError(e);
                }
            }
        }
    }

    private class LineDeleter
    implements ActionListener {
        private LineDeleter() {
        }

        public void actionPerformed(ActionEvent ae) {
            Table.this.model.deleteLines(Table.this.table.getSelectedRows());
        }
    }

    private class DeleteEnabler
    implements ListSelectionListener {
        private DeleteEnabler() {
        }

        public void valueChanged(ListSelectionEvent event) {
            Table.this.deleter.setEnabled(!((ListSelectionModel)event.getSource()).isSelectionEmpty());
        }
    }

    private class CursorSwitch
    implements ChangeListener {
        private CursorSwitch() {
        }

        public void stateChanged(ChangeEvent e) {
            if (Table.this.model != null && Table.this.model.isRetrievingData()) {
                Helpers.setCursor(Table.this.getInstance(), Cursor.getPredefinedCursor(3));
            } else {
                Helpers.setCursor(Table.this.getInstance(), Cursor.getDefaultCursor());
            }
        }
    }

    private class BarUpdater
    implements ChangeListener {
        private BarUpdater() {
        }

        public void stateChanged(ChangeEvent event) {
            Table.this.bar.setMaximum(Table.this.model.getNumberOfRecords());
            Table.this.bar.setValue(Table.this.model.getNumberOfRecordsRead());
            if (Table.this.model.getNumberOfRecordsRead() <= 0 || Table.this.bar.getPercentComplete() < 1.0) {
                Table.this.bar.setVisible(true);
                if (Table.this.model.isAssessingTableSize()) {
                    Table.this.infoLabel.setText("Sch\u00e4tze Tabellengr\u00f6\u00dfe ...");
                } else {
                    Table.this.infoLabel.setText("Lese Tabellendaten ...");
                }
                Table.this.infoLabel.setVisible(true);
            } else {
                Table.this.bar.setVisible(false);
                Table.this.infoLabel.setVisible(false);
                Table.this.info.repaint(0L);
            }
        }
    }
}

