/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.modules.datamodels;

import java.util.Date;

class ArraySorter {
    ArraySorter() {
    }

    public static int[] sortObjects(Object[] array) {
        int[] indices = ArraySorter.prepareIndices(array.length);
        String[] strings = new String[array.length];
        int i = 0;
        while (i < array.length) {
            strings[i] = array[i] != null ? array[i].toString() : "";
            ++i;
        }
        indices = ArraySorter.doQuickSort(strings, indices, 0, strings.length);
        return indices;
    }

    public static int[] sortStrings(String[] array) {
        int[] indices = ArraySorter.prepareIndices(array.length);
        String[] strings = new String[array.length];
        int i = 0;
        while (i < array.length) {
            strings[i] = array[i] != null ? array[i] : "";
            ++i;
        }
        indices = ArraySorter.doQuickSort(strings, indices, 0, strings.length);
        return indices;
    }

    public static int[] sortNumbers(Number[] array) {
        int[] indices = ArraySorter.prepareIndices(array.length);
        double[] doubles = new double[array.length];
        int i = 0;
        while (i < array.length) {
            doubles[i] = array[i] != null ? array[i].doubleValue() : 0.0;
            ++i;
        }
        indices = ArraySorter.doQuickSort(doubles, indices, 0, doubles.length);
        return indices;
    }

    public static int[] sortDates(Date[] array) {
        int[] indices = ArraySorter.prepareIndices(array.length);
        long[] millis = new long[array.length];
        int i = 0;
        while (i < array.length) {
            millis[i] = array[i] != null ? array[i].getTime() : 0L;
            ++i;
        }
        indices = ArraySorter.doQuickSort(millis, indices, 0, millis.length);
        return indices;
    }

    private static int[] prepareIndices(int length) {
        int[] indices = new int[length];
        int i = 0;
        while (i < length) {
            indices[i] = i;
            ++i;
        }
        return indices;
    }

    private static int[] doQuickSort(String[] toSort, int[] indices, int start, int length) {
        if (length <= 1) {
            return indices;
        }
        int median = start + length / 2;
        String temp = null;
        int index = 0;
        int highOut = start + length;
        int i = median + 1;
        while (i < highOut) {
            if (toSort[i].compareTo(toSort[median]) < 0) {
                temp = toSort[i];
                System.arraycopy(toSort, start, toSort, start + 1, i - start);
                toSort[start] = temp;
                index = indices[i];
                System.arraycopy(indices, start, indices, start + 1, i - start);
                indices[start] = index;
                ++median;
            }
            ++i;
        }
        int i2 = start;
        while (i2 < median) {
            if (toSort[i2].compareTo(toSort[median]) > 0) {
                temp = toSort[i2];
                System.arraycopy(toSort, i2 + 1, toSort, i2, start + length - 1 - i2);
                toSort[start + length - 1] = temp;
                index = indices[i2];
                System.arraycopy(indices, i2 + 1, indices, i2, start + length - 1 - i2);
                indices[start + length - 1] = index;
                --median;
                --i2;
            }
            ++i2;
        }
        ArraySorter.doQuickSort(toSort, indices, start, median - start);
        ArraySorter.doQuickSort(toSort, indices, median + 1, length - (median + 1 - start));
        return indices;
    }

    private static int[] doQuickSort(double[] toSort, int[] indices, int start, int length) {
        if (length <= 1) {
            return indices;
        }
        int median = start + length / 2;
        double temp = 0.0;
        int index = 0;
        int highOut = start + length;
        int i = median + 1;
        while (i < highOut) {
            if (toSort[i] < toSort[median]) {
                temp = toSort[i];
                System.arraycopy(toSort, start, toSort, start + 1, i - start);
                toSort[start] = temp;
                index = indices[i];
                System.arraycopy(indices, start, indices, start + 1, i - start);
                indices[start] = index;
                ++median;
            }
            ++i;
        }
        int i2 = start;
        while (i2 < median) {
            if (toSort[i2] > toSort[median]) {
                temp = toSort[i2];
                System.arraycopy(toSort, i2 + 1, toSort, i2, start + length - 1 - i2);
                toSort[start + length - 1] = temp;
                index = indices[i2];
                System.arraycopy(indices, i2 + 1, indices, i2, start + length - 1 - i2);
                indices[start + length - 1] = index;
                --median;
                --i2;
            }
            ++i2;
        }
        ArraySorter.doQuickSort(toSort, indices, start, median - start);
        ArraySorter.doQuickSort(toSort, indices, median + 1, length - (median + 1 - start));
        return indices;
    }

    private static int[] doQuickSort(long[] toSort, int[] indices, int start, int length) {
        if (length <= 1) {
            return indices;
        }
        int median = start + length / 2;
        long temp = 0L;
        int index = 0;
        int highOut = start + length;
        int i = median + 1;
        while (i < highOut) {
            if (toSort[i] < toSort[median]) {
                temp = toSort[i];
                System.arraycopy(toSort, start, toSort, start + 1, i - start);
                toSort[start] = temp;
                index = indices[i];
                System.arraycopy(indices, start, indices, start + 1, i - start);
                indices[start] = index;
                ++median;
            }
            ++i;
        }
        int i2 = start;
        while (i2 < median) {
            if (toSort[i2] > toSort[median]) {
                temp = toSort[i2];
                System.arraycopy(toSort, i2 + 1, toSort, i2, start + length - 1 - i2);
                toSort[start + length - 1] = temp;
                index = indices[i2];
                System.arraycopy(indices, i2 + 1, indices, i2, start + length - 1 - i2);
                indices[start + length - 1] = index;
                --median;
                --i2;
            }
            ++i2;
        }
        ArraySorter.doQuickSort(toSort, indices, start, median - start);
        ArraySorter.doQuickSort(toSort, indices, median + 1, length - (median + 1 - start));
        return indices;
    }

    static int[] invert(int[] indices) {
        int[] neu = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            neu[i] = indices[indices.length - i - 1];
            ++i;
        }
        return neu;
    }
}

