/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.modules.datamodels;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import lindhorst.apps.jdbc.swing.helpers.Helpers;
import lindhorst.apps.jdbc.swing.modules.datamodels.ArraySorter;

public class TableDataModel
implements TableModel {
    private Object[][] data = null;
    private int lastSortedIndex = -1;
    private String[] headers = null;
    private Class[] classes = null;
    private String tableName = null;
    private boolean executing = false;
    private boolean assessingSize = false;
    private Connection readConnection = null;
    private Connection writeConnection = null;
    private String warnings = null;
    private EventListenerList listeners = new EventListenerList();
    private int numberOfRecords = 0;
    private int numberOfRecordsRead = 0;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$javax$swing$event$TableModelListener;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;

    public TableDataModel(Connection readableConnection, Connection writableConnection, String tableName) {
        if (tableName == null) {
            throw new NullPointerException();
        }
        if (tableName.equals("")) {
            throw new IllegalArgumentException();
        }
        this.tableName = tableName;
        this.readConnection = readableConnection;
        this.writeConnection = writableConnection;
        this.init();
    }

    public void init() {
        new DataRetriever().start();
    }

    public boolean isRetrievingData() {
        return this.executing;
    }

    public boolean isAssessingTableSize() {
        return this.assessingSize;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TableDataModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        listener.stateChanged(new ChangeEvent(this));
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TableDataModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
    }

    private void fireStateChanged() {
        final ChangeEvent event = new ChangeEvent(this);
        final EventListener[] array = this.listeners.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TableDataModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
        if (SwingUtilities.isEventDispatchThread()) {
            int i = 0;
            while (i < array.length) {
                ((ChangeListener)array[i]).stateChanged(event);
                ++i;
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < array.length) {
                        ((ChangeListener)array[i]).stateChanged(event);
                        ++i;
                    }
                }
            });
        }
    }

    public void addTableModelListener(TableModelListener listener) {
        this.listeners.add(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = TableDataModel.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, listener);
        listener.tableChanged(new TableModelEvent(this));
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.listeners.remove(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = TableDataModel.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, listener);
    }

    private void fireTableChanged(TableModelEvent event) {
        final EventListener[] array = this.listeners.getListeners(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = TableDataModel.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener);
        if (SwingUtilities.isEventDispatchThread()) {
            int i = 0;
            while (i < array.length) {
                ((TableModelListener)array[i]).tableChanged(event);
                ++i;
            }
        } else {
            final TableModelEvent tempEvent = event;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < array.length) {
                        ((TableModelListener)array[i]).tableChanged(tempEvent);
                        ++i;
                    }
                }
            });
        }
    }

    public void fireEntireTableChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1, Integer.MAX_VALUE, -1, 0));
    }

    private void fireTableRowsChanged(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow));
    }

    private void fireTableEndChanged(int firstRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow));
    }

    private void fireTableColumnChangedInRows(int column, int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, column, 0));
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getWarnings() {
        return this.warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValueAt(Object value, int row, int column) {
        if (this.classes != null && this.classes.length > column) {
            System.out.println("value: " + value.getClass() + "; target:" + this.classes[column].getName());
            if (value instanceof String && this.classes[column].getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = TableDataModel.class$("java.lang.Number")) : class$java$lang$Number)) {
                value = Helpers.convertToNumber((String)value, this.classes[column]);
            }
            if (value instanceof String && this.classes[column] == (class$java$util$Date == null ? (class$java$util$Date = TableDataModel.class$("java.util.Date")) : class$java$util$Date)) {
                value = Helpers.convertToDate((String)value, Locale.getDefault());
            }
            if (value == null) {
                this.fireTableColumnChangedInRows(column, row, row);
                return;
            }
        }
        Statement stmt = null;
        Connection connection = this.writeConnection;
        try {
            this.executing = true;
            connection.setReadOnly(false);
            connection.setAutoCommit(false);
            StringBuffer sqlString = new StringBuffer(1000);
            sqlString.append("UPDATE ");
            sqlString.append(this.tableName);
            sqlString.append(" SET ");
            sqlString.append(this.headers[column]);
            sqlString.append("=");
            boolean needsQuotes = this.getQuotationMarksNeeded(row, column);
            if (needsQuotes) {
                sqlString.append("'");
            }
            if (value instanceof Date) {
                sqlString.append(TableDataModel.getSQLDate((Date)value));
            } else {
                sqlString.append(value);
            }
            if (needsQuotes) {
                sqlString.append("'");
            }
            boolean firstOption = true;
            int step = this.data[row].length / 10;
            if (step <= 0) {
                step = 1;
            }
            int i = 0;
            while (i < this.getColumnCount()) {
                if (this.data[row][i] != null && !(this.data[row][i] instanceof Date)) {
                    if (firstOption) {
                        sqlString.append(" WHERE ");
                    }
                    if (!firstOption) {
                        sqlString.append(" AND ");
                    }
                    firstOption = false;
                    sqlString.append(this.headers[i]);
                    sqlString.append("=");
                    needsQuotes = this.getQuotationMarksNeeded(row, i);
                    if (needsQuotes) {
                        sqlString.append("'");
                    }
                    if (this.data[row][i] instanceof Date) {
                        sqlString.append(TableDataModel.getSQLDate((Date)this.data[row][i]));
                    } else {
                        sqlString.append(this.data[row][i]);
                    }
                    if (needsQuotes) {
                        sqlString.append("'");
                    }
                }
                i += step;
            }
            System.out.println(sqlString.toString());
            stmt = connection.createStatement();
            int updates = stmt.executeUpdate(sqlString.toString());
            if (updates != 1) {
                throw new SQLException("Not exactly one record affected by change!");
            }
            connection.commit();
            stmt.close();
            connection.setAutoCommit(true);
            this.data[row][column] = value;
        }
        catch (SQLException exception) {
            try {
                connection.rollback();
            }
            catch (Exception x) {
                // empty catch block
            }
            StringBuffer errors = new StringBuffer(1000);
            do {
                errors.append(exception.getMessage());
                errors.append('\n');
            } while ((exception = exception.getNextException()) != null);
            Helpers.showError(new SQLException(errors.toString()));
        }
        catch (Exception e) {
            Helpers.showError(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                connection.setAutoCommit(true);
            }
            catch (Exception ex) {}
            this.executing = false;
        }
        try {
            try {
                this.executing = true;
                this.fireTableColumnChangedInRows(column, row, row);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                Object var15_23 = null;
                this.executing = false;
            }
            Object var15_22 = null;
            this.executing = false;
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            this.executing = false;
            throw throwable;
        }
    }

    private boolean getQuotationMarksNeeded(int row, int column) {
        if (this.data[row][column] == null) {
            return this.getQuotationMarksNeeded(this.classes[column]);
        }
        return this.getQuotationMarksNeeded(this.data[row][column]);
    }

    private boolean getQuotationMarksNeeded(Object object) {
        if (object == null) {
            return false;
        }
        return this.getQuotationMarksNeeded(object.getClass());
    }

    private boolean getQuotationMarksNeeded(Class whatClass) {
        if (whatClass == null) {
            return false;
        }
        return whatClass != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TableDataModel.class$("java.lang.Boolean")) : class$java$lang$Boolean) && whatClass.getSuperclass() != (class$java$lang$Number == null ? (class$java$lang$Number = TableDataModel.class$("java.lang.Number")) : class$java$lang$Number);
    }

    public Object getValueAt(int row, int column) {
        return this.data[row][column];
    }

    public boolean isCellEditable(int row, int column) {
        return !this.executing;
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public int getColumnCount() {
        if (this.headers == null) {
            return 0;
        }
        return this.headers.length;
    }

    public String getColumnName(int column) {
        if (this.headers == null || this.headers.length <= column) {
            return null;
        }
        return this.headers[column];
    }

    public String[] getColumnNames() {
        return this.headers;
    }

    public Class getColumnClass(int column) {
        return this.classes[column];
    }

    public Class[] getColumnClasses() {
        return this.classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void retrieveTableData() {
        Connection connection;
        this.warnings = null;
        this.executing = true;
        this.fireStateChanged();
        Statement stmt = null;
        ResultSet rs = null;
        Connection connection2 = connection = this.readConnection;
        synchronized (connection2) {
            try {
                this.assessingSize = true;
                this.fireStateChanged();
                connection.setAutoCommit(true);
                stmt = connection.createStatement();
                rs = stmt.executeQuery("select count(*) from " + this.tableName);
                if (rs.next()) {
                    this.numberOfRecords = rs.getInt(1);
                }
                rs.close();
                int interval = this.numberOfRecords / 10;
                if (interval < 1) {
                    interval = 1;
                }
                this.assessingSize = false;
                this.fireStateChanged();
                rs = stmt.executeQuery("select * from " + this.tableName);
                ResultSetMetaData meta = rs.getMetaData();
                int size = meta.getColumnCount();
                this.headers = new String[size];
                int i = 1;
                while (i <= size) {
                    this.headers[i - 1] = meta.getColumnName(i);
                    ++i;
                }
                this.classes = new Class[size];
                int i2 = 1;
                while (i2 <= size) {
                    this.classes[i2 - 1] = TableDataModel.getClassForColumn(meta.getColumnType(i2));
                    ++i2;
                }
                ArrayList<Object[]> array = new ArrayList<Object[]>(1000);
                Object[] record = null;
                while (rs.next()) {
                    record = new Object[size];
                    int i3 = 1;
                    while (i3 <= size) {
                        record[i3 - 1] = rs.getObject(i3);
                        ++i3;
                    }
                    array.add(record);
                    ++this.numberOfRecordsRead;
                    if (this.numberOfRecordsRead % interval != 0) continue;
                    this.fireStateChanged();
                    this.fireTableRowsChanged(this.numberOfRecordsRead - interval, this.numberOfRecordsRead);
                }
                Object[] temp = array.toArray();
                this.data = new Object[temp.length][];
                System.arraycopy(temp, 0, this.data, 0, this.data.length);
                rs.close();
                stmt.close();
                rs = null;
                stmt = null;
            }
            catch (Exception sqle) {
                Helpers.showError(sqle);
                if (sqle instanceof SQLException) {
                    StringBuffer buffer = new StringBuffer(1000);
                    do {
                        buffer.append(sqle.getMessage());
                    } while ((sqle = ((SQLException)sqle).getNextException()) != null);
                    this.warnings = buffer.toString();
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {}
                this.fireEntireTableChanged();
                this.fireStateChanged();
                this.executing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteLines(int[] lineIndices) {
        if (lineIndices == null || lineIndices.length == 0) {
            return;
        }
        int step = this.headers.length / 10;
        if (step <= 0) {
            step = 1;
        }
        int smallest = 0;
        StringBuffer exceptions = new StringBuffer(1000);
        StringBuffer sql = null;
        boolean conditionSet = false;
        Connection connection = this.writeConnection;
        Statement stmt = null;
        try {
            connection.setReadOnly(false);
            connection.setAutoCommit(true);
            stmt = connection.createStatement();
        }
        catch (Exception e) {
            Helpers.showError(e);
            this.fireEntireTableChanged();
            return;
        }
        int i = 0;
        while (i < lineIndices.length) {
            if (lineIndices[i] < smallest) {
                smallest = lineIndices[i];
            }
            sql = new StringBuffer(300);
            sql.append("DELETE ");
            sql.append(" FROM ");
            sql.append(this.tableName);
            conditionSet = false;
            int j = 0;
            while (j < this.data[lineIndices[i]].length) {
                if (this.data[lineIndices[i]][j] != null && !(this.data[lineIndices[i]][j] instanceof Date)) {
                    if (conditionSet) {
                        sql.append(" AND");
                    }
                    if (!conditionSet) {
                        sql.append(" WHERE");
                    }
                    conditionSet = true;
                    sql.append(" ");
                    sql.append(this.headers[j]);
                    sql.append("=");
                    if (this.getQuotationMarksNeeded(lineIndices[i], j)) {
                        sql.append("'");
                    }
                    if (this.data[lineIndices[i]][j] instanceof Date) {
                        sql.append(TableDataModel.getSQLDate((Date)this.data[lineIndices[i]][j]));
                    } else {
                        sql.append(this.data[lineIndices[i]][j]);
                    }
                    if (this.getQuotationMarksNeeded(lineIndices[i], j)) {
                        sql.append("'");
                    }
                }
                j += step;
            }
            System.out.println(sql);
            Connection connection2 = connection;
            synchronized (connection2) {
                try {
                    boolean success = stmt.execute(sql.toString());
                    if (success) {
                        throw new SQLException("Unexpectly received a record set from the database!");
                    }
                    int updated = stmt.getUpdateCount();
                    if (updated > 1) {
                        throw new SQLException("More than one record affected by a command intended to affect just one record!");
                    }
                    connection.commit();
                    this.data[lineIndices[i]] = null;
                }
                catch (SQLException sqle) {
                    try {
                        connection.rollback();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    do {
                        exceptions.append(sqle.getMessage());
                        exceptions.append('\n');
                    } while ((sqle = sqle.getNextException()) != null);
                }
            }
            ++i;
        }
        try {
            stmt.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        int oldLength = this.data.length;
        Object[][] temp = new Object[this.data.length][];
        int nulls = 0;
        int tempIndex = 0;
        Object[][] objectArray = this.data;
        synchronized (this.data) {
            int i2 = 0;
            while (i2 < this.data.length) {
                if (this.data[i2] != null) {
                    temp[tempIndex] = this.data[i2];
                    ++tempIndex;
                } else {
                    ++nulls;
                }
                ++i2;
            }
            this.data = new Object[this.data.length - nulls][];
            System.arraycopy(temp, 0, this.data, 0, this.data.length);
            // ** MonitorExit[var14_22] (shouldn't be in output)
            String sqlErrors = exceptions.toString();
            if (sqlErrors.length() > 0) {
                JOptionPane.showMessageDialog(Helpers.getTopLevelContainer(), sqlErrors, "Fehler", 2);
            }
            this.fireEntireTableChanged();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertLine(Object[] lineData) throws SQLException {
        if (lineData == null) {
            return;
        }
        if (this.headers == null) {
            return;
        }
        if (lineData.length != this.headers.length) {
            throw new IllegalArgumentException("Data does not fit into model!");
        }
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append("INSERT INTO ");
        buffer.append(this.tableName);
        buffer.append(" (");
        boolean first = true;
        boolean needMarks = false;
        int i = 0;
        while (i < this.headers.length) {
            if (lineData[i] != null) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(this.headers[i]);
            }
            ++i;
        }
        buffer.append(") VALUES (");
        first = true;
        int i2 = 0;
        while (i2 < lineData.length) {
            if (lineData[i2] != null) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                needMarks = this.getQuotationMarksNeeded(lineData[i2]);
                if (needMarks) {
                    buffer.append("'");
                }
                if (lineData[i2] instanceof Date) {
                    buffer.append(TableDataModel.getSQLDate((Date)lineData[i2]));
                } else {
                    buffer.append(lineData[i2]);
                }
                if (needMarks) {
                    buffer.append("'");
                }
            }
            ++i2;
        }
        buffer.append(")");
        System.out.println(buffer);
        SQLException e = null;
        Connection connection = this.writeConnection;
        connection.setAutoCommit(false);
        Statement stmt = null;
        try {
            try {
                stmt = connection.createStatement();
                int updated = stmt.executeUpdate(buffer.toString());
                if (updated != 1) {
                    throw new SQLException("Not exactly one record affected by change!");
                }
                connection.commit();
            }
            catch (SQLException sqle) {
                e = sqle;
                connection.rollback();
                Object var12_14 = null;
                stmt.close();
                connection.setAutoCommit(true);
            }
            Object var12_13 = null;
            stmt.close();
            connection.setAutoCommit(true);
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            stmt.close();
            connection.setAutoCommit(true);
            throw throwable;
        }
        if (e != null) {
            throw e;
        }
        Object[][] temp = this.data;
        this.data = new Object[this.data.length + 1][];
        System.arraycopy(temp, 0, this.data, 0, temp.length);
        int insertIndex = this.data.length - 1;
        this.data[insertIndex] = lineData;
        this.fireTableChanged(new TableModelEvent(this, insertIndex, insertIndex, -1, 1));
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public int getNumberOfRecordsRead() {
        return this.numberOfRecordsRead;
    }

    public void doSort(String columnName) {
        if (!this.executing) {
            new TableSorter(columnName);
        }
    }

    private static Class getClassForColumn(int type) {
        switch (type) {
            case -5: {
                return class$java$lang$Number == null ? (class$java$lang$Number = TableDataModel.class$("java.lang.Number")) : class$java$lang$Number;
            }
            case -7: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = TableDataModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = TableDataModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 91: {
                return class$java$util$Date == null ? (class$java$util$Date = TableDataModel.class$("java.util.Date")) : class$java$util$Date;
            }
            case 3: {
                return class$java$lang$Double == null ? (class$java$lang$Double = TableDataModel.class$("java.lang.Double")) : class$java$lang$Double;
            }
            case 8: {
                return class$java$lang$Double == null ? (class$java$lang$Double = TableDataModel.class$("java.lang.Double")) : class$java$lang$Double;
            }
            case 6: {
                return class$java$lang$Float == null ? (class$java$lang$Float = TableDataModel.class$("java.lang.Float")) : class$java$lang$Float;
            }
            case 4: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = TableDataModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case -1: {
                return class$java$lang$String == null ? (class$java$lang$String = TableDataModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 2: {
                return class$java$lang$Number == null ? (class$java$lang$Number = TableDataModel.class$("java.lang.Number")) : class$java$lang$Number;
            }
            case 7: {
                return class$java$lang$Number == null ? (class$java$lang$Number = TableDataModel.class$("java.lang.Number")) : class$java$lang$Number;
            }
            case 5: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = TableDataModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 92: {
                return class$java$util$Date == null ? (class$java$util$Date = TableDataModel.class$("java.util.Date")) : class$java$util$Date;
            }
            case 93: {
                return class$java$util$Date == null ? (class$java$util$Date = TableDataModel.class$("java.util.Date")) : class$java$util$Date;
            }
            case -6: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = TableDataModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
        }
        return class$java$lang$String == null ? (class$java$lang$String = TableDataModel.class$("java.lang.String")) : class$java$lang$String;
    }

    private static String getSQLDate(Date date) {
        StringBuffer buffer = new StringBuffer(30);
        DateFormat formatter = DateFormat.getDateInstance(3, Locale.US);
        buffer.append(formatter.format(date));
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Object[][] access$402(TableDataModel x0, Object[][] x1) {
        x0.data = x1;
        return x1;
    }

    private class TableSorter
    extends Thread {
        private String headerValue = null;
        private int columnIndex = -1;

        TableSorter(String headerValue) {
            if (headerValue == null) {
                System.out.println("headerValue==null");
                return;
            }
            this.headerValue = headerValue;
            this.setPriority(10);
            this.setDaemon(false);
            this.start();
        }

        public void run() {
            boolean reverse;
            TableDataModel.this.executing = true;
            TableDataModel.this.fireStateChanged();
            this.columnIndex = this.getColumnIndex();
            if (this.columnIndex < 0) {
                System.out.println("columnIndex<0");
                TableDataModel.this.executing = false;
                TableDataModel.this.fireStateChanged();
                return;
            }
            Object[] values = new Object[TableDataModel.this.data.length];
            int i = 0;
            while (i < values.length) {
                values[i] = TableDataModel.this.data[i][this.columnIndex];
                ++i;
            }
            if (values == null || values.length == 0) {
                System.out.println("values==null||values.length==0");
                TableDataModel.this.executing = false;
                TableDataModel.this.fireStateChanged();
                return;
            }
            int[] indices = null;
            boolean bl = reverse = TableDataModel.this.lastSortedIndex == this.columnIndex + 1;
            if (values[0] instanceof Number) {
                Number[] numbers = new Number[values.length];
                System.arraycopy(values, 0, numbers, 0, values.length);
                indices = ArraySorter.sortNumbers(numbers);
            } else if (values[0] instanceof Date) {
                Date[] dates = new Date[values.length];
                System.arraycopy(values, 0, dates, 0, values.length);
                indices = ArraySorter.sortDates(dates);
            } else if (values[0] instanceof String) {
                String[] strings = new String[values.length];
                System.arraycopy(values, 0, strings, 0, values.length);
                indices = ArraySorter.sortStrings(strings);
            } else {
                indices = ArraySorter.sortObjects(values);
            }
            if (indices != null) {
                if (reverse) {
                    indices = ArraySorter.invert(indices);
                }
                this.establishNewOrder(indices);
            }
            TableDataModel.this.lastSortedIndex = 0;
            if (reverse) {
                TableDataModel.this.lastSortedIndex -= this.columnIndex + 1;
            } else {
                TableDataModel.this.lastSortedIndex += this.columnIndex + 1;
            }
            TableDataModel.this.executing = false;
            TableDataModel.this.fireStateChanged();
        }

        private int getColumnIndex() {
            int index = -1;
            int i = 0;
            while (i < TableDataModel.this.headers.length) {
                if (TableDataModel.this.headers[i].equals(this.headerValue)) {
                    index = i;
                    break;
                }
                ++i;
            }
            return index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void establishNewOrder(int[] indices) {
            Object[][] objectArray = TableDataModel.this.data;
            synchronized (objectArray) {
                Object[][] values = new Object[TableDataModel.this.data.length][];
                int i = 0;
                while (i < TableDataModel.this.data.length) {
                    values[i] = TableDataModel.this.data[indices[i]];
                    ++i;
                }
                TableDataModel.access$402(TableDataModel.this, values);
            }
            TableDataModel.this.fireTableRowsChanged(0, TableDataModel.this.data.length - 1);
        }
    }

    private class DataRetriever
    extends Thread {
        DataRetriever() {
            this.setName("Data Retriever for table " + TableDataModel.this.tableName);
            this.setPriority(3);
            this.setDaemon(true);
        }

        public void run() {
            TableDataModel.this.retrieveTableData();
        }
    }
}

