/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.apps.jdbc.swing.sql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class UniversalDriverWrapper
implements Driver {
    private static Set registry = new HashSet();
    private Driver wrappedDriver;

    public UniversalDriverWrapper(ClassLoader loader, String wrappedDriverClass) throws Exception {
        this.wrappedDriver = (Driver)Class.forName(wrappedDriverClass, true, loader).newInstance();
        DriverManager.registerDriver(this);
        registry.add(wrappedDriverClass);
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.wrappedDriver.acceptsURL(url);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        return this.wrappedDriver.connect(url, info);
    }

    public int getMajorVersion() {
        return this.wrappedDriver.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.wrappedDriver.getMinorVersion();
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.wrappedDriver.getPropertyInfo(url, info);
    }

    public boolean jdbcCompliant() {
        return this.wrappedDriver.jdbcCompliant();
    }

    public static Object[] getRegisteredDrivers() {
        Enumeration<Driver> e = DriverManager.getDrivers();
        String driverClass = null;
        while (e.hasMoreElements()) {
            driverClass = e.nextElement().getClass().getName();
            if (driverClass.startsWith("lindhorst.apps.jdbc.swing.sql")) continue;
            registry.add(driverClass);
        }
        return registry.toArray();
    }

    public static void registerDriverClassName(String className) {
        if (className == null) {
            return;
        }
        registry.add(className);
    }
}

