/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.swing.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PLaFMenu
extends JMenu {
    private int anzahl;
    private UIManager.LookAndFeelInfo[] lf;
    ViewSwitcher switcher = null;

    public PLaFMenu() {
        super("Look&Feel");
        this.setMnemonic('L');
        this.lf = UIManager.getInstalledLookAndFeels();
        this.anzahl = this.lf.length;
        int i = 0;
        while (i < this.anzahl) {
            block7: {
                try {
                    Class.forName(this.lf[i].getClassName());
                }
                catch (ClassNotFoundException exception) {
                    System.err.println("No such class: " + this.lf[i].getClassName() + " - Look & Feel removed from Menu");
                    break block7;
                }
                ImageIcon icon = null;
                if (this.lf[i].getName().equalsIgnoreCase("Metal")) {
                    icon = this.getImageResource("javaicon.gif");
                }
                if (this.lf[i].getName().equalsIgnoreCase("CDE/Motif")) {
                    icon = this.getImageResource("motificon.gif");
                }
                if (this.lf[i].getName().equalsIgnoreCase("Windows")) {
                    icon = this.getImageResource("winicon.gif");
                }
                if (this.lf[i].getName().equalsIgnoreCase("Kunststoff")) {
                    icon = this.getImageResource("plasticicon.gif");
                }
                JMenuItem item = icon != null ? new JMenuItem(this.lf[i].getName(), icon) : new JMenuItem(this.lf[i].getName());
                item.setMnemonic(this.lf[i].getName().charAt(0));
                this.add(item);
            }
            ++i;
        }
    }

    public PLaFMenu(Component target) {
        this();
        this.setTarget(target);
    }

    public void setTarget(Component target) {
        this.switcher = new ViewSwitcher(target, this);
    }

    public void addActionListener(ActionListener listener) {
        if (this.getMenuComponentCount() == 0) {
            return;
        }
        int i = 0;
        while (i < this.getMenuComponentCount()) {
            ((JMenuItem)this.getMenuComponent(i)).addActionListener(listener);
            ++i;
        }
    }

    public int getLookAndFeelCount() {
        return this.anzahl;
    }

    public boolean isEmpty() {
        return this.anzahl == 0;
    }

    public UIManager.LookAndFeelInfo[] getItems() {
        return this.lf;
    }

    /*
     * WARNING - void declaration
     */
    private ImageIcon getImageResource(String filename) {
        ImageIcon icon = null;
        try {
            int b;
            InputStream io = this.getClass().getResourceAsStream(filename);
            ByteArrayOutputStream toBytes = new ByteArrayOutputStream(1100);
            while ((b = io.read()) != -1) {
                void var5_6;
                toBytes.write((int)var5_6);
            }
            byte[] daten = toBytes.toByteArray();
            icon = new ImageIcon(daten);
            return icon;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new ImageIcon(this.getClass().getResource(filename));
        }
    }

    static {
        String windowsLook = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        String macLook = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
        String kunststoff = "com.incors.plaf.kunststoff.KunststoffLookAndFeel";
        boolean hasWindows = false;
        boolean hasMac = false;
        boolean hasPlastic = false;
        UIManager.LookAndFeelInfo[] lfs = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < lfs.length) {
            if (lfs[i].getClassName().equals(windowsLook)) {
                hasWindows = true;
            }
            if (lfs[i].getClassName().equals(macLook)) {
                hasMac = true;
            }
            if (lfs[i].getClassName().equals(kunststoff)) {
                hasPlastic = true;
            }
            ++i;
        }
        try {
            if (!hasWindows) {
                UIManager.installLookAndFeel("Windows", windowsLook);
            }
            if (!hasMac) {
                UIManager.installLookAndFeel("Macintosh", macLook);
            }
            if (!hasPlastic) {
                UIManager.installLookAndFeel("Kunststoff", kunststoff);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    static class ViewSwitcher
    implements ActionListener {
        private PLaFMenu menu;
        private Component target;
        private UIManager.LookAndFeelInfo[] lf;

        ViewSwitcher(Component theTarget, PLaFMenu theMenu) {
            this.menu = theMenu;
            this.menu.addActionListener(this);
            this.target = theTarget;
            this.lf = this.menu.getItems();
        }

        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            int i = 0;
            while (i < this.lf.length) {
                if (command.equalsIgnoreCase(this.lf[i].getName())) {
                    String klasse = this.lf[i].getClassName();
                    try {
                        UIManager.setLookAndFeel(klasse);
                        SwingUtilities.updateComponentTreeUI(this.target);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e.getMessage(), e.getClass().toString(), 0);
                    }
                    break;
                }
                this.target.repaint(0L);
                this.target.validate();
                ++i;
            }
        }
    }
}

