/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import lindhorst.swing.menu.*;
import lindhorst.apps.jdbc.swing.action.*;
import lindhorst.apps.jdbc.swing.helpers.*;
import lindhorst.apps.jdbc.swing.info.*;

public class JavaSQL extends JFrame
{
  private AppPane desktop=null;

  public JavaSQL()
  {
    super(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("JavaSQL"));
    desktop=new AppPane();
    setSize(600,450);
    setIconImage(Helpers.getImage(this.getClass(),"jsql.gif"));
    //fr FehlerMeldungen
    Helpers.setTopLevelContainer(this);
    addWindowListener(new Exiter());

    JPanel panel=new JPanel(new BorderLayout());
    panel.add(createAppToolBar(),BorderLayout.NORTH);
    panel.add(desktop,BorderLayout.CENTER);

    setJMenuBar(createAppMenuBar());

    setContentPane(panel);

    pack();

    Helpers.doCenterWindow(this);
    setVisible(true);
  }

  private JToolBar createAppToolBar()
  {
    AppToolBar bar=new AppToolBar(SwingConstants.HORIZONTAL);
    bar.add(new NewAction(desktop));
    //bar.add(new JSeparator(SwingConstants.VERTICAL));
    bar.add(new OpenSessionAction(desktop));
    bar.add(new SaveSessionAction(desktop));
    bar.add(new CloseSessionAction(desktop));

    return bar;
  }

  private JMenuBar createAppMenuBar()
  {
    JMenuBar bar=new JMenuBar();

    JMenu menu=new JMenu(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("session"));
    menu.setMnemonic('S');
    menu.add(new NewAction(desktop));
    menu.add(new JSeparator(SwingConstants.HORIZONTAL));
    menu.add(new OpenSessionAction(desktop));
    menu.add(new SaveSessionAction(desktop));
    menu.add(new JSeparator(SwingConstants.HORIZONTAL));
    menu.add(new CloseSessionAction(desktop));
    menu.add(new JSeparator(SwingConstants.HORIZONTAL));
    JMenuItem item=new JMenuItem(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("end"));
    item.setMnemonic('B');
    item.addActionListener(new Exiter());
    menu.add(item);
    bar.add(menu);

    menu=new JMenu(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("view"));
    menu.setMnemonic('A');
    menu.add(new PLaFMenu(this));
    bar.add(menu);

    menu=new JMenu(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("help"));
    menu.setMnemonic('?');
    item=new JMenuItem(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/JavaSQL").getString("info"));
    item.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent ae)
      {
        InfoDialog dialog=new InfoDialog();
        dialog.pack();
        Dimension dtDims=desktop.getSize();
        Dimension dgDims=dialog.getPreferredSize();
        dialog.setBounds((dtDims.width-dgDims.width)/2,(dtDims.height-dgDims.height)/2,dgDims.width,dgDims.height);
        desktop.add(dialog,AppPane.DIALOG_LAYER);
        dialog.setVisible(true);
        dialog.moveToFront();
        try
        {
          dialog.setSelected(true);
        }
        catch(Exception exception)
        {
          exception.printStackTrace(System.err);
        }
      }
    });
    menu.add(item);
    bar.add(menu);

    return bar;
  }

  public static void main(String[] args) throws Exception
  {
    //Dieser Eigenschaft mu gesetzt werden, um Schwierigkeiten mit ScrollPanes
    //zu verhindern
    System.getProperties().put("sun.java2d.noddraw","");

    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    new JavaSQL();
  }

  private class Exiter extends WindowAdapter implements ActionListener
  {
    public void windowClosing(WindowEvent event)
    {
      setVisible(false);
      desktop.closeAll();
      dispose();
      System.exit(0);
    }

    public void actionPerformed(ActionEvent event)
    {
      setVisible(false);
      desktop.closeAll();
      dispose();
      System.exit(0);
    }
  }
}
