/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.sql.*;
import lindhorst.apps.jdbc.swing.helpers.*;
import lindhorst.apps.jdbc.swing.sql.*;

public class LogInDialog extends JDialog implements ActionListener {
    private JTextField url;
    private JTextField user;
    private JTextField password;
    private JComboBox driver;
    private JTextField classPathExt;
    private Properties props=null;
    private boolean properlyClosed=false;
    
    public LogInDialog(Frame parent, boolean modal) {
        super(parent==null?(Frame)Helpers.getTopLevelContainer():parent,java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("login"),modal);
        init();
    }
    
    public LogInDialog(Frame parent) {
        this(parent,true);
    }
    
    public LogInDialog() {
        this((Frame)null, true);
    }
    
    private void init() {
        JPanel entries=new JPanel(new GridLayout(6,2,10,10));
        JLabel lab=new JLabel("JDBC-URL:",SwingConstants.LEFT);
        url=new JTextField();
        entries.add(lab);
        entries.add(url);
        lab=new JLabel(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("user"),SwingConstants.LEFT);
        user=new JTextField();
        entries.add(lab);
        entries.add(user);
        lab=new JLabel(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("password"),SwingConstants.LEFT);
        password=new JPasswordField();
        entries.add(lab);
        entries.add(password);
        lab=new JLabel(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("cp_extension"),SwingConstants.LEFT);
        classPathExt=new JTextField();
        classPathExt.setColumns(20);
        entries.add(lab);
        
        GridBagLayout lm=new GridBagLayout();
        JPanel classPathPane=new JPanel(lm);
        GridBagConstraints gbc=new GridBagConstraints(0,0,1,1,5.0,1.0,GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0);
        lm.setConstraints(classPathExt,gbc);
        classPathPane.add(classPathExt);
        gbc=new GridBagConstraints(1,0,1,1,1.0,1.0, GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0);
        JButton pathSelector=new JButton("...");
        pathSelector.setActionCommand("choosepath");
        lm.setConstraints(pathSelector,gbc);
        classPathPane.add(pathSelector);
        entries.add(classPathPane);
        
        //defaults
        String value=null;
        if(props!=null) {
            value=props.getProperty("jdbcsession.url");
            url.setText( (value!=null)? value:"");
            value=props.getProperty("jdbcsession.service");
            value=props.getProperty("jdbcsession.user");
            user.setText( (value!=null)? value:"");
            value=props.getProperty("jdbcsession.password");
            password.setText( (value!=null)? value:"");
            value=props.getProperty("jdbcsession.classpathextension");
            classPathExt.setText( (value!=null)? value:"");
            value=props.getProperty("jdbcsession.driver");
            if(value!=null) {
                try {
                    Class.forName(value);
                }
                catch(Exception e) {
                }
            }
        }
        lab=new JLabel(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("driverclass"), SwingConstants.LEFT);
        
        UniversalDriverWrapper.registerDriverClassName(value);
        driver=new JComboBox(UniversalDriverWrapper.getRegisteredDrivers());
        if(value!=null) driver.setSelectedItem(value);
        driver.setEditable(true);
        entries.add(lab);
        entries.add(driver);
        
        JPanel entriesWrapper=new JPanel();
        entriesWrapper.setLayout(new BoxLayout(entriesWrapper,BoxLayout.Y_AXIS));
        entriesWrapper.add(Box.createVerticalGlue());
        entriesWrapper.add(entries);
        entriesWrapper.add(Box.createVerticalGlue());
        
        
        JPanel areaWrapper=new JPanel(new BorderLayout(20,3));
        areaWrapper.add(entriesWrapper,BorderLayout.EAST);
        lab=new JLabel(Helpers.getIcon(getClass(),"dbpic.gif"));
        areaWrapper.add(lab,BorderLayout.WEST);
        areaWrapper.add(new JSeparator(SwingConstants.VERTICAL),BorderLayout.SOUTH);
        
        JPanel buttons=new JPanel(new GridLayout(1,2,10,10));
        JButton button=new JButton(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("ok"));
        button.setVerticalTextPosition(SwingConstants.CENTER);
        button.setHorizontalTextPosition(SwingConstants.LEFT);
        button.setMnemonic('O');
        button.addActionListener(this);
        buttons.add(button);
        button=new JButton(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("cancel"));
        button.setVerticalTextPosition(SwingConstants.CENTER);
        button.setHorizontalTextPosition(SwingConstants.RIGHT);
        button.setMnemonic('A');
        button.addActionListener(this);
        buttons.add(button);
        JPanel buttonsWrapper=new JPanel(new FlowLayout(FlowLayout.CENTER));
        buttonsWrapper.add(buttons);
        
        //more listeners
        pathSelector.addActionListener(this);
        classPathExt.addActionListener(this);
        password.addActionListener(this);
        url.addActionListener(this);
        user.addActionListener(this);
        
        JPanel all=new JPanel(new BorderLayout(20,20));
        all.setBorder(BorderFactory.createEmptyBorder(20,20,20,20));
        all.add(areaWrapper,BorderLayout.CENTER);
        all.add(buttonsWrapper,BorderLayout.SOUTH);
        
        all.add(lab,BorderLayout.WEST);
        setContentPane(all);
        
        pack();
        Helpers.doCenterWindow(this);
        setResizable(false);
        
        password.requestFocus();
    }
    
    public void setProperties(Properties props) {
        this.props=props;
        init();
    }
    
    public void setProperties(Properties props, String sessionName) {
        this.props=props;
        init();
    }
    
    public Properties getProperties() {
        return props;
    }
    
    public void actionPerformed(ActionEvent event) {
        if(event.getActionCommand().equalsIgnoreCase(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/LoginDialog").getString("cancel"))) {
            properlyClosed=false;
            setVisible(false);
            return;
        }
        
        if(event.getActionCommand().equalsIgnoreCase("choosepath")) {
            PathExtensionDialog dialog=new PathExtensionDialog(classPathExt.getText());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            classPathExt.setText(dialog.getPath());
            return;
        }
        
        //OK geklickt!
        setVisible(false);
        properlyClosed=true;
        
        if(url==null||props==null) props=new Properties();
        
        String value=url.getText();
        props.put("jdbcsession.url", value!=null?value:"");
        value=password.getText();
        props.put("jdbcsession.password", value!=null?value:"");
        value=user.getText();
        props.put("jdbcsession.user", value!=null?value:"");
        value=classPathExt.getText();
        props.put("jdbcsession.classpathextension", value!=null?value:"");
        value=(String)driver.getSelectedItem();
        props.put("jdbcsession.driver",value!=null?value:"");
    }
    
    public boolean isProperlyClosed() {
        return properlyClosed;
    }
    
}
