/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */
/*
 * PathExtensionDialog.java
 *
 * Created on 11. November 2002, 23:39
 */

package lindhorst.apps.jdbc.swing;

import javax.swing.event.*;
import javax.swing.*;
import java.io.*;
import java.util.*;

/**
 *
 * @author  lindhrst
 */
public class PathExtensionDialog extends javax.swing.JDialog {
    private File[] pathItems=null;
    private File[] defaultItems=null;
    private javax.swing.JList itemList=null;
    private JButton okButton;
    private JButton delEntry;
    private static final int ARCHIVE=0;
    private static final int DIR=1;
    
    public PathExtensionDialog() {
        this((String)null);
    }
    
    public PathExtensionDialog(String path) {
        this(splitPath(path));
    }
    
    public PathExtensionDialog(File[] items) {
        setPathItems(items);
        defaultItems=pathItems;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        javax.swing.JScrollPane scroller;
        javax.swing.JPanel innerButtonPane;
        javax.swing.JPanel innerPathButtonPane;
        javax.swing.JPanel pathButtonPane;
        javax.swing.JButton cancelButton;
        javax.swing.JButton addDir;
        javax.swing.JButton addLib;
        javax.swing.JPanel buttonPane;
        scroller = new javax.swing.JScrollPane();
        itemList = new javax.swing.JList();
        buttonPane = new javax.swing.JPanel();
        innerButtonPane = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        pathButtonPane = new javax.swing.JPanel();
        innerPathButtonPane = new javax.swing.JPanel();
        addLib = new javax.swing.JButton();
        addDir = new javax.swing.JButton();
        delEntry = new javax.swing.JButton();
        
        scroller.setName("scroller");
        itemList.setName("itemList");
        scroller.setViewportView(itemList);
        
        getContentPane().add(scroller, java.awt.BorderLayout.CENTER);
        
        buttonPane.setName("outerButtonPane");
        innerButtonPane.setLayout(new java.awt.GridLayout(1, 3));
        
        innerButtonPane.setName("innerOkCancel");
        okButton.setText(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("ok"));
        okButton.setName("ok");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okbuttonActionPerformed(evt);
            }
        });
        
        innerButtonPane.add(okButton);
        
        cancelButton.setName("cancel");
        cancelButton.setText(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("cancel"));
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        
        innerButtonPane.add(cancelButton);
        
        buttonPane.add(innerButtonPane);
        
        getContentPane().add(buttonPane, java.awt.BorderLayout.SOUTH);
        
        pathButtonPane.setLayout(new javax.swing.BoxLayout(pathButtonPane, javax.swing.BoxLayout.Y_AXIS));
        
        pathButtonPane.setName("okCancelPane");
        innerPathButtonPane.setLayout(new java.awt.GridLayout(3, 1));
        
        innerPathButtonPane.setName("innerButtons");
        addLib.setText(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("zip/jar"));
        addLib.setName("addLib");
        addLib.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addLibActionPerformed(evt);
            }
        });
        
        innerPathButtonPane.add(addLib);
        
        addDir.setText(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("directory"));
        addDir.setName("addDir");
        addDir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addDirActionPerformed(evt);
            }
        });
        
        innerPathButtonPane.add(addDir);
        
        delEntry.setText(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("delEntry"));
        delEntry.setName("erase");
        delEntry.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                delEntryActionPerformed(evt);
            }
        });
        
        innerPathButtonPane.add(delEntry);
        
        pathButtonPane.add(innerPathButtonPane);
        
        getContentPane().add(pathButtonPane, java.awt.BorderLayout.EAST);
        
        //final adjustments to component state
        okButton.setEnabled(false);
        delEntry.setEnabled(false);
        updateFileList();
        pack();
        setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        setModal(true);
    }
    
    /* Event Handlers */
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {
        pathItems=defaultItems;
        setVisible(false);
    }
    
    private void okbuttonActionPerformed(java.awt.event.ActionEvent evt) {
        setVisible(false);
    }
    
    private void delEntryActionPerformed(java.awt.event.ActionEvent evt) {
        int index=itemList.getSelectedIndex();
        File[] newItems=new File[pathItems.length-1];
        System.arraycopy(pathItems,0,newItems,0,index);
        System.arraycopy(pathItems,index+1,newItems,index,pathItems.length-index-1);
        pathItems=newItems;
        updateFileList();
    }
    
    private void addDirActionPerformed(java.awt.event.ActionEvent evt) {
        File selection=selectFileOnGUI(DIR);
        if(selection!=null) {
            int itemLength=0;
            if(pathItems!=null) {
                itemLength=pathItems.length;
            }
            itemLength++;
            File[] newItems=new File[itemLength];
            if(pathItems!=null) {
                System.arraycopy(pathItems,0,newItems,0,pathItems.length);
            }
            newItems[itemLength-1]=selection;
            pathItems=newItems;
            updateFileList();
        }
    }
    
    private void addLibActionPerformed(java.awt.event.ActionEvent evt) {
        File selection=selectFileOnGUI(ARCHIVE);
        if(selection!=null) {
            int itemLength=0;
            if(pathItems!=null) {
                itemLength=pathItems.length;
            }
            itemLength++;
            File[] newItems=new File[itemLength];
            if(pathItems!=null) {
                System.arraycopy(pathItems,0,newItems,0,pathItems.length);
            }
            newItems[itemLength-1]=selection;
            pathItems=newItems;
            updateFileList();
        }
    }
    
    
    public File[] getPathItems() {
        if(pathItems==null) {
            return new File[0];
        }
        return pathItems;
    }
    
    public void setPathItems(File[] items) {
        this.pathItems=items;
    }
    
    public void setPath(String systemStylePath) {
        setPathItems(splitPath(systemStylePath));
    }
    
    public String getPath() {
        if(pathItems==null) {
            return "";
        }
        return joinPath(pathItems);
    }
    
    private void updateFileList() {
        if(itemList==null) {
            itemList=new JList();
        }
        itemList.setModel(new AbstractListModel(){
            public Object getElementAt(int i) {
                return pathItems[i];
            }
            public int getSize() {
                return pathItems==null?0:pathItems.length;
            }
        });
        itemList.getSelectionModel().addListSelectionListener(new PathExtensionDialog.ButtonEnabler());
        okButton.setEnabled(defaultItems!=pathItems);
    }
    
    private static File[] splitPath(String path) {
        StringTokenizer tokenizer=new StringTokenizer(path,File.pathSeparator,false);
        ArrayList files=new ArrayList(10);
        while(tokenizer.hasMoreTokens()) {
            files.add(new File(tokenizer.nextToken()));
        }
        Object[] array=files.toArray();
        File[] fileArray=new File[array.length];
        System.arraycopy(array,0,fileArray,0,array.length);
        return fileArray;
    }
    
    private static String joinPath(File[] items) {
        StringBuffer buffer=new StringBuffer(items.length*30);
        for(int i=0;i<items.length;i++) {
            buffer.append(items[i]);
            if(i<items.length-1) {
                buffer.append(File.pathSeparatorChar);
            }
        }
        return buffer.toString();
    }
    
    private static File selectFileOnGUI(int whatType) {
        JFileChooser chooser=new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        if(whatType==ARCHIVE) {
            chooser.setFileFilter(new PathExtensionDialog.ArchiveFilter());
        }
        else {
            chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        }
        
        int retVal=chooser.showOpenDialog(null);
        if(retVal==JFileChooser.APPROVE_OPTION) {
            return chooser.getSelectedFile();
        }
        else {
            return null;
        }
    }
    
    private class ButtonEnabler implements ListSelectionListener{
        
        /**
         * Called whenever the value of the selection changes.
         * @param e the event that characterizes the change.
         */
        public void valueChanged(ListSelectionEvent e) {
            delEntry.setEnabled(itemList.getSelectedValues().length>0);
        }
        
    }
    
    private static class ArchiveFilter extends javax.swing.filechooser.FileFilter{
        
        /** Tests whether or not the specified abstract pathname should be
         * included in a pathname list.
         *
         * @param  pathname  The abstract pathname to be tested
         * @return  <code>true</code> if and only if <code>pathname</code>
         *          should be included
         */
        public boolean accept(File pathname) {
            String suffix=pathname.getAbsolutePath();
            suffix=suffix.substring(suffix.length()-3,suffix.length());
            return suffix.equalsIgnoreCase("jar")||suffix.equalsIgnoreCase("zip")||pathname.isDirectory();
        }
        
        /** The description of this filter. For example: "JPG and GIF Images"
         * @see FileView#getName
         */
        public String getDescription() {
            return java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/PathExtensionDialog").getString("Archive_File");
        }
        
    }
}
