/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing.action;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import lindhorst.apps.jdbc.swing.*;
import java.util.*;
import java.beans.*;

public abstract class Action implements javax.swing.Action
{
  public static final String LARGE_ICON="LargeIcon";
  private AppPane target;
  private Hashtable hash=new Hashtable();
  private EventListenerList listeners=new EventListenerList();
  private boolean enabled=true;

  protected Action(AppPane target)
  {
    this.target=target;
  }

  protected abstract void fulfillMission();

  public AppPane getTarget()
  {
    return target;
  }

  public void actionPerformed(ActionEvent event)
  {
    fulfillMission();
  }

  public void setEnabled(boolean b)
  {
    enabled=b;
  }

  public boolean isEnabled()
  {
    return enabled;
  }

  public void removePropertyChangeListener(PropertyChangeListener listener)
  {
    listeners.remove(PropertyChangeListener.class,listener);
  }

  public void addPropertyChangeListener(PropertyChangeListener listener)
  {
    listeners.add(PropertyChangeListener.class,listener);
  }

  public void putValue(String key, Object value)
  {
    Object oldValue=hash.get(key);
    hash.put(key,value);
    firePropertyChangeEvent(key,oldValue,value);
  }

  public Object getValue(String key)
  {
    return hash.get(key);
  }

  private void firePropertyChangeEvent(String key, Object oldValue, Object newValue)
  {
    EventListener[] array=listeners.getListeners(PropertyChangeListener.class);
    PropertyChangeEvent event = new PropertyChangeEvent(this,key,oldValue,newValue);

    for(int i=0;i<array.length;i++) {
      ((PropertyChangeListener)array[i]).propertyChange(event);
    }
  }
}