/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing.action;

import lindhorst.apps.jdbc.swing.*;
import java.io.*;
import java.util.Properties;
import lindhorst.apps.jdbc.swing.helpers.*;

public class OpenSessionAction extends Action
{

  public OpenSessionAction(AppPane target)
  {
    super(target);
    putValue(Action.NAME,java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/actions").getString("open"));
    putValue(Action.SHORT_DESCRIPTION, java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/actions").getString("open.tip"));
    putValue(Action.LONG_DESCRIPTION,java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/actions").getString("open.tip.long"));
    putValue(Action.SMALL_ICON, Helpers.getIcon(getClass(),"open16x16.gif"));
    putValue(Action.LARGE_ICON, Helpers.getIcon(getClass(),"open32x32.gif"));
  }

  public void fulfillMission()
  {
    try
    {
      File file=Helpers.showOpenFileDialog();
      if (file==null) return;
      Properties props=new Properties();
      props.load(new FileInputStream(file));
      props.put("jdbcsession.file",file.getAbsolutePath());
      getTarget().createSession(props);
    }
    catch(Exception e)
    {
      Helpers.showError(e);
    }
  }
} 