/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing.administration;

import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import lindhorst.apps.jdbc.swing.data.*;

public class ModuleAdministration extends JInternalFrame
{
  private SessionDataModel model=null;
  private boolean tabbedView=true;

  public ModuleAdministration(SessionDataModel model)
  {
    super(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/administration").getString("modules"),true,false,true,true);
    setOpaque(false);
    this.model=model;
    //model.addChangeListener(this);
    init();
  }

  private void init()
  {
    if(tabbedView)setContentPane(new TabbedModuleView(model));
    pack();
  }
}
