/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing.info;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import lindhorst.apps.jdbc.swing.*;
import lindhorst.apps.jdbc.swing.helpers.*;

public class InfoDialog extends JInternalFrame implements ActionListener
{

  public InfoDialog()
  {
    super("Information");
    setFrameIcon(Helpers.getIcon(JavaSQL.class,"jsql.gif"));
    setTitle("Information");

    Box box=Box.createVerticalBox();
    JPanel labelPanel=new JPanel(new FlowLayout(FlowLayout.CENTER));
    JLabel jComp=new JLabel(Helpers.getIcon(getClass(),"logo.jpg"));
    jComp.setBorder(BorderFactory.createEtchedBorder());
    labelPanel.setBorder(BorderFactory.createEmptyBorder(30,40,10,40));
    labelPanel.add(jComp);
    box.add(labelPanel);
    JPanel info=new JPanel(new FlowLayout(FlowLayout.CENTER));
    jComp=new JLabel("JavaSQL");
    jComp.setHorizontalAlignment(SwingConstants.CENTER);
    Font f=jComp.getFont();
    int size=f.getSize();
    String name=f.getName();
    jComp.setFont(new Font(name,Font.BOLD,2*size));
    info.setBorder(BorderFactory.createEmptyBorder(20,40,5,40));
    info.add(jComp);
    box.add(info);
    
    JPanel author=new JPanel(new GridLayout(3,1));
    jComp=new JLabel("Autor: Alexander Lindhorst", JLabel.CENTER);
    author.add(jComp);
    jComp=new JLabel("Version 1.2", JLabel.CENTER);
    author.add(jComp);
    jComp=new JLabel("Lizenz: GPL 2.0", JLabel.CENTER);
    author.add(jComp);
    author.setBorder(BorderFactory.createEmptyBorder(5,40,30,40));
    box.add(author);
    JPanel buttonPane=new JPanel(new FlowLayout(FlowLayout.CENTER));
    JButton ok=new JButton("Ok");
    ok.setMnemonic('O');
    ok.addActionListener(this);
    buttonPane.add(ok);
    box.add(buttonPane);

    getContentPane().add(box);
    //setPreferredSize(new Dimension(getPreferredSize().width*2,(int)(getPreferredSize().height*1.5)));
  }

  public void actionPerformed(ActionEvent event)
  {
    try
    {
      setClosed(true);
    }
    catch(Exception e)
    {
    }
    dispose();
  }
}