/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing.info;

import javax.swing.*;
import java.awt.*;

import lindhorst.apps.jdbc.swing.helpers.*;
import lindhorst.apps.jdbc.swing.event.*;
import java.io.*;

public class LoggingStatusDialog extends JWindow {
    private int eventStatus=-1;
    private JPanel loginPanel=null;
    private JPanel logoutPanel=null;
    
    public LoggingStatusDialog() {
        super(Helpers.getTopLevelContainer());
        
        JLabel status=new JLabel("Verbinde mit Datenbank ...");
        status.setBorder(BorderFactory.createEmptyBorder(30,15,30,30));
        JPanel pane=new JPanel(new FlowLayout(FlowLayout.CENTER));
        pane.setBorder(BorderFactory.createRaisedBevelBorder());
        
        pane.add(getIcon());
        pane.add(status);
        
        loginPanel=pane;
        loginPanel.setSize(loginPanel.getPreferredSize());

        status=new JLabel("Lse Verbindung mit Datenbank ...");
        status.setBorder(BorderFactory.createEmptyBorder(30,15,30,30));
        pane=new JPanel(new FlowLayout(FlowLayout.CENTER));
        pane.setBorder(BorderFactory.createRaisedBevelBorder());
        
        pane.add(getIcon());
        pane.add(status);
        
        logoutPanel=pane;
        logoutPanel.setSize(loginPanel.getPreferredSize());
    }
    
    public void setDialogType(int eventType) {
        eventStatus=eventType;
    }
    
    public int getDialogType() {
        return eventStatus;
    }
    
    public void reactToEvent() {
        switch(eventStatus) {
            case LoginEvent.LOGIN_EVENT:
                showLoginDialog();
                toFront();
                break;
            case LoginEvent.LOGOUT_EVENT:
                showLogoutDialog();
                toFront();
                break;
            default:
                setVisible(false);
        }
    }
    
    public void showLogoutDialog() {
        setContentPane(logoutPanel);
        pack();
        Helpers.doCenterWindow(this);
        setVisible(true);
        repaint(0L);
    }
    
    public void showLoginDialog() {
        setContentPane(loginPanel);
        pack();
        Helpers.doCenterWindow(this);
        setVisible(true);
        repaint(0L);
    }
    
    private static JComponent getIcon() {
        JComponent icon=null;
        
        try {
            InputStream in=LoggingStatusDialog.class.getResourceAsStream("connect.gif");
            ByteArrayOutputStream out=new ByteArrayOutputStream(50*1024);
            int b;
            while((b=in.read())!=-1)
                out.write(b);
            
            ImageIcon picture=new ImageIcon(out.toByteArray());
            if(picture!=null) {
                icon=new JLabel(picture);
                icon.setBorder(BorderFactory.createEmptyBorder(30,30,30,15));
            }
            else icon=new JComponent() {
            };
        }
        catch(Exception e) {
            e.printStackTrace(System.err);
        }
        
        return icon;
    }
}
