/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing.modules;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.sql.*;
import java.io.*;
import lindhorst.apps.jdbc.swing.modules.datamodels.*;
import lindhorst.apps.jdbc.swing.helpers.*;
import lindhorst.apps.jdbc.swing.*;

public class Queries extends JInternalFrame implements ChangeListener, Module
{
  private JTable table=new JTable(1,1);
  private JPanel out=new JPanel(new BorderLayout(0,0));;
  private JTextArea errors=new JTextArea();
  private QueriesDataModel model=null;
  private String name=null;

  public Queries(QueriesDataModel model, String name)
  {
    super(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("queries"),true,true,true,true);
    this.name=name;
    setTitle(name);
    setFrameIcon(Helpers.getIcon(getClass(),"queries.gif"));
    setOpaque(false);
    this.model=model;
    model.addChangeListener(this);

    init();
    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    setVisible(true);
    validate();
  }

  public Queries(Connection readableConnection,Connection writableConnection, String name)
  {
    this(new QueriesDataModel(readableConnection,writableConnection),name);
  }

  public void init()
  {
    out.setBorder(BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("db_output")));
    table.setModel(model.getTableModelFromOutput());
    table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    JScrollPane tableView=new JScrollPane(table);
    tableView.setPreferredSize(new Dimension(400,350));
    out.add(tableView,BorderLayout.CENTER);
    JSplitPane pane=new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,false);
    pane.setOneTouchExpandable(true);
    pane.add(out);

    Box box2=Box.createVerticalBox();

    JPanel err=new JPanel(new BorderLayout());
    err.setBorder(BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("sql_errors")));
    errors.setLineWrap(true);
    errors.setWrapStyleWord(true);
    JScrollPane errView=new JScrollPane(errors,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    errView.setPreferredSize(new Dimension(100,200));
    errors.setEditable(false);
    err.add(errView,BorderLayout.CENTER);
    box2.add(err);

    pane.add(box2);

    pane.resetToPreferredSizes();


    JPanel c=new JPanel(new BorderLayout(5,5));
    c.setLayout(new BorderLayout(10,10));
    c.add(pane, BorderLayout.CENTER);

    setContentPane(c);

  }

  public QueriesDataModel getModel()
  {
    return model;
  }

  public void setModel(QueriesDataModel model)
  {
    this.model=model;
    model.addChangeListener(this);
  }

  public void stateChanged(ChangeEvent event)
  {
    if(model.isExecuting())
      Helpers.setCursor(this,Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    //Textfelder fllen
    String warnings=model.getWarnings();
    errors.setText(warnings!=null?warnings:"");
    //Tabelle initialisieren
    table.setModel(model.getTableModelFromOutput());
    table.validate();
    if(!model.isExecuting()) Helpers.setCursor(this,Cursor.getDefaultCursor());
  }

}

